/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient;

import brave.http.HttpClientAdapter;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import zipkin2.Endpoint;

final class HttpAdapter
extends HttpClientAdapter<HttpRequestWrapper, HttpResponse> {
    HttpAdapter() {
    }

    public boolean parseServerAddress(HttpRequestWrapper httpRequest, Endpoint.Builder builder) {
        HttpHost target = httpRequest.getTarget();
        if (target == null) {
            return false;
        }
        if (builder.parseIp(target.getAddress()) || builder.parseIp(target.getHostName())) {
            int port = target.getPort();
            if (port > 0) {
                builder.port(port);
            }
            return true;
        }
        return false;
    }

    public String method(HttpRequestWrapper request) {
        return request.getRequestLine().getMethod();
    }

    public String path(HttpRequestWrapper request) {
        String result = request.getURI().getPath();
        int queryIndex = result.indexOf(63);
        return queryIndex == -1 ? result : result.substring(0, queryIndex);
    }

    public String url(HttpRequestWrapper request) {
        HttpHost target = request.getTarget();
        if (target != null) {
            return target.toURI() + request.getURI();
        }
        return request.getRequestLine().getUri();
    }

    public String requestHeader(HttpRequestWrapper request, String name) {
        Header result = request.getFirstHeader(name);
        return result != null ? result.getValue() : null;
    }

    public Integer statusCode(HttpResponse response) {
        return this.statusCodeAsInt(response);
    }

    public int statusCodeAsInt(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }
}

