/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpHandler;
import brave.http.HttpRequest;
import brave.http.HttpTracing;
import brave.internal.Nullable;
import brave.propagation.TraceContext;
import brave.sampler.SamplerFunction;

public final class HttpClientHandler<Req, Resp>
extends HttpHandler {
    final Tracer tracer;
    final SamplerFunction<HttpRequest> httpSampler;
    @Nullable
    final String serverName;
    final TraceContext.Injector<HttpClientRequest> defaultInjector;

    public static HttpClientHandler<HttpClientRequest, HttpClientResponse> create(HttpTracing httpTracing) {
        if (httpTracing == null) {
            throw new NullPointerException("httpTracing == null");
        }
        return new HttpClientHandler<HttpClientRequest, HttpClientResponse>(httpTracing);
    }

    HttpClientHandler(HttpTracing httpTracing) {
        super(httpTracing.clientRequestParser(), httpTracing.clientResponseParser());
        this.tracer = httpTracing.tracing().tracer();
        this.httpSampler = httpTracing.clientRequestSampler();
        this.serverName = !"".equals(httpTracing.serverName()) ? httpTracing.serverName() : null;
        this.defaultInjector = httpTracing.propagation().injector(HttpClientRequest.SETTER);
    }

    public Span handleSend(HttpClientRequest request) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpan(this.httpSampler, (Object)request));
    }

    public Span handleSendWithParent(HttpClientRequest request, @Nullable TraceContext parent) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        return this.handleSend(request, this.tracer.nextSpanWithParent(this.httpSampler, (Object)request, parent));
    }

    public Span handleSend(HttpClientRequest request, Span span) {
        if (request == null) {
            throw new NullPointerException("request == null");
        }
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        this.defaultInjector.inject(span.context(), (Object)request);
        return this.handleStart(request, span);
    }

    @Override
    void parseRequest(HttpRequest request, Span span) {
        if (this.serverName != null) {
            span.remoteServiceName(this.serverName);
        }
        super.parseRequest(request, span);
    }

    public void handleReceive(HttpClientResponse response, Span span) {
        this.handleFinish(response, span);
    }
}

