/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import io.takari.incrementalbuild.Incremental;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompileMojo
extends AbstractCompileMojo {
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.compileArtifacts}", readonly=true, required=true)
    private List<Artifact> compileArtifacts;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    private File generatedSourcesDirectory;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(property="maven.main.skip")
    private boolean skipMain;

    @Override
    public Set<String> getSourceRoots() {
        return new LinkedHashSet<String>(this.compileSourceRoots);
    }

    @Override
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public List<File> getClasspath() {
        ArrayList<File> classpath = new ArrayList<File>();
        for (Artifact artifact : this.compileArtifacts) {
            File file = artifact.getFile();
            if (file == null) continue;
            classpath.add(file);
        }
        return classpath;
    }

    @Override
    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    @Override
    protected boolean isSkip() {
        return this.skipMain;
    }

    @Override
    protected File getMainOutputDirectory() {
        return null;
    }
}

