/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiImplicitParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class OperationImplicitParameterReader
implements OperationBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OperationImplicitParameterReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(OperationContext context) {
        context.operationBuilder().parameters(this.readParameters(context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    static Parameter implicitParameter(DescriptionResolver descriptions, ApiImplicitParam param) {
        ModelRef modelRef = OperationImplicitParameterReader.maybeGetModelRef(param);
        return new ParameterBuilder().name(param.name()).description(descriptions.resolve(param.value())).defaultValue(param.defaultValue()).required(param.required()).allowMultiple(param.allowMultiple()).modelRef((ModelReference)modelRef).allowableValues(ApiModelProperties.allowableValueFromString(param.allowableValues())).parameterType((String)Optional.ofNullable(param.paramType()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null)).parameterAccess(param.access()).order(-2147482648).scalarExample((Object)param.example()).complexExamples(Examples.examples(param.examples())).collectionFormat(param.collectionFormat()).build();
    }

    private static ModelRef maybeGetModelRef(ApiImplicitParam param) {
        String dataType = Optional.ofNullable(param.dataType()).filter(((Predicate<String>)String::isEmpty).negate()).orElse("string");
        AllowableValues allowableValues = null;
        if (Types.isBaseType((String)dataType)) {
            allowableValues = ApiModelProperties.allowableValueFromString(param.allowableValues());
        }
        if (param.allowMultiple()) {
            return new ModelRef("", (ModelReference)new ModelRef(dataType, allowableValues));
        }
        return new ModelRef(dataType, allowableValues);
    }

    private List<Parameter> readParameters(OperationContext context) {
        Optional annotation = context.findAnnotation(ApiImplicitParam.class);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        annotation.ifPresent(apiImplicitParam -> parameters.add(OperationImplicitParameterReader.implicitParameter(this.descriptions, apiImplicitParam)));
        return parameters;
    }
}

