/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.Annotations;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class TypeProcessor {
    private final Schema schema;
    private final AnnotationScannerContext context;
    private final AugmentedIndexView index;
    private final AnnotationTarget annotationTarget;
    private final DataObjectDeque objectStack;
    private final TypeResolver typeResolver;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final List<StackEntry> objectStackInput = new ArrayList<StackEntry>();
    private Type type;

    public TypeProcessor(AnnotationScannerContext context, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, Type type, Schema schema, AnnotationTarget annotationTarget) {
        this.objectStack = objectStack;
        this.typeResolver = typeResolver;
        this.parentPathEntry = parentPathEntry;
        this.type = type;
        this.schema = schema;
        this.context = context;
        this.index = context.getAugmentedIndex();
        this.annotationTarget = annotationTarget;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Type processType() {
        if (TypeUtil.isTerminalType(this.type)) {
            this.context.getSchemaRegistry().checkRegistration(this.type, this.context.getJsonViews(), this.typeResolver, this.schema);
            return this.type;
        }
        if (this.type.kind() == Type.Kind.WILDCARD_TYPE) {
            this.type = TypeUtil.resolveWildcard(this.type.asWildcardType());
        }
        if (this.type.kind() == Type.Kind.TYPE_VARIABLE || this.type.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE) {
            this.type = this.resolveTypeVariable(this.schema, this.type, false);
        }
        if (TypeUtil.isWrappedType(this.type)) {
            this.type = TypeUtil.unwrapType(this.type);
        }
        if (this.isArrayType(this.type, this.annotationTarget)) {
            return this.readArrayType(this.type.asArrayType(), this.schema);
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ENUM_TYPE) && this.index.containsClass(this.type)) {
            MergeUtil.mergeObjects(this.schema, SchemaFactory.enumToSchema(this.context, this.type));
            this.pushToStack(this.type, this.schema);
            return OpenApiDataObjectScanner.STRING_TYPE;
        }
        if (this.type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            return this.readParameterizedType(this.type.asParameterizedType(), this.schema);
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.ITERABLE_TYPE)) {
            return TypeResolver.resolveParameterizedAncestor(this.context, this.type, OpenApiDataObjectScanner.ITERABLE_TYPE).map(p -> this.readParameterizedType(p.asParameterizedType(), this.schema)).orElse(OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT);
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.STREAM_TYPE)) {
            return TypeResolver.resolveParameterizedAncestor(this.context, this.type, OpenApiDataObjectScanner.STREAM_TYPE).map(p -> this.readParameterizedType(p.asParameterizedType(), this.schema)).orElse(OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT);
        }
        if (this.isA(this.type, OpenApiDataObjectScanner.MAP_TYPE)) {
            return TypeResolver.resolveParameterizedAncestor(this.context, this.type, OpenApiDataObjectScanner.MAP_TYPE).map(p -> this.readParameterizedType(p.asParameterizedType(), this.schema)).orElse(OpenApiDataObjectScanner.MAP_TYPE);
        }
        if (this.index.containsClass(this.type)) {
            this.pushToStack(this.type, this.schema);
        } else {
            DataObjectLogging.logger.typeNotInJandexIndex(this.type);
        }
        return this.type;
    }

    private Type readArrayType(ArrayType arrayType, Schema arraySchema) {
        DataObjectLogging.logger.processingArray((Type)arrayType);
        SchemaImpl itemSchema = new SchemaImpl();
        arraySchema.type(Schema.SchemaType.ARRAY);
        Type componentType = this.typeResolver.resolve(arrayType.component());
        boolean isOptional = TypeUtil.isOptional(componentType);
        if (isOptional) {
            componentType = TypeUtil.unwrapType(componentType);
        }
        TypeUtil.applyTypeAttributes(componentType, itemSchema);
        if (!TypeUtil.isTerminalType(componentType) && this.index.containsClass(componentType)) {
            this.pushToStack(componentType, itemSchema);
            itemSchema = this.context.getSchemaRegistry().registerReference(componentType, this.context.getJsonViews(), this.typeResolver, itemSchema);
        } else {
            itemSchema = this.context.getSchemaRegistry().checkRegistration(componentType, this.context.getJsonViews(), this.typeResolver, itemSchema);
        }
        while (arrayType.dimensions() > 1) {
            SchemaImpl parentArrSchema = new SchemaImpl();
            parentArrSchema.setType(Schema.SchemaType.ARRAY);
            parentArrSchema.setItems(itemSchema);
            itemSchema = parentArrSchema;
            arrayType = ArrayType.create((Type)arrayType.component(), (int)(arrayType.dimensions() - 1));
        }
        if (isOptional) {
            itemSchema = TypeProcessor.wrapOptionalItemSchema(itemSchema);
        }
        arraySchema.setItems((Schema)itemSchema);
        return arrayType;
    }

    private Type readParameterizedType(ParameterizedType pType, Schema schema) {
        DataObjectLogging.logger.processingParametrizedType(pType);
        ParameterizedType typeRead = pType;
        Type seekType = this.resolveSeekType(pType);
        if (seekType != null && seekType != OpenApiDataObjectScanner.MAP_TYPE) {
            Type valueType;
            boolean isOptional;
            DataObjectLogging.logger.processingTypeAs("Java Iterable or Stream", "Array");
            schema.type(Schema.SchemaType.ARRAY);
            ParameterizedType ancestorType = TypeResolver.resolveParameterizedAncestor(this.context, (Type)pType, seekType).orElse(pType);
            if (TypeUtil.isA(this.context, (Type)pType, OpenApiDataObjectScanner.SET_TYPE)) {
                schema.setUniqueItems(Boolean.TRUE);
            }
            if (isOptional = TypeUtil.isOptional(valueType = (Type)ancestorType.arguments().get(0))) {
                valueType = TypeUtil.unwrapType(valueType);
            }
            Schema valueSchema = this.readGenericValueType(valueType);
            if (isOptional) {
                valueSchema = TypeProcessor.wrapOptionalItemSchema(valueSchema);
            }
            schema.setItems(valueSchema);
            typeRead = OpenApiDataObjectScanner.ARRAY_TYPE_OBJECT;
        } else if (seekType == OpenApiDataObjectScanner.MAP_TYPE) {
            DataObjectLogging.logger.processingTypeAs("Map", "object");
            schema.type(Schema.SchemaType.OBJECT);
            ParameterizedType ancestorType = TypeResolver.resolveParameterizedAncestor(this.context, (Type)pType, seekType).orElse(pType);
            if (ancestorType.arguments().size() == 2) {
                Type valueType = (Type)ancestorType.arguments().get(1);
                schema.additionalPropertiesSchema(this.readGenericValueType(valueType));
            }
            typeRead = OpenApiDataObjectScanner.MAP_TYPE;
            if (TypeUtil.allowRegistration(this.context, (Type)pType)) {
                this.pushResolvedToStack((Type)pType, schema);
            }
        } else if (this.index.containsClass((Type)pType)) {
            this.pushResolvedToStack((Type)pType, schema);
        }
        return typeRead;
    }

    private Type resolveSeekType(ParameterizedType pType) {
        if (this.isA((Type)pType, OpenApiDataObjectScanner.ITERABLE_TYPE)) {
            return OpenApiDataObjectScanner.ITERABLE_TYPE;
        }
        if (this.isA((Type)pType, OpenApiDataObjectScanner.MAP_TYPE)) {
            return OpenApiDataObjectScanner.MAP_TYPE;
        }
        if (this.isA((Type)pType, OpenApiDataObjectScanner.STREAM_TYPE)) {
            return OpenApiDataObjectScanner.STREAM_TYPE;
        }
        return null;
    }

    private static Schema wrapOptionalItemSchema(Schema itemSchema) {
        return new SchemaImpl().nullable(Boolean.TRUE).addAllOf(itemSchema);
    }

    private Schema readGenericValueType(Type valueType) {
        SchemaImpl valueSchema = new SchemaImpl();
        if (TypeUtil.isTerminalType(valueType)) {
            TypeUtil.applyTypeAttributes(valueType, valueSchema);
        } else if (valueType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            this.readParameterizedType(valueType.asParameterizedType(), valueSchema);
        } else {
            valueSchema = this.resolveParameterizedType(valueType, valueSchema);
        }
        return valueSchema;
    }

    private Schema resolveParameterizedType(Type valueType, Schema propsSchema) {
        if (valueType.kind() == Type.Kind.TYPE_VARIABLE || valueType.kind() == Type.Kind.UNRESOLVED_TYPE_VARIABLE || valueType.kind() == Type.Kind.WILDCARD_TYPE) {
            Type resolved = this.resolveTypeVariable(propsSchema, valueType, true);
            if (this.index.containsClass(resolved)) {
                propsSchema.type(Schema.SchemaType.OBJECT);
                propsSchema = this.context.getSchemaRegistry().registerReference(valueType, this.context.getJsonViews(), this.typeResolver, propsSchema);
            }
        } else if (this.index.containsClass(valueType)) {
            if (this.isA(valueType, OpenApiDataObjectScanner.ENUM_TYPE)) {
                DataObjectLogging.logger.processingEnum(this.type);
                propsSchema = SchemaFactory.enumToSchema(this.context, valueType);
            } else {
                propsSchema.type(Schema.SchemaType.OBJECT);
            }
            SchemaRegistry registry = this.context.getSchemaRegistry();
            if (registry.hasSchema(valueType, this.context.getJsonViews(), this.typeResolver)) {
                propsSchema = registry.lookupRef(valueType, this.context.getJsonViews());
            } else {
                this.pushToStack(valueType, propsSchema);
                propsSchema = registry.registerReference(valueType, this.context.getJsonViews(), this.typeResolver, propsSchema);
            }
        }
        return propsSchema;
    }

    private Type resolveTypeVariable(Schema schema, Type fieldType, boolean pushToStack) {
        Type resolvedType = this.typeResolver.resolve(fieldType);
        DataObjectLogging.logger.resolvedType(fieldType, resolvedType);
        if (TypeUtil.isTerminalType(resolvedType) || !this.index.containsClass(resolvedType)) {
            DataObjectLogging.logger.terminalType(resolvedType);
            TypeUtil.applyTypeAttributes(resolvedType, schema);
        } else if (pushToStack) {
            this.pushToStack(resolvedType, schema);
        }
        return resolvedType;
    }

    private void pushResolvedToStack(Type type, Schema schema) {
        Type resolvedType = this.typeResolver.resolve(type);
        this.pushToStack(resolvedType, schema);
    }

    private void pushToStack(Type type, Schema schema) {
        this.objectStackInput.add(new StackEntry(type, schema));
    }

    public void pushObjectStackInput() {
        this.objectStackInput.forEach(e -> this.objectStack.push(this.annotationTarget, this.parentPathEntry, e.type, e.schema));
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.context, testSubject, test);
    }

    private boolean isArrayType(Type type, AnnotationTarget annotationTarget) {
        Schema.SchemaType schemaType;
        if (type.kind() != Type.Kind.ARRAY) {
            return false;
        }
        AnnotationInstance annotation = TypeUtil.getSchemaAnnotation(annotationTarget);
        if (annotation != null && (schemaType = Annotations.enumValue(annotation, "type", Schema.SchemaType.class)) != null) {
            return schemaType == Schema.SchemaType.ARRAY;
        }
        return true;
    }

    static class StackEntry {
        final Type type;
        final Schema schema;

        public StackEntry(Type type, Schema schema) {
            this.type = type;
            this.schema = schema;
        }
    }
}

