/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public abstract class AbstractAnnotationScanner
implements AnnotationScanner {
    private static final String EMPTY = "";
    protected String currentAppPath = "";
    private String contextRoot = "";

    @Override
    public void setContextRoot(String path) {
        this.contextRoot = path;
    }

    protected String makePath(String operationPath) {
        return AbstractAnnotationScanner.createPathFromSegments(this.contextRoot, this.currentAppPath, operationPath);
    }

    protected static String createPathFromSegments(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            if (segment.endsWith("/")) {
                segment = segment.substring(0, segment.length() - 1);
            }
            if (segment.isEmpty()) continue;
            builder.append("/");
            builder.append(segment);
        }
        String rval = builder.toString();
        if (rval.isEmpty()) {
            return "/";
        }
        return rval;
    }

    protected static boolean processProfiles(OpenApiConfig config, Extensible<?> extensible) {
        HashSet<String> profiles = new HashSet<String>();
        HashMap extensions = extensible.getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            extensions = new HashMap(extensions);
            for (String name : extensions.keySet()) {
                if (!name.startsWith("x-smallrye-profile-")) continue;
                String profile = name.substring("x-smallrye-profile-".length());
                profiles.add(profile);
                extensible.removeExtension(name);
            }
        }
        return AbstractAnnotationScanner.profileIncluded(config, profiles);
    }

    private static boolean profileIncluded(OpenApiConfig config, Set<String> profiles) {
        if (!config.getScanExcludeProfiles().isEmpty()) {
            return config.getScanExcludeProfiles().stream().noneMatch(profiles::contains);
        }
        if (config.getScanProfiles().isEmpty()) {
            return true;
        }
        return config.getScanProfiles().stream().anyMatch(profiles::contains);
    }

    @Override
    public String[] getDefaultConsumes(AnnotationScannerContext context, MethodInfo methodInfo) {
        return context.getConfig().getDefaultConsumes().orElseGet(OpenApiConstants.DEFAULT_MEDIA_TYPES);
    }

    @Override
    public String[] getDefaultProduces(AnnotationScannerContext context, MethodInfo methodInfo) {
        if (this.isPrimimive(methodInfo.returnType())) {
            return context.getConfig().getDefaultPrimitivesProduces().orElseGet(OpenApiConstants.DEFAULT_MEDIA_TYPES);
        }
        return context.getConfig().getDefaultProduces().orElseGet(OpenApiConstants.DEFAULT_MEDIA_TYPES);
    }

    private boolean isPrimimive(Type type) {
        return type.kind().equals((Object)Type.Kind.PRIMITIVE) || type.name().equals((Object)DotName.createSimple(String.class)) || TypeUtil.isWrappedType(type) && this.isPrimimive(TypeUtil.unwrapType(type));
    }
}

