/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class AnnotationTargetProcessor
implements BeanValidationScanner.RequirementHandler {
    private final AugmentedIndexView index;
    private final ClassLoader cl;
    private final DataObjectDeque objectStack;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final TypeResolver typeResolver;
    private final Type entityType;
    private final AnnotationTarget annotationTarget;

    private AnnotationTargetProcessor(AugmentedIndexView index, ClassLoader cl, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, AnnotationTarget annotationTarget, Type entityType) {
        this.index = index;
        this.cl = cl;
        this.objectStack = objectStack;
        this.parentPathEntry = parentPathEntry;
        this.typeResolver = typeResolver;
        this.entityType = entityType;
        this.annotationTarget = annotationTarget;
    }

    public static Schema process(AugmentedIndexView index, ClassLoader cl, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(index, cl, objectStack, parentPathEntry, typeResolver, typeResolver.getAnnotationTarget(), typeResolver.getUnresolvedType());
        return fp.processField();
    }

    public static Schema process(AugmentedIndexView index, ClassLoader cl, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(index, cl, objectStack, parentPathEntry, typeResolver, (AnnotationTarget)index.getClass(type), type);
        return fp.processField();
    }

    @Override
    public void setRequired(AnnotationTarget target, String propertyKey) {
        AnnotationInstance schemaAnnotation;
        List requiredProperties = this.parentPathEntry.getSchema().getRequired();
        if (!(requiredProperties != null && requiredProperties.contains(propertyKey) || (schemaAnnotation = TypeUtil.getSchemaAnnotation(target)) != null && schemaAnnotation.value("required") != null)) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
    }

    Schema processField() {
        Type fieldType;
        Schema registeredTypeSchema;
        Schema typeSchema;
        AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(this.annotationTarget);
        String propertyKey = this.typeResolver.getPropertyName();
        if (schemaAnnotation != null && JandexUtil.hasImplementation(schemaAnnotation)) {
            typeSchema = null;
            registeredTypeSchema = null;
            fieldType = (Type)JandexUtil.value(schemaAnnotation, "implementation");
        } else {
            TypeProcessor typeProcessor = new TypeProcessor(this.index, this.cl, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, new SchemaImpl(), this.annotationTarget);
            fieldType = typeProcessor.processType();
            typeSchema = typeProcessor.getSchema();
            TypeUtil.applyTypeAttributes(fieldType, typeSchema);
            Type registrationType = TypeUtil.isOptional(this.entityType) ? fieldType : this.entityType;
            registeredTypeSchema = SchemaRegistry.checkRegistration(registrationType, this.typeResolver, typeSchema);
        }
        Schema fieldSchema = schemaAnnotation != null ? this.readSchemaAnnotatedField(propertyKey, schemaAnnotation, fieldType) : (this.registrationSuccessful(typeSchema, registeredTypeSchema) ? new SchemaImpl().type(typeSchema.getType()) : (Schema)MergeUtil.mergeObjects(new SchemaImpl(), typeSchema));
        BeanValidationScanner.applyConstraints(this.annotationTarget, fieldSchema, propertyKey, this);
        if (fieldSchema.getNullable() == null && TypeUtil.isOptional(this.entityType)) {
            fieldSchema.setNullable(Boolean.TRUE);
        }
        if (this.registrationSuccessful(typeSchema, registeredTypeSchema)) {
            if (this.fieldOverridesType(fieldSchema, typeSchema)) {
                TypeUtil.clearMatchingDefaultAttributes(fieldSchema, typeSchema);
                SchemaImpl composition = new SchemaImpl();
                composition.addAllOf(registeredTypeSchema);
                composition.addAllOf(fieldSchema);
                fieldSchema = composition;
            } else {
                fieldSchema = registeredTypeSchema;
            }
        } else {
            fieldSchema = MergeUtil.mergeObjects(typeSchema, fieldSchema);
        }
        this.parentPathEntry.getSchema().addProperty(propertyKey, fieldSchema);
        return fieldSchema;
    }

    private boolean registrationSuccessful(Schema typeSchema, Schema registeredTypeSchema) {
        return typeSchema != registeredTypeSchema;
    }

    private Schema readSchemaAnnotatedField(String propertyKey, AnnotationInstance annotation, Type postProcessedField) {
        DataObjectLogging.log.processingFieldAnnotation(annotation, propertyKey);
        if (JandexUtil.booleanValueWithDefault(annotation, "required")) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
        Map<Object, Object> defaults = JandexUtil.isArraySchema(annotation) ? Collections.emptyMap() : TypeUtil.getTypeAttributes(postProcessedField);
        return SchemaFactory.readSchema((IndexView)this.index, this.cl, (Schema)new SchemaImpl(), annotation, defaults);
    }

    boolean fieldOverridesType(Schema fieldSchema, Schema typeSchema) {
        List<Supplier<Object>> typeAttributes = this.getAttributeSuppliers(typeSchema);
        List<Supplier<Object>> fieldAttributes = this.getAttributeSuppliers(fieldSchema);
        int m = typeAttributes.size();
        for (int i = 0; i < m; ++i) {
            Object typeAttr;
            Object fieldAttr = fieldAttributes.get(i).get();
            if (fieldAttr == null || (typeAttr = typeAttributes.get(i).get()) != null && fieldAttr.equals(typeAttr)) continue;
            return true;
        }
        return false;
    }

    List<Supplier<Object>> getAttributeSuppliers(Schema schema) {
        Supplier[] supplierArray = new Supplier[38];
        supplierArray[0] = () -> ((Schema)schema).getAdditionalPropertiesBoolean();
        supplierArray[1] = () -> ((Schema)schema).getAdditionalPropertiesSchema();
        supplierArray[2] = () -> ((Schema)schema).getAllOf();
        supplierArray[3] = () -> ((Schema)schema).getAnyOf();
        supplierArray[4] = () -> ((Schema)schema).getDefaultValue();
        supplierArray[5] = () -> ((Schema)schema).getDeprecated();
        supplierArray[6] = () -> ((Schema)schema).getDescription();
        supplierArray[7] = () -> ((Schema)schema).getDiscriminator();
        supplierArray[8] = () -> ((Schema)schema).getEnumeration();
        supplierArray[9] = () -> ((Schema)schema).getExample();
        supplierArray[10] = () -> ((Schema)schema).getExclusiveMaximum();
        supplierArray[11] = () -> ((Schema)schema).getExclusiveMinimum();
        supplierArray[12] = () -> ((Schema)schema).getExtensions();
        supplierArray[13] = () -> ((Schema)schema).getExternalDocs();
        supplierArray[14] = () -> ((Schema)schema).getFormat();
        supplierArray[15] = () -> ((Schema)schema).getItems();
        supplierArray[16] = () -> ((Schema)schema).getMaximum();
        supplierArray[17] = () -> ((Schema)schema).getMaxItems();
        supplierArray[18] = () -> ((Schema)schema).getMaxLength();
        supplierArray[19] = () -> ((Schema)schema).getMaxProperties();
        supplierArray[20] = () -> ((Schema)schema).getMinimum();
        supplierArray[21] = () -> ((Schema)schema).getMinItems();
        supplierArray[22] = () -> ((Schema)schema).getMinLength();
        supplierArray[23] = () -> ((Schema)schema).getMinProperties();
        supplierArray[24] = () -> ((Schema)schema).getMultipleOf();
        supplierArray[25] = () -> ((Schema)schema).getNot();
        supplierArray[26] = () -> ((Schema)schema).getNullable();
        supplierArray[27] = () -> ((Schema)schema).getOneOf();
        supplierArray[28] = () -> ((Schema)schema).getPattern();
        supplierArray[29] = () -> ((Schema)schema).getProperties();
        supplierArray[30] = () -> ((Schema)schema).getReadOnly();
        supplierArray[31] = () -> ((Schema)schema).getRef();
        supplierArray[32] = () -> ((Schema)schema).getRequired();
        supplierArray[33] = () -> ((Schema)schema).getTitle();
        supplierArray[34] = () -> ((Schema)schema).getType();
        supplierArray[35] = () -> ((Schema)schema).getUniqueItems();
        supplierArray[36] = () -> ((Schema)schema).getWriteOnly();
        supplierArray[37] = () -> ((Schema)schema).getXml();
        return Arrays.asList(supplierArray);
    }
}

