/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.constants.OpenApiConstants;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;

public class OpenApiConfigImpl
implements OpenApiConfig {
    private Config config;
    private String modelReader;
    private String filter;
    private Boolean scanDisable;
    private Pattern scanPackages;
    private Pattern scanClasses;
    private Pattern scanExcludePackages;
    private Pattern scanExcludeClasses;
    private Set<String> servers;
    private Boolean scanDependenciesDisable;
    private Set<String> scanDependenciesJars;
    private Boolean schemaReferencesEnable;
    private Boolean arrayReferencesEnable;
    private String customSchemaRegistryClass;
    private Boolean applicationPathDisable;
    private Map<String, String> schemas;
    private String version;
    private String infoTitle;
    private String infoVersion;
    private String infoDescription;
    private String infoTermsOfService;
    private String infoContactEmail;
    private String infoContactName;
    private String infoContactUrl;
    private String infoLicenseName;
    private String infoLicenseUrl;
    private OpenApiConfig.OperationIdStrategy operationIdStrategy;
    private Optional<String[]> defaultProduces;
    private Optional<String[]> defaultConsumes;

    public static OpenApiConfig fromConfig(Config config) {
        return new OpenApiConfigImpl(config);
    }

    public OpenApiConfigImpl(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    @Override
    public String modelReader() {
        if (this.modelReader == null) {
            this.modelReader = this.getStringConfigValue("mp.openapi.model.reader");
        }
        return this.modelReader;
    }

    @Override
    public String filter() {
        if (this.filter == null) {
            this.filter = this.getStringConfigValue("mp.openapi.filter");
        }
        return this.filter;
    }

    @Override
    public boolean scanDisable() {
        if (this.scanDisable == null) {
            this.scanDisable = this.getConfig().getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        }
        return this.scanDisable;
    }

    @Override
    public Pattern scanPackages() {
        if (this.scanPackages == null) {
            this.scanPackages = this.patternOf(this.getStringConfigValue("mp.openapi.scan.packages"));
        }
        return this.scanPackages;
    }

    @Override
    public Pattern scanClasses() {
        if (this.scanClasses == null) {
            this.scanClasses = this.patternOf(this.getStringConfigValue("mp.openapi.scan.classes"));
        }
        return this.scanClasses;
    }

    @Override
    public Pattern scanExcludePackages() {
        if (this.scanExcludePackages == null) {
            this.scanExcludePackages = this.patternOf(this.getStringConfigValue("mp.openapi.scan.exclude.packages"), OpenApiConstants.NEVER_SCAN_PACKAGES);
        }
        return this.scanExcludePackages;
    }

    @Override
    public Pattern scanExcludeClasses() {
        if (this.scanExcludeClasses == null) {
            this.scanExcludeClasses = this.patternOf(this.getStringConfigValue("mp.openapi.scan.exclude.classes"), OpenApiConstants.NEVER_SCAN_CLASSES);
        }
        return this.scanExcludeClasses;
    }

    @Override
    public Set<String> servers() {
        if (this.servers == null) {
            String theServers = this.getStringConfigValue("mp.openapi.servers");
            this.servers = this.asCsvSet(theServers);
        }
        return this.servers;
    }

    @Override
    public Set<String> pathServers(String path) {
        String pathServers = this.getStringConfigValue("mp.openapi.servers.path." + path);
        return this.asCsvSet(pathServers);
    }

    @Override
    public Set<String> operationServers(String operationId) {
        String opServers = this.getStringConfigValue("mp.openapi.servers.operation." + operationId);
        return this.asCsvSet(opServers);
    }

    @Override
    public boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable == null) {
            this.scanDependenciesDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.scan-dependencies.disable", Boolean.class).orElse(this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.disable", Boolean.class).orElse(false));
        }
        return this.scanDependenciesDisable;
    }

    @Override
    public Set<String> scanDependenciesJars() {
        if (this.scanDependenciesJars == null) {
            String classes = this.getStringConfigValue("mp.openapi.extensions.smallrye.scan-dependencies.jars");
            if (classes == null) {
                classes = this.getStringConfigValue("mp.openapi.extensions.scan-dependencies.jars");
            }
            this.scanDependenciesJars = this.asCsvSet(classes);
        }
        return this.scanDependenciesJars;
    }

    @Override
    public boolean schemaReferencesEnable() {
        if (this.schemaReferencesEnable == null) {
            this.schemaReferencesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.schema-references.enable", Boolean.class).orElse(this.getConfig().getOptionalValue("mp.openapi.extensions.schema-references.enable", Boolean.class).orElse(true));
        }
        return this.schemaReferencesEnable;
    }

    @Override
    public boolean arrayReferencesEnable() {
        if (this.arrayReferencesEnable == null) {
            this.arrayReferencesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.array-references.enable", Boolean.class).orElse(true);
        }
        return this.arrayReferencesEnable;
    }

    @Override
    public String customSchemaRegistryClass() {
        if (this.customSchemaRegistryClass == null) {
            this.customSchemaRegistryClass = this.getStringConfigValue("mp.openapi.extensions.smallrye.custom-schema-registry.class");
            if (this.customSchemaRegistryClass == null) {
                this.customSchemaRegistryClass = this.getStringConfigValue("mp.openapi.extensions.custom-schema-registry.class");
            }
        }
        return this.customSchemaRegistryClass;
    }

    @Override
    public boolean applicationPathDisable() {
        if (this.applicationPathDisable == null) {
            this.applicationPathDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.smallrye.application-path.disable", Boolean.class).orElse(this.getConfig().getOptionalValue("mp.openapi.extensions.application-path.disable", Boolean.class).orElse(false));
        }
        return this.applicationPathDisable;
    }

    @Override
    public Map<String, String> getSchemas() {
        if (this.schemas == null) {
            this.schemas = StreamSupport.stream(this.config.getPropertyNames().spliterator(), false).filter(name -> name.startsWith("mp.openapi.schema.") || name.startsWith("MP_OPENAPI_SCHEMA_")).collect(Collectors.toMap(name -> name.substring("mp.openapi.schema.".length()), name -> (String)this.config.getValue(name, String.class)));
        }
        return this.schemas;
    }

    @Override
    public String getOpenApiVersion() {
        if (this.version == null) {
            this.version = this.getStringConfigValue("mp.openapi.extensions.smallrye.openapi");
        }
        return this.version;
    }

    @Override
    public String getInfoTitle() {
        if (this.infoTitle == null) {
            this.infoTitle = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.title");
        }
        return this.infoTitle;
    }

    @Override
    public String getInfoVersion() {
        if (this.infoVersion == null) {
            this.infoVersion = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.version");
        }
        return this.infoVersion;
    }

    @Override
    public String getInfoDescription() {
        if (this.infoDescription == null) {
            this.infoDescription = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.description");
        }
        return this.infoDescription;
    }

    @Override
    public String getInfoTermsOfService() {
        if (this.infoTermsOfService == null) {
            this.infoTermsOfService = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.termsOfService");
        }
        return this.infoTermsOfService;
    }

    @Override
    public String getInfoContactEmail() {
        if (this.infoContactEmail == null) {
            this.infoContactEmail = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.contact.email");
        }
        return this.infoContactEmail;
    }

    @Override
    public String getInfoContactName() {
        if (this.infoContactName == null) {
            this.infoContactName = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.contact.name");
        }
        return this.infoContactName;
    }

    @Override
    public String getInfoContactUrl() {
        if (this.infoContactUrl == null) {
            this.infoContactUrl = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.contact.url");
        }
        return this.infoContactUrl;
    }

    @Override
    public String getInfoLicenseName() {
        if (this.infoLicenseName == null) {
            this.infoLicenseName = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.license.name");
        }
        return this.infoLicenseName;
    }

    @Override
    public String getInfoLicenseUrl() {
        if (this.infoLicenseUrl == null) {
            this.infoLicenseUrl = this.getStringConfigValue("mp.openapi.extensions.smallrye.info.license.url");
        }
        return this.infoLicenseUrl;
    }

    @Override
    public OpenApiConfig.OperationIdStrategy getOperationIdStrategy() {
        String strategy;
        if (this.operationIdStrategy == null && (strategy = this.getStringConfigValue("mp.openapi.extensions.smallrye.operationIdStrategy")) != null) {
            return OpenApiConfig.OperationIdStrategy.valueOf(strategy);
        }
        return null;
    }

    @Override
    public Optional<String[]> getDefaultProduces() {
        if (this.defaultProduces == null) {
            this.defaultProduces = this.getDefaultContentType("mp.openapi.extensions.smallrye.defaultProduces");
        }
        return this.defaultProduces;
    }

    @Override
    public Optional<String[]> getDefaultConsumes() {
        if (this.defaultConsumes == null) {
            this.defaultConsumes = this.getDefaultContentType("mp.openapi.extensions.smallrye.defaultConsumes");
        }
        return this.defaultConsumes;
    }

    String getStringConfigValue(String key) {
        return this.getConfig().getOptionalValue(key, String.class).map(v -> "".equals(v.trim()) ? null : v).orElse(null);
    }

    Optional<String[]> getDefaultContentType(String key) {
        return this.getConfig().getOptionalValue(key, String[].class);
    }
}

