/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.config.GenericConfig;
import java.lang.reflect.Method;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class TimeoutConfig
extends GenericConfig<Timeout> {
    public static final String VALUE = "value";
    public static final String UNIT = "unit";
    private static final String INVALID_TIMEOUT_ON = "Invalid @Timeout on ";
    private static Map<String, Class<?>> keys2Type = TimeoutConfig.initKeys();

    public TimeoutConfig(Class<?> beanClass, Method method) {
        super(Timeout.class, beanClass, method);
    }

    public TimeoutConfig(AnnotatedMethod<?> annotatedMethod) {
        super(Timeout.class, annotatedMethod);
    }

    @Override
    public void validate() {
        if (this.get(VALUE, Long.class) < 0L) {
            throw new FaultToleranceDefinitionException(INVALID_TIMEOUT_ON + this.getMethodInfo() + " : value shouldn't be lower than 0");
        }
    }

    @Override
    protected Map<String, Class<?>> getKeysToType() {
        return keys2Type;
    }

    private static Map<String, Class<?>> initKeys() {
        HashMap<String, Class> keys = new HashMap<String, Class>();
        keys.put(VALUE, Long.class);
        keys.put(UNIT, ChronoUnit.class);
        return Collections.unmodifiableMap(keys);
    }
}

