/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.stages;

import io.smallrye.reactive.streams.operators.Operator;
import io.smallrye.reactive.streams.operators.ProcessorOperator;
import io.smallrye.reactive.streams.operators.PublisherOperator;
import io.smallrye.reactive.streams.operators.TerminalOperator;
import io.smallrye.reactive.streams.stages.CancelStageFactory;
import io.smallrye.reactive.streams.stages.CollectStageFactory;
import io.smallrye.reactive.streams.stages.ConcatStageFactory;
import io.smallrye.reactive.streams.stages.CoupledStageFactory;
import io.smallrye.reactive.streams.stages.DistinctStageFactory;
import io.smallrye.reactive.streams.stages.DropWhileStageFactory;
import io.smallrye.reactive.streams.stages.FailedPublisherStageFactory;
import io.smallrye.reactive.streams.stages.FilterStageFactory;
import io.smallrye.reactive.streams.stages.FindFirstStageFactory;
import io.smallrye.reactive.streams.stages.FlatMapCompletionStageFactory;
import io.smallrye.reactive.streams.stages.FlatMapIterableStageFactory;
import io.smallrye.reactive.streams.stages.FlatMapStageFactory;
import io.smallrye.reactive.streams.stages.FromCompletionStageFactory;
import io.smallrye.reactive.streams.stages.FromCompletionStageNullableFactory;
import io.smallrye.reactive.streams.stages.FromIterableStageFactory;
import io.smallrye.reactive.streams.stages.FromPublisherStageFactory;
import io.smallrye.reactive.streams.stages.LimitStageFactory;
import io.smallrye.reactive.streams.stages.MapStageFactory;
import io.smallrye.reactive.streams.stages.OnCompleteStageFactory;
import io.smallrye.reactive.streams.stages.OnErrorResumeStageFactory;
import io.smallrye.reactive.streams.stages.OnErrorResumeWithStageFactory;
import io.smallrye.reactive.streams.stages.OnErrorStageFactory;
import io.smallrye.reactive.streams.stages.OnTerminateStageFactory;
import io.smallrye.reactive.streams.stages.PeekStageFactory;
import io.smallrye.reactive.streams.stages.ProcessorStageFactory;
import io.smallrye.reactive.streams.stages.SkipStageFactory;
import io.smallrye.reactive.streams.stages.SubscriberStageFactory;
import io.smallrye.reactive.streams.stages.TakeWhileStageFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.UnsupportedStageException;

public class Stages {
    private static final List<Operator> ALL = new ArrayList<Operator>();

    public static <T extends Stage> Operator<T> lookup(T stage) {
        Objects.requireNonNull(stage, "The stage must not be `null`");
        return ALL.stream().filter(p -> p.test(stage)).findAny().orElseThrow(() -> new UnsupportedStageException(stage));
    }

    private Stages() {
    }

    static {
        ALL.add(new ProcessorOperator<Stage.Distinct>(Stage.Distinct.class, new DistinctStageFactory()));
        ALL.add(new ProcessorOperator<Stage.Filter>(Stage.Filter.class, new FilterStageFactory()));
        ALL.add(new ProcessorOperator<Stage.FlatMap>(Stage.FlatMap.class, new FlatMapStageFactory()));
        ALL.add(new ProcessorOperator<Stage.FlatMapCompletionStage>(Stage.FlatMapCompletionStage.class, new FlatMapCompletionStageFactory()));
        ALL.add(new ProcessorOperator<Stage.FlatMapIterable>(Stage.FlatMapIterable.class, new FlatMapIterableStageFactory()));
        ALL.add(new ProcessorOperator<Stage.Map>(Stage.Map.class, new MapStageFactory()));
        ALL.add(new ProcessorOperator<Stage.Peek>(Stage.Peek.class, new PeekStageFactory()));
        ALL.add(new ProcessorOperator<Stage.OnComplete>(Stage.OnComplete.class, new OnCompleteStageFactory()));
        ALL.add(new ProcessorOperator<Stage.OnTerminate>(Stage.OnTerminate.class, new OnTerminateStageFactory()));
        ALL.add(new ProcessorOperator<Stage.OnError>(Stage.OnError.class, new OnErrorStageFactory()));
        ALL.add(new ProcessorOperator<Stage.OnErrorResume>(Stage.OnErrorResume.class, new OnErrorResumeStageFactory()));
        ALL.add(new ProcessorOperator<Stage.OnErrorResumeWith>(Stage.OnErrorResumeWith.class, new OnErrorResumeWithStageFactory()));
        ALL.add(new ProcessorOperator<Stage.ProcessorStage>(Stage.ProcessorStage.class, new ProcessorStageFactory()));
        ALL.add(new ProcessorOperator<Stage.TakeWhile>(Stage.TakeWhile.class, new TakeWhileStageFactory()));
        ALL.add(new ProcessorOperator<Stage.DropWhile>(Stage.DropWhile.class, new DropWhileStageFactory()));
        ALL.add(new ProcessorOperator<Stage.Limit>(Stage.Limit.class, new LimitStageFactory()));
        ALL.add(new ProcessorOperator<Stage.Skip>(Stage.Skip.class, new SkipStageFactory()));
        ALL.add(new ProcessorOperator<Stage.Coupled>(Stage.Coupled.class, new CoupledStageFactory()));
        ALL.add(new PublisherOperator<Stage.Concat>(Stage.Concat.class, new ConcatStageFactory()));
        ALL.add(new PublisherOperator<Stage.Failed>(Stage.Failed.class, new FailedPublisherStageFactory()));
        ALL.add(new PublisherOperator<Stage.Of>(Stage.Of.class, new FromIterableStageFactory()));
        ALL.add(new PublisherOperator<Stage.PublisherStage>(Stage.PublisherStage.class, new FromPublisherStageFactory()));
        ALL.add(new PublisherOperator<Stage.FromCompletionStage>(Stage.FromCompletionStage.class, new FromCompletionStageFactory()));
        ALL.add(new PublisherOperator<Stage.FromCompletionStageNullable>(Stage.FromCompletionStageNullable.class, new FromCompletionStageNullableFactory()));
        ALL.add(new TerminalOperator<Stage.Cancel>(Stage.Cancel.class, new CancelStageFactory()));
        ALL.add(new TerminalOperator<Stage.Collect>(Stage.Collect.class, new CollectStageFactory()));
        ALL.add(new TerminalOperator<Stage.FindFirst>(Stage.FindFirst.class, new FindFirstStageFactory()));
        ALL.add(new TerminalOperator<Stage.SubscriberStage>(Stage.SubscriberStage.class, new SubscriberStageFactory()));
    }
}

