package io.vertx.mutiny.core.dns;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Represent a Service-Record (SRV) which was resolved for a domain.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.SrvRecord original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.dns.SrvRecord.class)
public class SrvRecord {

  public static final io.smallrye.mutiny.vertx.TypeArg<SrvRecord> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SrvRecord((io.vertx.core.dns.SrvRecord) obj),
    SrvRecord::getDelegate
  );

  private final io.vertx.core.dns.SrvRecord delegate;
  
  public SrvRecord(io.vertx.core.dns.SrvRecord delegate) {
    this.delegate = delegate;
  }

  public SrvRecord(Object delegate) {
    this.delegate = (io.vertx.core.dns.SrvRecord)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SrvRecord() {
    this.delegate = null;
  }

  public io.vertx.core.dns.SrvRecord getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SrvRecord that = (SrvRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public int priority() { 
    int ret = delegate.priority();
    return ret;
  }

  /**
   * @return 
   */
  public int weight() { 
    int ret = delegate.weight();
    return ret;
  }

  /**
   * @return 
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * @return 
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return 
   */
  public String protocol() { 
    String ret = delegate.protocol();
    return ret;
  }

  /**
   * @return 
   */
  public String service() { 
    String ret = delegate.service();
    return ret;
  }

  /**
   * @return 
   */
  public String target() { 
    String ret = delegate.target();
    return ret;
  }

  public static  SrvRecord newInstance(io.vertx.core.dns.SrvRecord arg) {
    return arg != null ? new SrvRecord(arg) : null;
  }

}
