/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.net;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements ReadStream<Buffer>,
io.vertx.mutiny.core.streams.WriteStream<Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private Multi<Buffer> multi;

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public NetSocket(Object delegate) {
        this.delegate = (io.vertx.core.net.NetSocket)delegate;
    }

    NetSocket() {
        this.delegate = null;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return (Void)this.end(data).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private NetSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public NetSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private NetSocket __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public NetSocket handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Fluent
    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private NetSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    @Fluent
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private NetSocket __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public NetSocket drainHandler(Runnable handler) {
        return this.__drainHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    @Override
    public Uni<Void> write(String str) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(str, handler));
    }

    @Override
    public Void writeAndAwait(String str) {
        return (Void)this.write(str).await().indefinitely();
    }

    @Override
    public void writeAndForget(String str) {
        this.write(str).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> write(String str, String enc) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(str, enc, handler));
    }

    public Void writeAndAwait(String str, String enc) {
        return (Void)this.write(str, enc).await().indefinitely();
    }

    public void writeAndForget(String str, String enc) {
        this.write(str, enc).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> write(Buffer message) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(message.getDelegate(), handler));
    }

    @Override
    public Void writeAndAwait(Buffer message) {
        return (Void)this.write(message).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer message) {
        this.write(message).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> sendFile(String filename) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, resultHandler));
    }

    public Void sendFileAndAwait(String filename) {
        return (Void)this.sendFile(filename).await().indefinitely();
    }

    @Fluent
    public NetSocket sendFileAndForget(String filename) {
        this.sendFile(filename).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> sendFile(String filename, long offset) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, offset, resultHandler));
    }

    public Void sendFileAndAwait(String filename, long offset) {
        return (Void)this.sendFile(filename, offset).await().indefinitely();
    }

    @Fluent
    public NetSocket sendFileAndForget(String filename, long offset) {
        this.sendFile(filename, offset).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> sendFile(String filename, long offset, long length) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, offset, length, resultHandler));
    }

    public Void sendFileAndAwait(String filename, long offset, long length) {
        return (Void)this.sendFile(filename, offset, length).await().indefinitely();
    }

    @Fluent
    public NetSocket sendFileAndForget(String filename, long offset, long length) {
        this.sendFile(filename, offset, length).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private NetSocket __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket closeHandler(Runnable handler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    public Uni<Void> upgradeToSsl() {
        return AsyncResultUni.toUni(handler -> this.delegate.upgradeToSsl(handler));
    }

    public Void upgradeToSslAndAwait() {
        return (Void)this.upgradeToSsl().await().indefinitely();
    }

    @Fluent
    public NetSocket upgradeToSslAndForget() {
        this.upgradeToSsl().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> upgradeToSsl(String serverName) {
        return AsyncResultUni.toUni(handler -> this.delegate.upgradeToSsl(serverName, handler));
    }

    public Void upgradeToSslAndAwait(String serverName) {
        return (Void)this.upgradeToSsl(serverName).await().indefinitely();
    }

    @Fluent
    public NetSocket upgradeToSslAndForget(String serverName) {
        this.upgradeToSsl(serverName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public String applicationLayerProtocol() {
        String ret = this.delegate.applicationLayerProtocol();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

