package io.vertx.mutiny.ext.auth;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Represents an authenticates User and contains operations to authorise the user.
 * <p>
 * Please consult the documentation for a detailed explanation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.User original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.User.class)
public class User {

  public static final io.smallrye.mutiny.vertx.TypeArg<User> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new User((io.vertx.ext.auth.User) obj),
    User::getDelegate
  );

  private final io.vertx.ext.auth.User delegate;
  
  public User(io.vertx.ext.auth.User delegate) {
    this.delegate = delegate;
  }

  public User(Object delegate) {
    this.delegate = (io.vertx.ext.auth.User)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  User() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.User getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    User that = (User) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param username the value for this user
   * @return user instance
   */
  public static io.vertx.mutiny.ext.auth.User fromName(String username) { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.fromName(username));
    return ret;
  }

  /**
   * @param token the value for this user
   * @return user instance
   */
  public static io.vertx.mutiny.ext.auth.User fromToken(String token) { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.fromToken(token));
    return ret;
  }

  /**
   * @param principal the free form json principal
   * @return user instance
   */
  public static io.vertx.mutiny.ext.auth.User create(JsonObject principal) { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.create(principal));
    return ret;
  }

  /**
   * @param principal the free form json principal
   * @param attributes the free form json attributes that further describe the principal
   * @return user instance
   */
  public static io.vertx.mutiny.ext.auth.User create(JsonObject principal, JsonObject attributes) { 
    io.vertx.mutiny.ext.auth.User ret = io.vertx.mutiny.ext.auth.User.newInstance((io.vertx.ext.auth.User)io.vertx.ext.auth.User.create(principal, attributes));
    return ret;
  }

  /**
   * @return a json object with any relevant attribute.
   */
  public JsonObject attributes() { 
    JsonObject ret = delegate.attributes();
    return ret;
  }

  /**
   * @return <code>true</code> if expired
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * @param leeway a greater than zero leeway value.
   * @return <code>true</code> if expired
   */
  public boolean expired(int leeway) { 
    boolean ret = delegate.expired(leeway);
    return ret;
  }

  /**
   * @param key the key to look up
   * @return the value or null if missing
   */
  public <T> T get(String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * @param key the key to look up
   * @return the value or null if missing
   */
  public boolean containsKey(String key) { 
    boolean ret = delegate.containsKey(key);
    return ret;
  }

  /**
   * @return authorizations holder for the user.
   */
  public io.vertx.mutiny.ext.auth.authorization.Authorizations authorizations() { 
    io.vertx.mutiny.ext.auth.authorization.Authorizations ret = io.vertx.mutiny.ext.auth.authorization.Authorizations.newInstance((io.vertx.ext.auth.authorization.Authorizations)delegate.authorizations());
    return ret;
  }

  /**
   * Is the user authorised to
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Boolean> isAuthorized(io.vertx.mutiny.ext.auth.authorization.Authorization authority) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.isAuthorized(authority.getDelegate(), resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.User#isAuthorized(io.vertx.mutiny.ext.auth.authorization.Authorization)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the Boolean instance produced by the operation.
   * @deprecated   */
  @Deprecated
  public Boolean isAuthorizedAndAwait(io.vertx.mutiny.ext.auth.authorization.Authorization authority) { 
    return (Boolean) isAuthorized(authority).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.User#isAuthorized(io.vertx.mutiny.ext.auth.authorization.Authorization)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.User#isAuthorized(io.vertx.mutiny.ext.auth.authorization.Authorization)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.User#isAuthorized(io.vertx.mutiny.ext.auth.authorization.Authorization)} but you don't need to compose it with other operations.
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the instance of User to chain method calls.
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.User isAuthorizedAndForget(io.vertx.mutiny.ext.auth.authorization.Authorization authority) { 
    isAuthorized(authority).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Is the user authorised to
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated Use typed alternative {@link #isAuthorized(Authorization, Handler)}   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Boolean> isAuthorized(String authority) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.isAuthorized(authority, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.User#isAuthorized(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the Boolean instance produced by the operation.
   * @deprecated Use typed alternative {@link #isAuthorized(Authorization, Handler)}   */
  @Deprecated
  public Boolean isAuthorizedAndAwait(String authority) { 
    return (Boolean) isAuthorized(authority).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.User#isAuthorized(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.User#isAuthorized(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.User#isAuthorized(String)} but you don't need to compose it with other operations.
   * @param authority the authority - what this really means is determined by the specific implementation. It might represent a permission to access a resource e.g. `printers:printer34` or it might represent authority to a role in a roles based model, e.g. `role:admin`.
   * @return the instance of User to chain method calls.
   * @deprecated Use typed alternative {@link #isAuthorized(Authorization, Handler)}   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.User isAuthorizedAndForget(String authority) { 
    isAuthorized(authority).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return the User to enable fluent use
   * @deprecated This method will be removed. Use {@link Authorizations#clear()}   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.User clearCache() { 
    delegate.clearCache();
    return this;
  }

  /**
   * @return JSON representation of the Principal
   */
  public JsonObject principal() { 
    JsonObject ret = delegate.principal();
    return ret;
  }

  /**
   * @param authProvider the AuthProvider - this must be the same type of AuthProvider that originally created the User
   * @deprecated   */
  @Deprecated
  public void setAuthProvider(io.vertx.mutiny.ext.auth.AuthProvider authProvider) { 
    delegate.setAuthProvider(authProvider.getDelegate());
  }

  /**
   * @param other the other user to merge
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.User merge(io.vertx.mutiny.ext.auth.User other) { 
    delegate.merge(other.getDelegate());
    return this;
  }

  public static  User newInstance(io.vertx.ext.auth.User arg) {
    return arg != null ? new User(arg) : null;
  }

}
