/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import io.smallrye.config._private.ConfigLogging;
import io.smallrye.config._private.ConfigMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public interface ConfigValueConfigSource
extends ConfigSource {
    public ConfigValue getConfigValue(String var1);

    public Map<String, ConfigValue> getConfigValueProperties();

    default public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(new ConfigValueMapView(this.getConfigValueProperties()));
    }

    default public String getValue(String propertyName) {
        ConfigValue value = this.getConfigValue(propertyName);
        return value != null ? value.getValue() : null;
    }

    public static final class ConfigValueMapView
    extends AbstractMap<String, String> {
        private final Map<String, ConfigValue> delegate;
        private transient Set<Map.Entry<String, String>> entrySet;
        private transient Collection<String> values;

        ConfigValueMapView(Map<String, ConfigValue> delegate) {
            this.delegate = Collections.unmodifiableMap(delegate);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public String get(Object key) {
            ConfigValue configValue = this.delegate.get(key);
            return configValue != null ? configValue.getValue() : null;
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new AbstractSet<Map.Entry<String, String>>(){

                    @Override
                    public Iterator<Map.Entry<String, String>> iterator() {
                        return new Iterator<Map.Entry<String, String>>(){
                            final Iterator<Map.Entry<String, ConfigValue>> delegate;
                            {
                                this.delegate = delegate.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.delegate.hasNext();
                            }

                            @Override
                            public Map.Entry<String, String> next() {
                                Map.Entry<String, ConfigValue> next = this.delegate.next();
                                ConfigValue configValue = next.getValue();
                                String value = configValue != null ? configValue.getValue() : null;
                                return new AbstractMap.SimpleImmutableEntry<String, String>(next.getKey(), value);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return delegate.size();
                    }
                };
            }
            return this.entrySet;
        }

        @Override
        public Collection<String> values() {
            if (this.values == null) {
                this.values = new AbstractCollection<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        final Iterator<ConfigValue> delegate = delegate.values().iterator();
                        return new Iterator<String>(){

                            @Override
                            public boolean hasNext() {
                                return delegate.hasNext();
                            }

                            @Override
                            public String next() {
                                ConfigValue configValue = (ConfigValue)delegate.next();
                                return configValue != null ? configValue.getValue() : null;
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return delegate.size();
                    }
                };
            }
            return this.values;
        }
    }

    public static final class ConfigValueProperties
    extends HashMap<String, ConfigValue> {
        private static final long serialVersionUID = 613423366086278005L;
        private final String configSourceName;
        private final int configSourceOrdinal;

        public ConfigValueProperties(String configSourceName, int configSourceOrdinal) {
            this.configSourceName = configSourceName;
            this.configSourceOrdinal = configSourceOrdinal;
        }

        public synchronized void load(Reader reader) throws IOException {
            this.load0(new LineReader(reader));
        }

        public synchronized void load(InputStream inStream) throws IOException {
            this.load0(new LineReader(inStream));
        }

        private void load0(LineReader lr) throws IOException {
            int limit;
            char[] convtBuf = new char[1024];
            while ((limit = lr.readLine()) >= 0) {
                int keyLen;
                char c = '\u0000';
                int valueStart = limit;
                boolean hasSep = false;
                boolean precedingBackslash = false;
                for (keyLen = 0; keyLen < limit; ++keyLen) {
                    c = lr.lineBuf[keyLen];
                    if (!(c != '=' && c != ':' || precedingBackslash)) {
                        valueStart = keyLen + 1;
                        hasSep = true;
                        break;
                    }
                    if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                        valueStart = keyLen + 1;
                        break;
                    }
                    precedingBackslash = c == '\\' ? !precedingBackslash : false;
                }
                while (valueStart < limit) {
                    c = lr.lineBuf[valueStart];
                    if (c != ' ' && c != '\t' && c != '\f') {
                        if (hasSep || c != '=' && c != ':') break;
                        hasSep = true;
                    }
                    ++valueStart;
                }
                String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
                String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
                ConfigValue oldConfigValue = this.put(key, ConfigValue.builder().withName(key).withValue(value).withRawValue(value).withConfigSourceName(this.configSourceName).withConfigSourceOrdinal(this.configSourceOrdinal).withLineNumber(lr.lineNumber).build());
                if (oldConfigValue == null) continue;
                ConfigLogging.log.duplicateValue(oldConfigValue.getName(), oldConfigValue.getConfigSourceName(), oldConfigValue.getValue());
            }
        }

        private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
            if (convtBuf.length < len) {
                int newLen = len * 2;
                if (newLen < 0) {
                    newLen = Integer.MAX_VALUE;
                }
                convtBuf = new char[newLen];
            }
            char[] out = convtBuf;
            int outLen = 0;
            int end = off + len;
            while (off < end) {
                int aChar;
                if ((aChar = in[off++]) == 92) {
                    if ((aChar = in[off++]) == 117) {
                        int value = 0;
                        block6: for (int i = 0; i < 4; ++i) {
                            aChar = in[off++];
                            switch (aChar) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    value = (value << 4) + aChar - 48;
                                    continue block6;
                                }
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    value = (value << 4) + 10 + aChar - 97;
                                    continue block6;
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: {
                                    value = (value << 4) + 10 + aChar - 65;
                                    continue block6;
                                }
                                default: {
                                    throw ConfigMessages.msg.malformedEncoding();
                                }
                            }
                        }
                        out[outLen++] = (char)value;
                        continue;
                    }
                    if (aChar == 116) {
                        aChar = 9;
                    } else if (aChar == 114) {
                        aChar = 13;
                    } else if (aChar == 110) {
                        aChar = 10;
                    } else if (aChar == 102) {
                        aChar = 12;
                    }
                    out[outLen++] = aChar;
                    continue;
                }
                out[outLen++] = aChar;
            }
            return new String(out, 0, outLen);
        }

        class LineReader {
            byte[] inByteBuf;
            char[] inCharBuf;
            char[] lineBuf = new char[1024];
            int inLimit = 0;
            int inOff = 0;
            InputStream inStream;
            Reader reader;
            int lineNumber = 0;
            int addBackslash = 0;

            public LineReader(InputStream inStream) {
                this.inStream = inStream;
                this.inByteBuf = new byte[8192];
            }

            public LineReader(Reader reader) {
                this.reader = reader;
                this.inCharBuf = new char[8192];
            }

            int readLine() throws IOException {
                int len = 0;
                char c = '\u0000';
                boolean skipWhiteSpace = true;
                boolean isCommentLine = false;
                boolean isNewLine = true;
                boolean appendedLineBegin = false;
                boolean precedingBackslash = false;
                boolean skipLF = false;
                ++this.lineNumber;
                this.lineNumber += this.addBackslash;
                this.addBackslash = 0;
                while (true) {
                    if (this.inOff >= this.inLimit) {
                        this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                        this.inOff = 0;
                        if (this.inLimit <= 0) {
                            if (len == 0 || isCommentLine) {
                                return -1;
                            }
                            if (precedingBackslash) {
                                --len;
                            }
                            return len;
                        }
                    }
                    c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                    if (skipLF) {
                        skipLF = false;
                        if (c == '\n') continue;
                    }
                    if (skipWhiteSpace) {
                        if (c == ' ' || c == '\t' || c == '\f') continue;
                        if (!(appendedLineBegin || c != '\r' && c != '\n')) {
                            if (c != '\n') continue;
                            ++this.lineNumber;
                            continue;
                        }
                        skipWhiteSpace = false;
                        appendedLineBegin = false;
                    }
                    if (isNewLine) {
                        isNewLine = false;
                        if (c == '#' || c == '!') {
                            isCommentLine = true;
                            continue;
                        }
                    }
                    if (c != '\n' && c != '\r') {
                        this.lineBuf[len++] = c;
                        if (len == this.lineBuf.length) {
                            int newLength = this.lineBuf.length * 2;
                            if (newLength < 0) {
                                newLength = Integer.MAX_VALUE;
                            }
                            char[] buf = new char[newLength];
                            System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                            this.lineBuf = buf;
                        }
                        if (c == '\\') {
                            precedingBackslash = !precedingBackslash;
                            continue;
                        }
                        precedingBackslash = false;
                        continue;
                    }
                    if (isCommentLine || len == 0) {
                        isCommentLine = false;
                        isNewLine = true;
                        skipWhiteSpace = true;
                        len = 0;
                        ++this.lineNumber;
                        continue;
                    }
                    if (this.inOff >= this.inLimit) {
                        this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                        this.inOff = 0;
                        if (this.inLimit <= 0) {
                            if (precedingBackslash) {
                                --len;
                            }
                            return len;
                        }
                    }
                    if (!precedingBackslash) break;
                    --len;
                    skipWhiteSpace = true;
                    appendedLineBegin = true;
                    precedingBackslash = false;
                    ++this.addBackslash;
                    if (c != '\r') continue;
                    skipLF = true;
                }
                if (c == '\r') {
                    ++this.inOff;
                }
                return len;
            }
        }
    }

    public static final class ConfigValueMapStringView
    extends AbstractMap<String, ConfigValue> {
        private final Map<String, String> delegate;
        private final String configSourceName;
        private final int configSourceOrdinal;
        private Set<Map.Entry<String, ConfigValue>> entrySet;
        private Collection<ConfigValue> values;

        public ConfigValueMapStringView(Map<String, String> delegate, String configSourceName, int configSourceOrdinal) {
            this.delegate = Collections.unmodifiableMap(delegate);
            this.configSourceName = configSourceName;
            this.configSourceOrdinal = configSourceOrdinal;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            ConfigValue configValue = (ConfigValue)value;
            if (configValue == null || configValue.getValue() == null) {
                return this.delegate.containsValue(null);
            }
            return this.delegate.containsValue(configValue.getValue());
        }

        @Override
        public ConfigValue get(Object key) {
            String value = this.delegate.get(key);
            if (value == null) {
                return null;
            }
            return this.toConfigValue((String)key, value);
        }

        @Override
        public Set<String> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Set<Map.Entry<String, ConfigValue>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new AbstractSet<Map.Entry<String, ConfigValue>>(){

                    @Override
                    public Iterator<Map.Entry<String, ConfigValue>> iterator() {
                        return new Iterator<Map.Entry<String, ConfigValue>>(){
                            final Iterator<Map.Entry<String, String>> delegate;
                            {
                                this.delegate = delegate.entrySet().iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.delegate.hasNext();
                            }

                            @Override
                            public Map.Entry<String, ConfigValue> next() {
                                Map.Entry<String, String> next = this.delegate.next();
                                String value = next.getValue();
                                return value != null ? new AbstractMap.SimpleImmutableEntry<String, ConfigValue>(next.getKey(), this.toConfigValue(next.getKey(), value)) : new AbstractMap.SimpleImmutableEntry<String, Object>(next.getKey(), null);
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return delegate.size();
                    }
                };
            }
            return this.entrySet;
        }

        @Override
        public Collection<ConfigValue> values() {
            if (this.values == null) {
                this.values = new AbstractCollection<ConfigValue>(){

                    @Override
                    public Iterator<ConfigValue> iterator() {
                        final Iterator<Map.Entry<String, ConfigValue>> delegate = this.entrySet().iterator();
                        return new Iterator<ConfigValue>(){

                            @Override
                            public boolean hasNext() {
                                return delegate.hasNext();
                            }

                            @Override
                            public ConfigValue next() {
                                Map.Entry next = (Map.Entry)delegate.next();
                                return next != null ? (ConfigValue)next.getValue() : null;
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return delegate.size();
                    }
                };
            }
            return this.values;
        }

        private ConfigValue toConfigValue(String name, String value) {
            return ConfigValue.builder().withName(name).withValue(value).withRawValue(value).withConfigSourceName(this.configSourceName).withConfigSourceOrdinal(this.configSourceOrdinal).build();
        }
    }
}

