/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import io.smallrye.config._private.ConfigMessages;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public interface Config
extends org.eclipse.microprofile.config.Config {
    public <T> List<T> getValues(String var1, Class<T> var2);

    public <T, C extends Collection<T>> C getValues(String var1, Class<T> var2, IntFunction<C> var3);

    public <T, C extends Collection<T>> C getValues(String var1, Converter<T> var2, IntFunction<C> var3);

    public <K, V> Map<K, V> getValues(String var1, Class<K> var2, Class<V> var3);

    public <K, V> Map<K, V> getValues(String var1, Converter<K> var2, Converter<V> var3);

    public <K, V> Map<K, V> getValues(String var1, Converter<K> var2, Converter<V> var3, IntFunction<Map<K, V>> var4);

    public <K, V, C extends Collection<V>> Map<K, C> getValues(String var1, Class<K> var2, Class<V> var3, IntFunction<C> var4);

    public <K, V, C extends Collection<V>> Map<K, C> getValues(String var1, Converter<K> var2, Converter<V> var3, IntFunction<Map<K, C>> var4, IntFunction<C> var5);

    public <T> T getValue(String var1, Class<T> var2);

    public <T> T getValue(String var1, Converter<T> var2);

    public <T> T convertValue(ConfigValue var1, Converter<T> var2);

    public ConfigValue getConfigValue(String var1);

    public <T> Optional<T> getOptionalValue(String var1, Class<T> var2);

    public <T> Optional<T> getOptionalValue(String var1, Converter<T> var2);

    public <T> Optional<List<T>> getOptionalValues(String var1, Class<T> var2);

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String var1, Class<T> var2, IntFunction<C> var3);

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String var1, Converter<T> var2, IntFunction<C> var3);

    public <K, V> Optional<Map<K, V>> getOptionalValues(String var1, Class<K> var2, Class<V> var3);

    public <K, V> Optional<Map<K, V>> getOptionalValues(String var1, Converter<K> var2, Converter<V> var3);

    public <K, V> Optional<Map<K, V>> getOptionalValues(String var1, Converter<K> var2, Converter<V> var3, IntFunction<Map<K, V>> var4);

    public <K, V, C extends Collection<V>> Optional<Map<K, C>> getOptionalValues(String var1, Class<K> var2, Class<V> var3, IntFunction<C> var4);

    public <K, V, C extends Collection<V>> Optional<Map<K, C>> getOptionalValues(String var1, Converter<K> var2, Converter<V> var3, IntFunction<Map<K, C>> var4, IntFunction<C> var5);

    public <T> T getConfigMapping(Class<T> var1);

    public <T> T getConfigMapping(Class<T> var1, String var2);

    public Iterable<String> getPropertyNames();

    public Iterable<String> getLatestPropertyNames();

    public boolean isPropertyPresent(String var1);

    public Iterable<ConfigSource> getConfigSources();

    public Iterable<ConfigSource> getConfigSources(Class<?> var1);

    public Optional<ConfigSource> getConfigSource(String var1);

    public <T> Converter<T> requireConverter(Class<T> var1);

    public List<String> getProfiles();

    public static Config get() {
        ConfigProviderResolver configProviderResolver = ConfigProviderResolver.instance();
        if (configProviderResolver instanceof SmallRyeConfigProviderResolver) {
            SmallRyeConfigProviderResolver resolver = (SmallRyeConfigProviderResolver)configProviderResolver;
            return resolver.get();
        }
        throw ConfigMessages.msg.incompatibleConfigProvider(SmallRyeConfigProviderResolver.class.getName(), ConfigProviderResolver.instance().getClass().getName());
    }

    public static Config getOrCreate() {
        return (Config)ConfigProviderResolver.instance().getConfig().unwrap(SmallRyeConfig.class);
    }

    public static Config get(ClassLoader classLoader) {
        ConfigProviderResolver configProviderResolver = ConfigProviderResolver.instance();
        if (configProviderResolver instanceof SmallRyeConfigProviderResolver) {
            SmallRyeConfigProviderResolver resolver = (SmallRyeConfigProviderResolver)configProviderResolver;
            return resolver.get(classLoader);
        }
        throw ConfigMessages.msg.incompatibleConfigProvider(SmallRyeConfigProviderResolver.class.getName(), ConfigProviderResolver.instance().getClass().getName());
    }

    public static Config getOrCreate(ClassLoader classLoader) {
        return (Config)ConfigProviderResolver.instance().getConfig(classLoader).unwrap(SmallRyeConfig.class);
    }
}

