/*
 * Copyright 2017-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.r2dbc.spi;

import org.reactivestreams.Publisher;

/**
 * A factory for creating {@link Connection}s and entry point for a driver.
 *
 * @see Connection
 */
public interface ConnectionFactory {

    /**
     * Creates a new {@link Connection}.
     *
     * @return the newly created {@link Connection}
     */
    Publisher<? extends Connection> create();

    /**
     * Returns the {@link ConnectionFactoryMetadata} about the product this {@link ConnectionFactory} is applicable to.
     *
     * @return the {@link ConnectionFactoryMetadata} about the product this {@link ConnectionFactory} is applicable to
     */
    ConnectionFactoryMetadata getMetadata();

}
