/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.EvaluatedParams;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.NamedArgument;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.Results;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class FragmentNamespaceResolver
implements NamespaceResolver,
EngineBuilder.EngineListener {
    public static final String FRG = "frg";
    public static final String FRAGMENT = "fragment";
    public static final String CAP = "cap";
    public static final String CAPTURE = "capture";
    private final String namespace;
    private final int priority;
    private volatile Engine engine;

    public FragmentNamespaceResolver() {
        this(FRG, -1);
    }

    public FragmentNamespaceResolver(String namespace) {
        this(namespace, -1);
    }

    public FragmentNamespaceResolver(String namespace, int priority) {
        this.namespace = namespace;
        this.priority = priority;
    }

    @Override
    public void engineBuilt(Engine engine) {
        this.engine = engine;
    }

    @Override
    public CompletionStage<Object> resolve(EvalContext context) {
        String id = context.getName();
        Template template = null;
        int idx = id.lastIndexOf(36);
        if (idx != -1) {
            String templateId = id.substring(0, idx);
            Engine e = this.engine;
            if (e == null) {
                throw new TemplateException("Engine not set");
            }
            template = e.getTemplate(templateId);
            if (template == null) {
                throw new TemplateException("Template not found: " + templateId);
            }
            id = id.substring(idx + 1);
        } else {
            template = context.resolutionContext().getTemplate();
        }
        Template.Fragment fragment = template.getFragment(id);
        if (fragment != null) {
            CompletableFuture<Object> ret = new CompletableFuture<Object>();
            if (!context.getParams().isEmpty()) {
                EvaluatedParams params = EvaluatedParams.evaluate(context);
                params.stage.whenComplete((r, t) -> {
                    if (t != null) {
                        ret.completeExceptionally((Throwable)t);
                    } else {
                        HashMap<String, Object> args = new HashMap<String, Object>();
                        for (int i = 0; i < context.getParams().size(); ++i) {
                            try {
                                Object result = params.getResult(i);
                                if (result instanceof NamedArgument) {
                                    NamedArgument arg = (NamedArgument)result;
                                    args.put(arg.getName(), arg.getValue());
                                    continue;
                                }
                                ret.completeExceptionally(new TemplateException("Named argument expected: " + String.valueOf(result.getClass())));
                                break;
                            }
                            catch (InterruptedException | ExecutionException e) {
                                ret.completeExceptionally(e);
                            }
                        }
                        ResolutionContext child = context.resolutionContext().createChild(Mapper.wrap(args), null);
                        fragment.getRootNode().resolve(child, Map.of("qute$fragment", true)).whenComplete((r2, t2) -> {
                            if (t2 != null) {
                                ret.completeExceptionally((Throwable)t2);
                            } else {
                                StringBuilder sb = new StringBuilder();
                                r2.process(sb::append);
                                ret.complete(sb.toString());
                            }
                        });
                    }
                });
            } else {
                fragment.getRootNode().resolve(context.resolutionContext(), Map.of("qute$fragment", true)).whenComplete((r, t) -> {
                    if (t != null) {
                        ret.completeExceptionally((Throwable)t);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        r.process(sb::append);
                        ret.complete(sb.toString());
                    }
                });
            }
            return ret;
        }
        return Results.notFound(context);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

