/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.FilterConfig;
import io.quarkus.vertx.http.runtime.HeaderConfig;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.SameSiteCookieConfig;
import io.quarkus.vertx.http.runtime.ServerLimitsConfig;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public class HttpConfiguration {
    @ConfigItem(name="cors")
    public boolean corsEnabled;
    @ConfigItem(defaultValue="8080")
    public int port;
    @ConfigItem(defaultValue="8081")
    public int testPort;
    @ConfigItem
    public String host;
    @ConfigItem(defaultValue="true")
    public boolean hostEnabled;
    @ConfigItem(defaultValue="8443")
    public int sslPort;
    @ConfigItem(defaultValue="8444")
    public int testSslPort;
    @ConfigItem(defaultValue="enabled")
    public InsecureRequests insecureRequests;
    @ConfigItem(defaultValue="true")
    public boolean http2;
    public CORSConfig cors;
    public ServerSslConfig ssl;
    @ConfigItem(defaultValue="false", name="handle-100-continue-automatically")
    public boolean handle100ContinueAutomatically;
    @ConfigItem
    public OptionalInt ioThreads;
    public ServerLimitsConfig limits;
    @ConfigItem(defaultValue="30M", name="idle-timeout")
    public Duration idleTimeout;
    @ConfigItem(defaultValue="60s", name="read-timeout")
    public Duration readTimeout;
    public BodyConfig body;
    @ConfigItem(name="auth.session.encryption-key")
    public Optional<String> encryptionKey;
    @ConfigItem
    public boolean soReusePort;
    @ConfigItem
    public boolean tcpQuickAck;
    @ConfigItem
    public boolean tcpCork;
    @ConfigItem
    public boolean tcpFastOpen;
    @ConfigItem(defaultValue="-1")
    public int acceptBacklog;
    @ConfigItem(defaultValue="/var/run/io.quarkus.app.socket")
    public String domainSocket;
    @ConfigItem
    public boolean domainSocketEnabled;
    @ConfigItem
    public boolean recordRequestStartTime;
    AccessLogConfig accessLog;
    @ConfigItem
    public Map<String, SameSiteCookieConfig> sameSiteCookie;
    @ConfigItem
    public Optional<PayloadHint> unhandledErrorContentTypeDefault;
    @ConfigItem
    public Map<String, HeaderConfig> header;
    @ConfigItem
    public Map<String, FilterConfig> filter;
    public ProxyConfig proxy;

    public int determinePort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testPort : this.port;
    }

    public int determineSslPort(LaunchMode launchMode) {
        return launchMode == LaunchMode.TEST ? this.testSslPort : this.sslPort;
    }

    public static enum PayloadHint {
        JSON,
        HTML;

    }

    public static enum InsecureRequests {
        ENABLED,
        REDIRECT,
        DISABLED;

    }
}

