/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.runtime;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringWebEndpointProvider
implements TestHttpEndpointProvider {
    public Function<Class<?>, String> endpointProvider() {
        return new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> aClass) {
                String value;
                String[] paths = SpringWebEndpointProvider.this.getPath(aClass);
                if (paths == null) {
                    return null;
                }
                if (paths.length == 0) {
                    value = "";
                } else {
                    value = paths[0];
                    if (value.startsWith("/")) {
                        value = value.substring(1);
                    }
                }
                String path = "/";
                Optional appPath = ConfigProvider.getConfig().getOptionalValue("quarkus.resteasy.path", String.class);
                if (appPath.isPresent()) {
                    path = (String)appPath.get();
                }
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                value = path + value;
                return value;
            }
        };
    }

    private String[] getPath(Class<?> aClass) {
        String[] value = null;
        for (Annotation annotation : aClass.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(RequestMapping.class.getName())) continue;
            try {
                value = (String[])annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                break;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (value == null) {
            Object i;
            Object[] objectArray = aClass.getInterfaces();
            int n = objectArray.length;
            for (int j = 0; j < n && (value = this.getPath((Class<?>)(i = objectArray[j]))) == null; ++j) {
            }
        }
        if (value == null && aClass.getSuperclass() != Object.class) {
            value = this.getPath(aClass.getSuperclass());
        }
        return value;
    }
}

