/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.server.common.spi.AllowedJaxRsAnnotationPrefixBuildItem;
import io.quarkus.resteasy.server.common.spi.ResteasyJaxrsConfigBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.openapi.common.deployment.SmallRyeOpenApiConfig;
import io.quarkus.smallrye.openapi.deployment.CustomPathExtension;
import io.quarkus.smallrye.openapi.deployment.OpenApiConfigMapping;
import io.quarkus.smallrye.openapi.deployment.OpenApiFilteredIndexViewBuildItem;
import io.quarkus.smallrye.openapi.deployment.RESTEasyExtension;
import io.quarkus.smallrye.openapi.deployment.filter.AutoRolesAllowedFilter;
import io.quarkus.smallrye.openapi.deployment.filter.AutoTagFilter;
import io.quarkus.smallrye.openapi.deployment.filter.SecurityConfigFilter;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.quarkus.smallrye.openapi.runtime.OpenApiRecorder;
import io.quarkus.smallrye.openapi.runtime.OpenApiRuntimeConfig;
import io.quarkus.smallrye.openapi.runtime.filter.AutoBasicSecurityFilter;
import io.quarkus.smallrye.openapi.runtime.filter.AutoJWTSecurityFilter;
import io.quarkus.smallrye.openapi.runtime.filter.AutoUrl;
import io.quarkus.smallrye.openapi.runtime.filter.OpenIDConnectSecurityFilter;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.spring.SpringConstants;
import io.smallrye.openapi.vertx.VertxConstants;
import io.vertx.core.Handler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeOpenApiProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.smallrye.openapi");
    private static final String META_INF_OPENAPI_YAML = "META-INF/openapi.yaml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YAML = "WEB-INF/classes/META-INF/openapi.yaml";
    private static final String META_INF_OPENAPI_YML = "META-INF/openapi.yml";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_YML = "WEB-INF/classes/META-INF/openapi.yml";
    private static final String META_INF_OPENAPI_JSON = "META-INF/openapi.json";
    private static final String WEB_INF_CLASSES_META_INF_OPENAPI_JSON = "WEB-INF/classes/META-INF/openapi.json";
    private static final DotName OPENAPI_SCHEMA = DotName.createSimple((String)Schema.class.getName());
    private static final DotName OPENAPI_RESPONSE = DotName.createSimple((String)APIResponse.class.getName());
    private static final DotName OPENAPI_RESPONSES = DotName.createSimple((String)APIResponses.class.getName());
    private static final String OPENAPI_RESPONSE_CONTENT = "content";
    private static final String OPENAPI_RESPONSE_SCHEMA = "schema";
    private static final String OPENAPI_SCHEMA_NOT = "not";
    private static final String OPENAPI_SCHEMA_ONE_OF = "oneOf";
    private static final String OPENAPI_SCHEMA_ANY_OF = "anyOf";
    private static final String OPENAPI_SCHEMA_ALL_OF = "allOf";
    private static final String OPENAPI_SCHEMA_IMPLEMENTATION = "implementation";
    private static final String JAX_RS = "JAX-RS";
    private static final String SPRING = "Spring";
    private static final String VERT_X = "Vert.x";

    @BuildStep
    void contributeClassesToIndex(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{Collection.class.getName(), Map.class.getName(), Object.class.getName()}));
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> serviceProvider) throws IOException {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)OpenApiConfigMapping.class.getName()));
    }

    @BuildStep
    void configFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, SmallRyeOpenApiConfig openApiConfig, LaunchModeBuildItem launchMode, OutputTargetBuildItem outputTargetBuildItem) throws IOException {
        if (launchMode.getLaunchMode().isDevOrTest() && openApiConfig.additionalDocsDirectory.isPresent()) {
            List additionalStaticDocuments = (List)openApiConfig.additionalDocsDirectory.get();
            for (Path path : additionalStaticDocuments) {
                List<String> filesInDir = this.getResourceFiles(path.toString(), outputTargetBuildItem.getOutputDirectory());
                for (String possibleFile : filesInDir) {
                    watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(possibleFile));
                }
            }
        }
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF_OPENAPI_YAML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(WEB_INF_CLASSES_META_INF_OPENAPI_YAML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF_OPENAPI_YML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(WEB_INF_CLASSES_META_INF_OPENAPI_YML));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(META_INF_OPENAPI_JSON));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(WEB_INF_CLASSES_META_INF_OPENAPI_JSON));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void handler(LaunchModeBuildItem launch, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<RouteBuildItem> routes, OpenApiRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, List<SecurityInformationBuildItem> securityInformationBuildItems, OpenApiRuntimeConfig openApiRuntimeConfig, ShutdownContextBuildItem shutdownContext, SmallRyeOpenApiConfig openApiConfig, OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem) {
        OASFilter autoRolesAllowedFilter;
        if (launch.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.setupClDevMode((ShutdownContext)shutdownContext);
        }
        OASFilter autoSecurityFilter = null;
        if (openApiConfig.autoAddSecurity && (autoRolesAllowedFilter = this.getAutoRolesAllowedFilter(openApiConfig.securitySchemeName, apiFilteredIndexViewBuildItem, openApiConfig)) != null) {
            autoSecurityFilter = this.getAutoSecurityFilter(securityInformationBuildItems, openApiConfig);
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(OASFilter.class).setRuntimeInit().supplier(recorder.autoSecurityFilterSupplier(autoSecurityFilter)).done());
        Handler handler = recorder.handler(openApiRuntimeConfig);
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(openApiConfig.path).routeConfigKey("quarkus.smallrye-openapi.path").handler(handler).displayOnNotFoundPage("Open API Schema document").blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(openApiConfig.path + ".json").handler(handler).build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(openApiConfig.path + ".yaml").handler(handler).build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(openApiConfig.path + ".yml").handler(handler).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void classLoaderHack(OpenApiRecorder recorder) {
        recorder.classLoaderHack();
    }

    @BuildStep
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(OpenApiDocumentService.class).setUnremovable().build());
    }

    @BuildStep
    OpenApiFilteredIndexViewBuildItem smallryeOpenApiIndex(CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{combinedIndexBuildItem.getIndex(), beanArchiveIndexBuildItem.getIndex()});
        return new OpenApiFilteredIndexViewBuildItem(new FilteredIndexView((IndexView)compositeIndex, (OpenApiConfig)new OpenApiConfigImpl(ConfigProvider.getConfig())));
    }

    @BuildStep
    void addSecurityFilter(BuildProducer<AddToOpenAPIDefinitionBuildItem> addToOpenAPIDefinitionProducer, OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, SmallRyeOpenApiConfig config) {
        OASFilter autoTagFilter;
        OASFilter autoRolesAllowedFilter;
        ArrayList rolesAllowedAnnotations = new ArrayList();
        for (DotName rolesAllowed : SecurityConstants.ROLES_ALLOWED) {
            rolesAllowedAnnotations.addAll(apiFilteredIndexViewBuildItem.getIndex().getAnnotations(rolesAllowed));
        }
        HashMap<String, List<String>> methodReferences = new HashMap<String, List<String>>();
        DotName securityRequirement = DotName.createSimple((String)SecurityRequirement.class.getName());
        for (AnnotationInstance ai : rolesAllowedAnnotations) {
            MethodInfo method;
            if (ai.target().kind().equals((Object)AnnotationTarget.Kind.METHOD) && this.isValidOpenAPIMethodForAutoAdd(method = ai.target().asMethod(), securityRequirement)) {
                String ref = JandexUtil.createUniqueMethodReference((ClassInfo)method.declaringClass(), (MethodInfo)method);
                methodReferences.put(ref, List.of(ai.value().asStringArray()));
            }
            if (!ai.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
            ClassInfo classInfo = ai.target().asClass();
            List methods = classInfo.methods();
            for (MethodInfo method2 : methods) {
                if (!this.isValidOpenAPIMethodForAutoAdd(method2, securityRequirement)) continue;
                String ref = JandexUtil.createUniqueMethodReference((ClassInfo)classInfo, (MethodInfo)method2);
                methodReferences.put(ref, List.of(ai.value().asStringArray()));
            }
        }
        if (config.securityScheme.isPresent()) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)new SecurityConfigFilter(config)));
        }
        if ((autoRolesAllowedFilter = this.getAutoRolesAllowedFilter(config.securitySchemeName, apiFilteredIndexViewBuildItem, config)) != null) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem(autoRolesAllowedFilter));
        }
        if ((autoTagFilter = this.getAutoTagFilter(apiFilteredIndexViewBuildItem, config)) != null) {
            addToOpenAPIDefinitionProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem(autoTagFilter));
        }
    }

    private OASFilter getAutoSecurityFilter(List<SecurityInformationBuildItem> securityInformationBuildItems, SmallRyeOpenApiConfig config) {
        if (!config.securityScheme.isPresent() && securityInformationBuildItems != null && !securityInformationBuildItems.isEmpty()) {
            for (SecurityInformationBuildItem securityInformationBuildItem : securityInformationBuildItems) {
                SecurityInformationBuildItem.SecurityModel securityModel = securityInformationBuildItem.getSecurityModel();
                switch (securityModel) {
                    case jwt: {
                        return new AutoJWTSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, config.jwtSecuritySchemeValue, config.jwtBearerFormat);
                    }
                    case basic: {
                        return new AutoBasicSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, config.basicSecuritySchemeValue);
                    }
                    case oidc: {
                        Optional maybeInfo = securityInformationBuildItem.getOpenIDConnectInformation();
                        if (!maybeInfo.isPresent()) break;
                        SecurityInformationBuildItem.OpenIDConnectInformation info = (SecurityInformationBuildItem.OpenIDConnectInformation)maybeInfo.get();
                        AutoUrl authorizationUrl = new AutoUrl((String)config.oidcOpenIdConnectUrl.orElse(null), info.getUrlConfigKey(), "/protocol/openid-connect/auth");
                        AutoUrl refreshUrl = new AutoUrl((String)config.oidcOpenIdConnectUrl.orElse(null), info.getUrlConfigKey(), "/protocol/openid-connect/token");
                        AutoUrl tokenUrl = new AutoUrl((String)config.oidcOpenIdConnectUrl.orElse(null), info.getUrlConfigKey(), "/protocol/openid-connect/token/introspect");
                        return new OpenIDConnectSecurityFilter(config.securitySchemeName, config.securitySchemeDescription, authorizationUrl, refreshUrl, tokenUrl);
                    }
                }
            }
        }
        return null;
    }

    private OASFilter getAutoRolesAllowedFilter(String securitySchemeName, OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, SmallRyeOpenApiConfig config) {
        Map<String, List<String>> rolesAllowedMethodReferences;
        if (config.autoAddSecurityRequirement && (rolesAllowedMethodReferences = this.getRolesAllowedMethodReferences(apiFilteredIndexViewBuildItem)) != null && !rolesAllowedMethodReferences.isEmpty()) {
            if (securitySchemeName == null) {
                securitySchemeName = config.securitySchemeName;
            }
            return new AutoRolesAllowedFilter(securitySchemeName, rolesAllowedMethodReferences);
        }
        return null;
    }

    private OASFilter getAutoTagFilter(OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem, SmallRyeOpenApiConfig config) {
        Map<String, String> classNamesMethodReferences;
        if (config.autoAddTags && (classNamesMethodReferences = this.getClassNamesMethodReferences(apiFilteredIndexViewBuildItem)) != null && !classNamesMethodReferences.isEmpty()) {
            return new AutoTagFilter(classNamesMethodReferences);
        }
        return null;
    }

    private Map<String, List<String>> getRolesAllowedMethodReferences(OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem) {
        ArrayList rolesAllowedAnnotations = new ArrayList();
        for (DotName rolesAllowed : SecurityConstants.ROLES_ALLOWED) {
            rolesAllowedAnnotations.addAll(apiFilteredIndexViewBuildItem.getIndex().getAnnotations(rolesAllowed));
        }
        HashMap<String, List<String>> methodReferences = new HashMap<String, List<String>>();
        DotName securityRequirement = DotName.createSimple((String)SecurityRequirement.class.getName());
        for (AnnotationInstance ai : rolesAllowedAnnotations) {
            MethodInfo method;
            if (ai.target().kind().equals((Object)AnnotationTarget.Kind.METHOD) && this.isValidOpenAPIMethodForAutoAdd(method = ai.target().asMethod(), securityRequirement)) {
                String ref = JandexUtil.createUniqueMethodReference((ClassInfo)method.declaringClass(), (MethodInfo)method);
                methodReferences.put(ref, List.of(ai.value().asStringArray()));
            }
            if (!ai.target().kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
            ClassInfo classInfo = ai.target().asClass();
            List methods = classInfo.methods();
            for (MethodInfo method2 : methods) {
                if (!this.isValidOpenAPIMethodForAutoAdd(method2, securityRequirement)) continue;
                String ref = JandexUtil.createUniqueMethodReference((ClassInfo)classInfo, (MethodInfo)method2);
                methodReferences.put(ref, List.of(ai.value().asStringArray()));
            }
        }
        return methodReferences;
    }

    private Map<String, String> getClassNamesMethodReferences(OpenApiFilteredIndexViewBuildItem apiFilteredIndexViewBuildItem) {
        ArrayList openapiAnnotations = new ArrayList();
        Set<DotName> allOpenAPIEndpoints = this.getAllOpenAPIEndpoints();
        for (DotName dotName : allOpenAPIEndpoints) {
            openapiAnnotations.addAll(apiFilteredIndexViewBuildItem.getIndex().getAnnotations(dotName));
        }
        HashMap<String, String> classNames = new HashMap<String, String>();
        for (AnnotationInstance ai : openapiAnnotations) {
            String implRef;
            MethodInfo implMethod;
            if (!ai.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) continue;
            MethodInfo method = ai.target().asMethod();
            if (Modifier.isInterface(method.declaringClass().flags())) {
                Collection allKnownImplementors = apiFilteredIndexViewBuildItem.getIndex().getAllKnownImplementors(method.declaringClass().name());
                for (ClassInfo impl : allKnownImplementors) {
                    implMethod = impl.method(method.name(), method.parameters().toArray(new Type[0]));
                    if (implMethod == null) continue;
                    implRef = JandexUtil.createUniqueMethodReference((ClassInfo)impl, (MethodInfo)method);
                    classNames.put(implRef, impl.simpleName());
                }
                continue;
            }
            if (Modifier.isAbstract(method.declaringClass().flags())) {
                Collection allKnownSubclasses = apiFilteredIndexViewBuildItem.getIndex().getAllKnownSubclasses(method.declaringClass().name());
                for (ClassInfo impl : allKnownSubclasses) {
                    implMethod = impl.method(method.name(), method.parameters().toArray(new Type[0]));
                    if (implMethod == null) continue;
                    implRef = JandexUtil.createUniqueMethodReference((ClassInfo)impl, (MethodInfo)method);
                    classNames.put(implRef, impl.simpleName());
                }
                continue;
            }
            String ref = JandexUtil.createUniqueMethodReference((ClassInfo)method.declaringClass(), (MethodInfo)method);
            classNames.put(ref, method.declaringClass().simpleName());
        }
        return classNames;
    }

    private boolean isValidOpenAPIMethodForAutoAdd(MethodInfo method, DotName securityRequirement) {
        return this.isOpenAPIEndpoint(method) && !method.hasAnnotation(securityRequirement) && method.declaringClass().classAnnotation(securityRequirement) == null;
    }

    @BuildStep
    public List<AllowedJaxRsAnnotationPrefixBuildItem> registerJaxRsSupportedAnnotation() {
        ArrayList<AllowedJaxRsAnnotationPrefixBuildItem> prefixes = new ArrayList<AllowedJaxRsAnnotationPrefixBuildItem>();
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("org.eclipse.microprofile.openapi.annotations"));
        return prefixes;
    }

    @BuildStep
    public void registerOpenApiSchemaClassesForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem, Capabilities capabilities) {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        if (this.shouldScanAnnotations(capabilities, (IndexView)index)) {
            Collection schemaAnnotationInstances = index.getAnnotations(OPENAPI_SCHEMA);
            for (AnnotationInstance schemaAnnotationInstance : schemaAnnotationInstances) {
                AnnotationTarget typeTarget = schemaAnnotationInstance.target();
                if (typeTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
                this.produceReflectiveHierarchy(reflectiveHierarchy, Type.create((DotName)typeTarget.asClass().name(), (Type.Kind)Type.Kind.CLASS), this.getClass().getSimpleName() + " > " + typeTarget.asClass().name());
            }
            Collection apiResponseAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSE);
            this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, apiResponseAnnotationInstances);
            Collection apiResponsesAnnotationInstances = index.getAnnotations(OPENAPI_RESPONSES);
            for (AnnotationInstance apiResponsesAnnotationInstance : apiResponsesAnnotationInstances) {
                AnnotationValue apiResponsesAnnotationValue = apiResponsesAnnotationInstance.value();
                if (apiResponsesAnnotationValue == null) continue;
                this.registerReflectionForApiResponseSchemaSerialization(reflectiveClass, reflectiveHierarchy, Arrays.asList(apiResponsesAnnotationValue.asNestedArray()));
            }
        }
    }

    private boolean isOpenAPIEndpoint(MethodInfo method) {
        Set<DotName> httpAnnotations = this.getAllOpenAPIEndpoints();
        for (DotName httpAnnotation : httpAnnotations) {
            if (!method.hasAnnotation(httpAnnotation)) continue;
            return true;
        }
        return false;
    }

    private Set<DotName> getAllOpenAPIEndpoints() {
        HashSet<DotName> httpAnnotations = new HashSet<DotName>();
        httpAnnotations.addAll(JaxRsConstants.HTTP_METHODS);
        httpAnnotations.addAll(SpringConstants.HTTP_METHODS);
        return httpAnnotations;
    }

    private void registerReflectionForApiResponseSchemaSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Collection<AnnotationInstance> apiResponseAnnotationInstances) {
        for (AnnotationInstance apiResponseAnnotationInstance : apiResponseAnnotationInstances) {
            AnnotationInstance[] contents;
            AnnotationValue contentAnnotationValue = apiResponseAnnotationInstance.value(OPENAPI_RESPONSE_CONTENT);
            if (contentAnnotationValue == null) continue;
            for (AnnotationInstance content : contents = contentAnnotationValue.asNestedArray()) {
                AnnotationValue schemaNotClass;
                AnnotationValue annotationValue = content.value(OPENAPI_RESPONSE_SCHEMA);
                if (annotationValue == null) continue;
                AnnotationInstance schema = annotationValue.asNested();
                String source = this.getClass().getSimpleName() + " > " + schema.target();
                AnnotationValue schemaImplementationClass = schema.value(OPENAPI_SCHEMA_IMPLEMENTATION);
                if (schemaImplementationClass != null) {
                    this.produceReflectiveHierarchy(reflectiveHierarchy, schemaImplementationClass.asClass(), source);
                }
                if ((schemaNotClass = schema.value(OPENAPI_SCHEMA_NOT)) != null) {
                    reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{schemaNotClass.asString()}));
                }
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ONE_OF), source);
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ANY_OF), source);
                this.produceReflectiveHierarchy(reflectiveHierarchy, schema.value(OPENAPI_SCHEMA_ALL_OF), source);
            }
        }
    }

    @BuildStep
    public void build(BuildProducer<FeatureBuildItem> feature, BuildProducer<GeneratedResourceBuildItem> resourceBuildItemBuildProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, OpenApiFilteredIndexViewBuildItem openApiFilteredIndexViewBuildItem, Capabilities capabilities, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems, HttpRootPathBuildItem httpRootPathBuildItem, OutputTargetBuildItem out, SmallRyeOpenApiConfig openApiConfig, Optional<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig, OutputTargetBuildItem outputTargetBuildItem) throws Exception {
        FilteredIndexView index = openApiFilteredIndexViewBuildItem.getIndex();
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_OPENAPI));
        OpenAPI staticModel = this.generateStaticModel(openApiConfig, outputTargetBuildItem.getOutputDirectory());
        Object annotationModel = this.shouldScanAnnotations(capabilities, (IndexView)index) ? this.generateAnnotationModel((IndexView)index, capabilities, httpRootPathBuildItem, resteasyJaxrsConfig) : new OpenAPIImpl();
        OpenApiDocument finalDocument = this.loadDocument(staticModel, (OpenAPI)annotationModel, openAPIBuildItems);
        for (Format format : Format.values()) {
            String name = "META-INF/quarkus-generated-openapi-doc." + format;
            byte[] schemaDocument = OpenApiSerializer.serialize((OpenAPI)finalDocument.get(), (Format)format).getBytes(StandardCharsets.UTF_8);
            resourceBuildItemBuildProducer.produce((BuildItem)new GeneratedResourceBuildItem(name, schemaDocument));
            nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{name}));
        }
        boolean shouldStore = openApiConfig.storeSchemaDirectory.isPresent();
        if (shouldStore) {
            this.storeDocument(out, openApiConfig, staticModel, (OpenAPI)annotationModel, openAPIBuildItems);
        }
    }

    @BuildStep
    LogCleanupFilterBuildItem logCleanup() {
        return new LogCleanupFilterBuildItem("io.smallrye.openapi.api.OpenApiDocument", new String[]{"OpenAPI document initialized:"});
    }

    private void produceReflectiveHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, AnnotationValue annotationValue, String source) {
        if (annotationValue != null) {
            for (Type type : annotationValue.asClassArray()) {
                this.produceReflectiveHierarchy(reflectiveHierarchy, type, source);
            }
        }
    }

    private void produceReflectiveHierarchy(BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, Type type, String source) {
        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
    }

    private void storeGeneratedSchema(SmallRyeOpenApiConfig openApiConfig, OutputTargetBuildItem out, byte[] schemaDocument, Format format) throws IOException {
        Path file;
        Path directory = (Path)openApiConfig.storeSchemaDirectory.get();
        Path outputDirectory = out.getOutputDirectory();
        if (!directory.isAbsolute() && outputDirectory != null) {
            directory = Paths.get(outputDirectory.getParent().toString(), directory.toString());
        }
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        if (!Files.exists(file = Paths.get(directory.toString(), "openapi." + format.toString().toLowerCase()), new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        Files.write(file, schemaDocument, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        log.info((Object)("OpenAPI " + format.toString() + " saved: " + file.toString()));
    }

    private boolean shouldScanAnnotations(Capabilities capabilities, IndexView index) {
        Config config = ConfigProvider.getConfig();
        boolean scanDisable = config.getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        if (scanDisable) {
            return false;
        }
        boolean isRestEasy = capabilities.isPresent("io.quarkus.resteasy");
        boolean isQuarkusRest = capabilities.isPresent("io.quarkus.resteasy.reactive");
        boolean isSpring = capabilities.isPresent("io.quarkus.spring.web");
        boolean isVertx = this.isUsingVertxRoute(index);
        return isRestEasy || isQuarkusRest || isSpring || isVertx;
    }

    private boolean isUsingVertxRoute(IndexView index) {
        return !index.getAnnotations(VertxConstants.ROUTE).isEmpty() || !index.getAnnotations(VertxConstants.ROUTE_BASE).isEmpty();
    }

    private OpenAPI generateStaticModel(SmallRyeOpenApiConfig openApiConfig, Path target) throws IOException {
        if (openApiConfig.ignoreStaticDocument) {
            return null;
        }
        List<Result> results = this.findStaticModels(openApiConfig, target);
        if (!results.isEmpty()) {
            OpenAPIImpl mergedStaticModel = new OpenAPIImpl();
            for (Result result : results) {
                InputStream is = result.inputStream;
                try (OpenApiStaticFile staticFile = new OpenApiStaticFile(is, result.format);){
                    OpenAPI staticFileModel = OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile);
                    mergedStaticModel = (OpenAPI)MergeUtil.mergeObjects((Object)mergedStaticModel, (Object)staticFileModel);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return mergedStaticModel;
        }
        return null;
    }

    private OpenAPI generateAnnotationModel(IndexView indexView, Capabilities capabilities, HttpRootPathBuildItem httpRootPathBuildItem, Optional<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfig openApiConfig = OpenApiConfigImpl.fromConfig((Config)config);
        ArrayList<Object> extensions = new ArrayList<Object>();
        String defaultPath = httpRootPathBuildItem.getRootPath();
        if (capabilities.isPresent("io.quarkus.resteasy")) {
            extensions.add(new RESTEasyExtension(indexView));
            if (resteasyJaxrsConfig.isPresent()) {
                defaultPath = resteasyJaxrsConfig.get().getRootPath();
            }
        } else if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            extensions.add(new RESTEasyExtension(indexView));
            openApiConfig.doAllowNakedPathParameter();
            Optional maybePath = config.getOptionalValue("quarkus.resteasy-reactive.path", String.class);
            if (maybePath.isPresent()) {
                defaultPath = (String)maybePath.get();
            }
        }
        if (defaultPath != null && !"/".equals(defaultPath)) {
            extensions.add(new CustomPathExtension(defaultPath));
        }
        OpenApiAnnotationScanner openApiAnnotationScanner = new OpenApiAnnotationScanner(openApiConfig, indexView, extensions);
        return openApiAnnotationScanner.scan(this.getScanners(capabilities, indexView));
    }

    private String[] getScanners(Capabilities capabilities, IndexView index) {
        ArrayList<String> scanners = new ArrayList<String>();
        if (capabilities.isPresent("io.quarkus.resteasy") || capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            scanners.add(JAX_RS);
        }
        if (capabilities.isPresent("io.quarkus.spring.web")) {
            scanners.add(SPRING);
        }
        if (this.isUsingVertxRoute(index)) {
            scanners.add(VERT_X);
        }
        return scanners.toArray(new String[0]);
    }

    private List<Result> findStaticModels(SmallRyeOpenApiConfig openApiConfig, Path target) {
        List<Result> results = new ArrayList<Result>();
        results = this.addStaticModelIfExist(results, Format.YAML, META_INF_OPENAPI_YAML);
        results = this.addStaticModelIfExist(results, Format.YAML, WEB_INF_CLASSES_META_INF_OPENAPI_YAML);
        results = this.addStaticModelIfExist(results, Format.YAML, META_INF_OPENAPI_YML);
        results = this.addStaticModelIfExist(results, Format.YAML, WEB_INF_CLASSES_META_INF_OPENAPI_YML);
        results = this.addStaticModelIfExist(results, Format.JSON, META_INF_OPENAPI_JSON);
        results = this.addStaticModelIfExist(results, Format.JSON, WEB_INF_CLASSES_META_INF_OPENAPI_JSON);
        if (openApiConfig.additionalDocsDirectory.isPresent()) {
            List additionalStaticDocuments = (List)openApiConfig.additionalDocsDirectory.get();
            for (Path path : additionalStaticDocuments) {
                try {
                    List<String> filesInDir = this.getResourceFiles(path.toString(), target);
                    for (String possibleModelFile : filesInDir) {
                        results = this.addStaticModelIfExist(results, possibleModelFile);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return results;
    }

    private List<Result> addStaticModelIfExist(List<Result> results, String path) {
        if (path.endsWith(".json")) {
            results = this.addStaticModelIfExist(results, Format.JSON, path);
        } else if (path.endsWith(".yaml") || path.endsWith(".yml")) {
            results = this.addStaticModelIfExist(results, Format.YAML, path);
        }
        return results;
    }

    private List<Result> addStaticModelIfExist(List<Result> results, Format format, String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream inputStream = cl.getResourceAsStream(path);){
            if (inputStream != null) {
                results.add(new Result(format, inputStream));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getResourceFiles(String pathName, Path target) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        if (target == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try (InputStream inputStream = cl.getResourceAsStream(pathName);){
                if (inputStream == null) return filenames;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                    String resource;
                    while ((resource = br.readLine()) != null) {
                        filenames.add(pathName + "/" + resource);
                    }
                    return filenames;
                }
            }
        } else {
            Path classes = target.resolve("classes");
            if (classes == null) return filenames;
            Path path = classes.resolve(pathName);
            return Files.list(path).map(t -> pathName + "/" + t.getFileName().toString()).collect(Collectors.toList());
        }
    }

    private OpenApiDocument loadDocument(OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems) {
        OpenApiDocument document = this.prepareOpenApiDocument(staticModel, annotationModel, openAPIBuildItems);
        Config c = ConfigProvider.getConfig();
        String title = c.getOptionalValue("quarkus.application.name", String.class).orElse("Generated");
        String version = c.getOptionalValue("quarkus.application.version", String.class).orElse("1.0");
        document.archiveName(title);
        document.version(version);
        document.initialize();
        return document;
    }

    private void storeDocument(OutputTargetBuildItem out, SmallRyeOpenApiConfig smallRyeOpenApiConfig, OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems) throws IOException {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenApiDocument document = this.prepareOpenApiDocument(staticModel, annotationModel, openAPIBuildItems);
        document.filter(this.filter((OpenApiConfig)openApiConfig));
        document.initialize();
        for (Format format : Format.values()) {
            String name = "META-INF/quarkus-generated-openapi-doc." + format;
            byte[] schemaDocument = OpenApiSerializer.serialize((OpenAPI)document.get(), (Format)format).getBytes(StandardCharsets.UTF_8);
            this.storeGeneratedSchema(smallRyeOpenApiConfig, out, schemaDocument, format);
        }
    }

    private OpenApiDocument prepareOpenApiDocument(OpenAPI staticModel, OpenAPI annotationModel, List<AddToOpenAPIDefinitionBuildItem> openAPIBuildItems) {
        Config config = ConfigProvider.getConfig();
        OpenApiConfigImpl openApiConfig = new OpenApiConfigImpl(config);
        OpenAPI readerModel = OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
        OpenApiDocument document = this.createDocument((OpenApiConfig)openApiConfig);
        if (annotationModel != null) {
            document.modelFromAnnotations(annotationModel);
        }
        document.modelFromReader(readerModel);
        document.modelFromStaticFile(staticModel);
        for (AddToOpenAPIDefinitionBuildItem openAPIBuildItem : openAPIBuildItems) {
            OASFilter otherExtensionFilter = openAPIBuildItem.getOASFilter();
            document.filter(otherExtensionFilter);
        }
        return document;
    }

    private OpenApiDocument createDocument(OpenApiConfig openApiConfig) {
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        document.reset();
        document.config(openApiConfig);
        return document;
    }

    private OASFilter filter(OpenApiConfig openApiConfig) {
        return OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    static {
        System.setProperty("mp.openapi.extensions.smallrye.defaultProduces", "application/json");
        System.setProperty("mp.openapi.extensions.smallrye.defaultConsumes", "application/json");
    }

    static class Result {
        final Format format;
        final InputStream inputStream;

        Result(Format format, InputStream inputStream) {
            this.format = format;
            this.inputStream = inputStream;
        }
    }
}

