/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.quarkus.resteasy.reactive.jackson.runtime.ResteasyReactiveServerJacksonRecorder;
import io.quarkus.resteasy.reactive.jackson.runtime.serialisers.AbstractServerJacksonMessageBodyReader;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.util.StreamUtil;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jackson.JacksonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class FullyFeaturedServerJacksonMessageBodyReader
extends AbstractServerJacksonMessageBodyReader
implements ServerMessageBodyReader<Object> {
    private final Instance<ObjectMapper> originalMapper;
    private final Providers providers;
    private final ConcurrentMap<String, ObjectReader> perMethodReader = new ConcurrentHashMap<String, ObjectReader>();
    private final ConcurrentMap<String, ObjectReader> perTypeReader = new ConcurrentHashMap<String, ObjectReader>();
    private final ConcurrentMap<Class<?>, ObjectMapper> contextResolverMap = new ConcurrentHashMap();
    private final ConcurrentMap<ObjectMapper, ObjectReader> objectReaderMap = new ConcurrentHashMap<ObjectMapper, ObjectReader>();

    public FullyFeaturedServerJacksonMessageBodyReader() {
        this.originalMapper = null;
        this.providers = null;
    }

    @Inject
    public FullyFeaturedServerJacksonMessageBodyReader(Instance<ObjectMapper> mapper, Providers providers) {
        super(mapper);
        this.originalMapper = mapper;
        this.providers = providers;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.doReadFrom(type, genericType, mediaType, entityStream);
        }
        catch (InvalidDefinitionException | MismatchedInputException e) {
            throw e;
        }
        catch (StreamConstraintsException | StreamReadException | DatabindException e) {
            throw new WebApplicationException(e, Response.Status.BAD_REQUEST);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        return this.readFrom(type, genericType, null, mediaType, null, context.getInputStream());
    }

    private Object doReadFrom(Class<Object> type, Type genericType, MediaType responseMediaType, InputStream entityStream) throws IOException {
        if (StreamUtil.isEmpty((InputStream)entityStream)) {
            return null;
        }
        try {
            ObjectReader reader = this.getEffectiveReader(type, genericType, responseMediaType);
            return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
        catch (MismatchedInputException e) {
            if (this.isEmptyInputException(e)) {
                return null;
            }
            throw e;
        }
    }

    private boolean isEmptyInputException(MismatchedInputException e) {
        return e.getMessage().startsWith("No content");
    }

    private ObjectReader getObjectReaderFromAnnotations(ResteasyReactiveResourceInfo resourceInfo, Type type, ObjectMapper mapper) {
        String methodId = resourceInfo.getMethodId();
        Class<? extends BiFunction<ObjectMapper, Type, ObjectReader>> customDeserializationValue = ResteasyReactiveServerJacksonRecorder.customDeserializationForMethod(methodId);
        if (customDeserializationValue != null) {
            return this.perMethodReader.computeIfAbsent(methodId, new MethodObjectReaderFunction(customDeserializationValue, type, mapper));
        }
        customDeserializationValue = ResteasyReactiveServerJacksonRecorder.customDeserializationForClass(resourceInfo.getResourceClass());
        if (customDeserializationValue != null) {
            Type effectiveType = type;
            if (type instanceof ParameterizedType) {
                effectiveType = ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return this.perTypeReader.computeIfAbsent(effectiveType.getTypeName(), new MethodObjectReaderFunction(customDeserializationValue, type, mapper));
        }
        return null;
    }

    private ObjectReader getEffectiveReader(Class<Object> type, Type genericType, MediaType responseMediaType) {
        ResteasyReactiveResourceInfo resourceInfo;
        ResteasyReactiveRequestContext context;
        ObjectMapper effectiveMapper = this.getEffectiveMapper(type, responseMediaType);
        ObjectReader effectiveReader = (ObjectReader)this.defaultReader.get();
        if (effectiveMapper != this.originalMapper) {
            effectiveReader = this.objectReaderMap.computeIfAbsent(effectiveMapper, new Function<ObjectMapper, ObjectReader>(){

                @Override
                public ObjectReader apply(ObjectMapper objectMapper) {
                    return objectMapper.reader();
                }
            });
        }
        if ((context = CurrentRequestManager.get()) != null && (resourceInfo = context.getResteasyReactiveResourceInfo()) != null) {
            Class<?> jsonViewValue;
            ObjectReader readerFromAnnotation = this.getObjectReaderFromAnnotations(resourceInfo, genericType, effectiveMapper);
            if (readerFromAnnotation != null) {
                effectiveReader = readerFromAnnotation;
            }
            if ((jsonViewValue = ResteasyReactiveServerJacksonRecorder.jsonViewForMethod("request-body;" + resourceInfo.getMethodId())) != null) {
                return effectiveReader.withView(jsonViewValue);
            }
        }
        return effectiveReader;
    }

    private ObjectMapper getEffectiveMapper(Class<Object> type, MediaType responseMediaType) {
        ContextResolver cr;
        ObjectMapper result;
        if (this.providers == null) {
            return (ObjectMapper)this.originalMapper.get();
        }
        ContextResolver contextResolver = this.providers.getContextResolver(ObjectMapper.class, responseMediaType);
        if (contextResolver == null) {
            contextResolver = this.providers.getContextResolver(ObjectMapper.class, null);
        }
        if (contextResolver != null && (result = this.contextResolverMap.computeIfAbsent(type, new Function<Class<?>, ObjectMapper>(cr = contextResolver, type){
            final /* synthetic */ ContextResolver val$cr;
            final /* synthetic */ Class val$type;
            {
                this.val$cr = contextResolver;
                this.val$type = clazz;
            }

            @Override
            public ObjectMapper apply(Class<?> aClass) {
                return (ObjectMapper)this.val$cr.getContext(this.val$type);
            }
        })) != null) {
            return result;
        }
        return (ObjectMapper)this.originalMapper.get();
    }

    private static class MethodObjectReaderFunction
    implements Function<String, ObjectReader> {
        private final Class<? extends BiFunction<ObjectMapper, Type, ObjectReader>> clazz;
        private final Type genericType;
        private final ObjectMapper originalMapper;

        public MethodObjectReaderFunction(Class<? extends BiFunction<ObjectMapper, Type, ObjectReader>> clazz, Type genericType, ObjectMapper originalMapper) {
            this.clazz = clazz;
            this.genericType = genericType;
            this.originalMapper = originalMapper;
        }

        @Override
        public ObjectReader apply(String methodId) {
            try {
                BiFunction<ObjectMapper, Type, ObjectReader> biFunctionInstance = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ObjectReader objectReader = biFunctionInstance.apply(this.originalMapper, this.genericType);
                JacksonMessageBodyWriterUtil.setNecessaryJsonFactoryConfig((JsonFactory)objectReader.getFactory());
                return objectReader;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

