/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.deployment;

import io.quarkus.arc.BeanDestroyer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.restclient.NoopHostnameVerifier;
import io.quarkus.restclient.deployment.RestClientAnnotationProviderBuildItem;
import io.quarkus.restclient.runtime.RestClientBase;
import io.quarkus.restclient.runtime.RestClientRecorder;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.RestClientBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import java.io.Closeable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.context.SessionScoped;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ProxyBuilderImpl;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ResteasyClientProxy;
import org.jboss.resteasy.core.providerfactory.ResteasyProviderFactoryImpl;
import org.jboss.resteasy.microprofile.client.DefaultResponseExceptionMapper;
import org.jboss.resteasy.microprofile.client.RestClientProxy;
import org.jboss.resteasy.microprofile.client.async.AsyncInterceptorRxInvokerProvider;
import org.jboss.resteasy.spi.ResteasyConfiguration;

class RestClientProcessor {
    private static final Logger log = Logger.getLogger(RestClientProcessor.class);
    private static final DotName REST_CLIENT = DotName.createSimple((String)RestClient.class.getName());
    private static final DotName REGISTER_REST_CLIENT = DotName.createSimple((String)RegisterRestClient.class.getName());
    private static final DotName SESSION_SCOPED = DotName.createSimple((String)SessionScoped.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName REGISTER_PROVIDER = DotName.createSimple((String)RegisterProvider.class.getName());
    private static final DotName REGISTER_PROVIDERS = DotName.createSimple((String)RegisterProviders.class.getName());
    private static final DotName REGISTER_CLIENT_HEADERS = DotName.createSimple((String)RegisterClientHeaders.class.getName());
    private static final DotName CLIENT_REQUEST_FILTER = DotName.createSimple((String)ClientRequestFilter.class.getName());
    private static final DotName CLIENT_RESPONSE_FILTER = DotName.createSimple((String)ClientResponseFilter.class.getName());
    private static final DotName CLIENT_HEADER_PARAM = DotName.createSimple((String)ClientHeaderParam.class.getName());
    private static final String PROVIDERS_SERVICE_FILE = "META-INF/services/" + Providers.class.getName();

    RestClientProcessor() {
    }

    @BuildStep
    void setupProviders(BuildProducer<NativeImageResourceBuildItem> resources, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition) {
        proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{"javax.ws.rs.ext.Providers"}));
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{PROVIDERS_SERVICE_FILE}));
    }

    @BuildStep
    void setupClientBuilder(BuildProducer<NativeImageResourceBuildItem> resources) {
        resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/javax.ws.rs.client.ClientBuilder"}));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    BeanContainerListenerBuildItem fixExtension(RestClientRecorder restClientRecorder) {
        return new BeanContainerListenerBuildItem(restClientRecorder.hackAroundExtension());
    }

    @BuildStep
    NativeImageProxyDefinitionBuildItem addProxy() {
        return new NativeImageProxyDefinitionBuildItem(new String[]{ResteasyConfiguration.class.getName()});
    }

    @BuildStep
    void registerRestClientListenerForTracing(Capabilities capabilities, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        if (capabilities.isPresent(Capability.SMALLRYE_OPENTRACING)) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"io.smallrye.opentracing.SmallRyeRestClientListener"}));
        } else if (capabilities.isPresent(Capability.OPENTELEMETRY_TRACER)) {
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.eclipse.microprofile.rest.client.spi.RestClientListener"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"io.quarkus.opentelemetry.tracing.client.QuarkusRestClientListener"}));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setup(BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, RestClientRecorder restClientRecorder) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.REST_CLIENT));
        restClientRecorder.setRestClientBuilderResolver();
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{RestClient.class}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{DefaultResponseExceptionMapper.class.getName(), AsyncInterceptorRxInvokerProvider.class.getName(), ResteasyProviderFactoryImpl.class.getName(), ProxyBuilderImpl.class.getName(), ClientRequestFilter[].class.getName(), ClientResponseFilter[].class.getName(), ReaderInterceptor[].class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{ResteasyClientBuilder.class.getName(), NoopHostnameVerifier.class.getName()}));
    }

    @BuildStep
    void processInterfaces(CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, Capabilities capabilities, PackageConfig packageConfig, List<RestClientAnnotationProviderBuildItem> restClientAnnotationProviders, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<RestClientBuildItem> restClient) {
        HashMap<DotName, ClassInfo> interfaces = new HashMap<DotName, ClassInfo>();
        HashSet<Type> returnTypes = new HashSet<Type>();
        CompositeIndex index = CompositeIndex.create((IndexView[])new IndexView[]{beanArchiveIndexBuildItem.getIndex(), combinedIndexBuildItem.getIndex()});
        this.findInterfaces((IndexView)index, interfaces, returnTypes, REGISTER_REST_CLIENT);
        this.findInterfaces((IndexView)index, interfaces, returnTypes, PATH);
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName dotName : interfaces.keySet()) {
            restClient.produce((BuildItem)new RestClientBuildItem(dotName.toString()));
        }
        this.warnAboutNotWorkingFeaturesInNative(packageConfig, interfaces);
        for (Map.Entry entry : interfaces.entrySet()) {
            String string = ((DotName)entry.getKey()).toString();
            proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{string, ResteasyClientProxy.class.getName()}));
            proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{string, RestClientProxy.class.getName(), Closeable.class.getName()}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{string}));
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{DefaultClientHeadersFactoryImpl.class.getName()}));
        for (Type type : returnTypes) {
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(this.getClass().getSimpleName() + " > " + type.toString()).build());
        }
        Config config = ConfigProvider.getConfig();
        for (Map.Entry<DotName, ClassInfo> entry : interfaces.entrySet()) {
            DotName restClientName = (DotName)entry.getKey();
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = SyntheticBeanBuildItem.configure((DotName)restClientName);
            configurator.addType(restClientName);
            configurator.addQualifier(REST_CLIENT);
            String configPrefix = this.computeConfigPrefix(restClientName.toString(), (ClassInfo)entry.getValue());
            ScopeInfo scope = this.computeDefaultScope(capabilities, config, entry, configPrefix);
            List<Class<?>> annotationProviders = RestClientProcessor.checkAnnotationProviders(entry.getValue(), restClientAnnotationProviders);
            configurator.scope(scope);
            configurator.creator(m -> {
                ResultHandle interfaceHandle = m.loadClass(restClientName.toString());
                ResultHandle baseUriHandle = m.load(this.getAnnotationParameter((ClassInfo)entry.getValue(), "baseUri"));
                ResultHandle configPrefixHandle = m.load(configPrefix);
                ResultHandle annotationProvidersHandle = null;
                if (!annotationProviders.isEmpty()) {
                    annotationProvidersHandle = m.newArray(Class.class, annotationProviders.size());
                    for (int i = 0; i < annotationProviders.size(); ++i) {
                        m.writeArrayValue(annotationProvidersHandle, i, m.loadClass((Class)annotationProviders.get(i)));
                    }
                } else {
                    annotationProvidersHandle = m.loadNull();
                }
                ResultHandle baseHandle = m.newInstance(MethodDescriptor.ofConstructor(RestClientBase.class, (Class[])new Class[]{Class.class, String.class, String.class, Class[].class}), new ResultHandle[]{interfaceHandle, baseUriHandle, configPrefixHandle, annotationProvidersHandle});
                ResultHandle ret = m.invokeVirtualMethod(MethodDescriptor.ofMethod(RestClientBase.class, (String)"create", Object.class, (Class[])new Class[0]), baseHandle, new ResultHandle[0]);
                m.returnValue(ret);
            });
            configurator.destroyer(BeanDestroyer.CloseableDestroyer.class);
            syntheticBeans.produce((BuildItem)configurator.done());
        }
    }

    private static List<Class<?>> checkAnnotationProviders(ClassInfo classInfo, List<RestClientAnnotationProviderBuildItem> restClientAnnotationProviders) {
        return restClientAnnotationProviders.stream().filter(p -> classInfo.classAnnotation(p.getAnnotationName()) != null).map(p -> p.getProviderClass()).collect(Collectors.toList());
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(Feature.REST_CLIENT);
    }

    private void warnAboutNotWorkingFeaturesInNative(PackageConfig packageConfig, Map<DotName, ClassInfo> interfaces) {
        if (!packageConfig.type.equalsIgnoreCase("native")) {
            return;
        }
        HashSet<DotName> dotNames = new HashSet<DotName>();
        for (ClassInfo interfaze : interfaces.values()) {
            if (interfaze.classAnnotation(CLIENT_HEADER_PARAM) == null) continue;
            boolean hasDefault = false;
            for (MethodInfo method : interfaze.methods()) {
                if (!RestClientProcessor.isDefault(method.flags())) continue;
                hasDefault = true;
                break;
            }
            if (!hasDefault) continue;
            dotNames.add(interfaze.name());
        }
        if (!dotNames.isEmpty()) {
            log.warnf("rest-client interfaces that contain default methods and are annotated with '@" + CLIENT_HEADER_PARAM + "' might not work properly in native mode. Offending interfaces are: " + dotNames.stream().map(d -> "'" + d.toString() + "'").collect(Collectors.joining(", ")), new Object[0]);
        }
    }

    private static boolean isDefault(short flags) {
        return (flags & 0x409) == 1;
    }

    private void findInterfaces(IndexView index, Map<DotName, ClassInfo> interfaces, Set<Type> returnTypes, DotName annotationToFind) {
        for (AnnotationInstance annotation : index.getAnnotations(annotationToFind)) {
            ClassInfo theInfo;
            AnnotationTarget target = annotation.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                theInfo = target.asClass();
            } else {
                if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
                theInfo = target.asMethod().declaringClass();
            }
            if (!this.isRestClientInterface(index, theInfo)) continue;
            interfaces.put(theInfo.name(), theInfo);
            this.processInterfaceReturnTypes(theInfo, returnTypes);
            for (Type interfaceType : theInfo.interfaceTypes()) {
                ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
                if (interfaceClassInfo == null) continue;
                this.processInterfaceReturnTypes(interfaceClassInfo, returnTypes);
            }
        }
    }

    private void processInterfaceReturnTypes(ClassInfo classInfo, Set<Type> returnTypes) {
        for (MethodInfo method : classInfo.methods()) {
            Type type = method.returnType();
            if (type.name().toString().startsWith("java.lang")) continue;
            returnTypes.add(type);
        }
    }

    private String computeConfigPrefix(String interfaceName, ClassInfo classInfo) {
        String propertyPrefixFromAnnotation = this.getAnnotationParameter(classInfo, "configKey");
        if (propertyPrefixFromAnnotation != null && !propertyPrefixFromAnnotation.isEmpty()) {
            return propertyPrefixFromAnnotation;
        }
        return interfaceName;
    }

    private ScopeInfo computeDefaultScope(Capabilities capabilities, Config config, Map.Entry<DotName, ClassInfo> entry, String configPrefix) {
        ScopeInfo scopeToUse;
        block6: {
            block5: {
                scopeToUse = null;
                Optional scopeConfig = config.getOptionalValue(String.format("%s/mp-rest/scope", configPrefix), String.class);
                if (!scopeConfig.isPresent()) break block5;
                DotName scope = DotName.createSimple((String)((String)scopeConfig.get()));
                BuiltinScope builtinScope = BuiltinScope.from((DotName)scope);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                } else if (capabilities.isPresent(Capability.SERVLET) && scope.equals((Object)SESSION_SCOPED)) {
                    scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                }
                if (scopeToUse != null) break block6;
                log.warn((Object)String.format("Unsupported default scope %s provided for rest client %s. Defaulting to @Dependent.", scope, entry.getKey()));
                scopeToUse = BuiltinScope.DEPENDENT.getInfo();
                break block6;
            }
            Set annotations = entry.getValue().annotations().keySet();
            for (DotName annotationName : annotations) {
                BuiltinScope builtinScope = BuiltinScope.from((DotName)annotationName);
                if (builtinScope != null) {
                    scopeToUse = builtinScope.getInfo();
                    break;
                }
                if (!annotationName.equals((Object)SESSION_SCOPED)) continue;
                scopeToUse = new ScopeInfo(SESSION_SCOPED, true);
                break;
            }
        }
        return scopeToUse != null ? scopeToUse : BuiltinScope.DEPENDENT.getInfo();
    }

    private String getAnnotationParameter(ClassInfo classInfo, String parameterName) {
        AnnotationInstance instance = classInfo.classAnnotation(REGISTER_REST_CLIENT);
        if (instance == null) {
            return "";
        }
        AnnotationValue value = instance.value(parameterName);
        if (value == null) {
            return "";
        }
        return value.asString();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, ResteasyInjectionReadyBuildItem injectorFactory, RestClientRecorder restClientRecorder) {
        restClientRecorder.initializeResteasyProviderFactory(injectorFactory.getInjectorFactory(), jaxrsProvidersToRegisterBuildItem.useBuiltIn(), jaxrsProvidersToRegisterBuildItem.getProviders(), jaxrsProvidersToRegisterBuildItem.getContributedProviders());
        for (String providerToRegister : jaxrsProvidersToRegisterBuildItem.getProviders()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{providerToRegister}));
        }
        IndexView index = combinedIndexBuildItem.getIndex();
        ArrayList<AnnotationInstance> allInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(REGISTER_PROVIDER));
        for (AnnotationInstance annotation : index.getAnnotations(REGISTER_PROVIDERS)) {
            allInstances.addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        for (AnnotationInstance annotationInstance : allInstances) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{annotationInstance.value().asClass().toString()}));
        }
        for (AnnotationInstance annotationInstance : index.getAnnotations(REGISTER_CLIENT_HEADERS)) {
            AnnotationValue value = annotationInstance.value();
            if (value == null) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{annotationInstance.value().asClass().toString()}));
        }
        for (ClassInfo info : index.getAllKnownImplementors(CLIENT_REQUEST_FILTER)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{info.name().toString()}));
        }
        for (ClassInfo info : index.getAllKnownImplementors(CLIENT_RESPONSE_FILTER)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{info.name().toString()}));
        }
    }

    @BuildStep
    AdditionalBeanBuildItem registerProviderBeans(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        ArrayList<AnnotationInstance> allInstances = new ArrayList<AnnotationInstance>(index.getAnnotations(REGISTER_PROVIDER));
        for (AnnotationInstance annotation : index.getAnnotations(REGISTER_PROVIDERS)) {
            allInstances.addAll(Arrays.asList(annotation.value().asNestedArray()));
        }
        allInstances.addAll(index.getAnnotations(REGISTER_CLIENT_HEADERS));
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        for (AnnotationInstance annotationInstance : allInstances) {
            AnnotationValue value = annotationInstance.value();
            if (value == null) continue;
            builder.addBeanClass(value.asClass().toString());
        }
        return builder.build();
    }

    private boolean isRestClientInterface(IndexView index, ClassInfo classInfo) {
        return Modifier.isInterface(classInfo.flags()) && index.getAllKnownImplementors(classInfo.name()).isEmpty();
    }
}

