/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.runtime.TemplateProducer;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.BiFunction;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

class TemplateRecordEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private final ClassInfo interfaceToImplement;
    private final String recordClassName;
    private final String templateId;
    private final String fragmentId;
    private final List<MethodParameterInfo> parameters;
    private final CheckedTemplateAdapter adapter;

    TemplateRecordEnhancer(ClassInfo interfaceToImplement, ClassInfo recordClass, String templateId, String fragmentId, List<MethodParameterInfo> parameters, CheckedTemplateAdapter adapter) {
        this.interfaceToImplement = interfaceToImplement;
        this.recordClassName = recordClass.name().toString();
        this.templateId = templateId;
        this.fragmentId = fragmentId;
        this.parameters = parameters;
        this.adapter = adapter;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new TemplateRecordClassVisitor(outputClassVisitor);
    }

    private static void invokeInterface(MethodVisitor methodVisitor, MethodDescriptor descriptor) {
        methodVisitor.visitMethodInsn(185, descriptor.getDeclaringClass(), descriptor.getName(), descriptor.getDescriptor(), true);
    }

    private static String toInternalClassName(Class<?> clazz) {
        return DescriptorUtils.objectToInternalClassName(clazz);
    }

    private static String toInternalClassName(String clazzName) {
        return DescriptorUtils.objectToInternalClassName((Object)clazzName);
    }

    class TemplateRecordClassVisitor
    extends ClassVisitor {
        public TemplateRecordClassVisitor(ClassVisitor outputClassVisitor) {
            super(589824, outputClassVisitor);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor ret = super.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("<init>")) {
                return new TemplateRecordConstructorVisitor(ret);
            }
            return ret;
        }

        public void visitEnd() {
            String interfaceName = TemplateRecordEnhancer.this.interfaceToImplement.name().toString();
            FieldDescriptor quteTemplateInstanceDescriptor = FieldDescriptor.of((String)TemplateRecordEnhancer.this.recordClassName, (String)"qute$templateInstance", (String)interfaceName);
            FieldVisitor quteTemplateInstance = super.visitField(18, quteTemplateInstanceDescriptor.getName(), quteTemplateInstanceDescriptor.getType(), null, null);
            quteTemplateInstance.visitEnd();
            for (MethodInfo method : TemplateRecordEnhancer.this.interfaceToImplement.methods()) {
                if (method.isSynthetic() || method.isBridge()) continue;
                MethodDescriptor descriptor = MethodDescriptor.of((MethodInfo)method);
                String[] exceptions = (String[])method.exceptions().stream().map(e -> TemplateRecordEnhancer.toInternalClassName(e.name().toString())).toArray(String[]::new);
                MethodVisitor visitor = super.visitMethod(1, descriptor.getName(), descriptor.getDescriptor(), null, exceptions);
                visitor.visitCode();
                this.readQuteTemplateInstance(visitor);
                int idx = 1;
                for (Type paramType : method.parameterTypes()) {
                    visitor.visitVarInsn(AsmUtil.getLoadOpcode((Type)paramType), idx++);
                }
                TemplateRecordEnhancer.invokeInterface(visitor, descriptor);
                this.returnAndEnd(visitor, method.returnType());
            }
            super.visitEnd();
        }

        private void readQuteTemplateInstance(MethodVisitor methodVisitor) {
            FieldDescriptor quteTemplateInstanceDescriptor = FieldDescriptor.of((String)TemplateRecordEnhancer.this.recordClassName, (String)"qute$templateInstance", (String)TemplateRecordEnhancer.this.interfaceToImplement.name().toString());
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, quteTemplateInstanceDescriptor.getDeclaringClass(), quteTemplateInstanceDescriptor.getName(), quteTemplateInstanceDescriptor.getType());
        }

        private void returnAndEnd(MethodVisitor methodVisitor, Type returnType) {
            methodVisitor.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
            methodVisitor.visitEnd();
            methodVisitor.visitMaxs(-1, -1);
        }
    }

    class TemplateRecordConstructorVisitor
    extends MethodVisitor {
        public TemplateRecordConstructorVisitor(MethodVisitor outputVisitor) {
            super(589824, outputVisitor);
        }

        public void visitInsn(int opcode) {
            if (opcode != 177) {
                super.visitInsn(opcode);
            }
        }

        public void visitEnd() {
            this.visitCode();
            this.visitVarInsn(25, 0);
            MethodDescriptor arcContainer = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
            MethodDescriptor arcContainerInstance = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class});
            MethodDescriptor instanceHandleGet = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
            MethodDescriptor templateProducerGetInjectableTemplate = MethodDescriptor.ofMethod(TemplateProducer.class, (String)"getInjectableTemplate", Template.class, (Class[])new Class[]{String.class});
            MethodDescriptor templateInstance = MethodDescriptor.ofMethod(Template.class, (String)"instance", TemplateInstance.class, (Class[])new Class[0]);
            MethodDescriptor templateGetFragment = MethodDescriptor.ofMethod(Template.class, (String)"getFragment", Template.Fragment.class, (Class[])new Class[]{String.class});
            MethodDescriptor templateInstanceData = MethodDescriptor.ofMethod(TemplateInstance.class, (String)"data", TemplateInstance.class, (Class[])new Class[]{String.class, Object.class});
            this.visitMethodInsn(184, arcContainer.getDeclaringClass(), arcContainer.getName(), arcContainer.getDescriptor(), false);
            this.visitLdcInsn(org.objectweb.asm.Type.getType(TemplateProducer.class));
            this.visitLdcInsn(0);
            this.visitTypeInsn(189, TemplateRecordEnhancer.toInternalClassName(Annotation.class));
            TemplateRecordEnhancer.invokeInterface(this, arcContainerInstance);
            TemplateRecordEnhancer.invokeInterface(this, instanceHandleGet);
            this.visitTypeInsn(192, TemplateRecordEnhancer.toInternalClassName(TemplateProducer.class));
            this.visitLdcInsn(TemplateRecordEnhancer.this.templateId);
            this.visitMethodInsn(182, templateProducerGetInjectableTemplate.getDeclaringClass(), templateProducerGetInjectableTemplate.getName(), templateProducerGetInjectableTemplate.getDescriptor(), false);
            if (TemplateRecordEnhancer.this.fragmentId != null) {
                this.visitLdcInsn(TemplateRecordEnhancer.this.fragmentId);
                TemplateRecordEnhancer.invokeInterface(this, templateGetFragment);
            }
            TemplateRecordEnhancer.invokeInterface(this, templateInstance);
            if (TemplateRecordEnhancer.this.adapter != null) {
                TemplateRecordEnhancer.this.adapter.convertTemplateInstance(this);
                templateInstanceData = MethodDescriptor.ofMethod((Object)TemplateRecordEnhancer.this.adapter.templateInstanceBinaryName(), (String)"data", (Object)TemplateRecordEnhancer.this.adapter.templateInstanceBinaryName(), (Object[])new Object[]{String.class, Object.class});
            }
            int slot = 1;
            for (int i = 0; i < TemplateRecordEnhancer.this.parameters.size(); ++i) {
                Type paramType = TemplateRecordEnhancer.this.parameters.get(i).type();
                this.visitLdcInsn(TemplateRecordEnhancer.this.parameters.get(i).name());
                this.visitVarInsn(AsmUtil.getLoadOpcode((Type)paramType), slot);
                AsmUtil.boxIfRequired((MethodVisitor)this, (Type)paramType);
                TemplateRecordEnhancer.invokeInterface(this, templateInstanceData);
                slot += AsmUtil.getParameterSize((Type)paramType);
            }
            FieldDescriptor quteTemplateInstanceDescriptor = FieldDescriptor.of((String)TemplateRecordEnhancer.this.recordClassName, (String)"qute$templateInstance", (String)TemplateRecordEnhancer.this.interfaceToImplement.name().toString());
            this.visitFieldInsn(181, quteTemplateInstanceDescriptor.getDeclaringClass(), quteTemplateInstanceDescriptor.getName(), quteTemplateInstanceDescriptor.getType());
            super.visitInsn(177);
            super.visitEnd();
            this.visitMaxs(-1, -1);
        }
    }
}

