/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.otlp.internal.OtlpLogRecordExporterProvider;
import io.opentelemetry.exporter.otlp.internal.OtlpMetricExporterProvider;
import io.opentelemetry.exporter.otlp.internal.OtlpSpanExporterProvider;
import io.opentelemetry.instrumentation.annotations.AddingSpanAttributes;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.OpenTelemetrySdkBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RemovedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.opentelemetry.OpenTelemetryDestroyer;
import io.quarkus.opentelemetry.deployment.OpenTelemetryEnabled;
import io.quarkus.opentelemetry.deployment.metric.MetricsEnabled;
import io.quarkus.opentelemetry.runtime.AutoConfiguredOpenTelemetrySdkBuilderCustomizer;
import io.quarkus.opentelemetry.runtime.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.OpenTelemetryRecorder;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.tracing.cdi.AddingSpanAttributesInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.cdi.WithSpanInterceptor;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.InstrumentationRecorder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={OpenTelemetryEnabled.class})
public class OpenTelemetryProcessor {
    private static final DotName WITH_SPAN = DotName.createSimple((String)WithSpan.class.getName());
    private static final DotName ADD_SPAN_ATTRIBUTES = DotName.createSimple((String)AddingSpanAttributes.class.getName());
    private static final Predicate<AnnotationInstance> isAddSpanAttribute = new Predicate<AnnotationInstance>(){

        @Override
        public boolean test(AnnotationInstance annotationInstance) {
            return annotationInstance.name().equals((Object)ADD_SPAN_ATTRIBUTES);
        }
    };
    private static final DotName WITH_SPAN_INTERCEPTOR = DotName.createSimple((String)WithSpanInterceptor.class.getName());
    private static final DotName ADD_SPAN_ATTRIBUTES_INTERCEPTOR = DotName.createSimple((String)AddingSpanAttributesInterceptor.class.getName());

    @BuildStep(onlyIfNot={MetricsEnabled.class})
    void registerForReflection(BuildProducer<ReflectiveMethodBuildItem> reflectiveItem) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)"io.opentelemetry.exporter.logging.LoggingMetricExporter")) {
            reflectiveItem.produce((BuildItem)new ReflectiveMethodBuildItem("Used by OpenTelemetry Export Logging", false, "io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil", "addMeterConfiguratorCondition", new String[0]));
        }
    }

    @BuildStep
    AdditionalBeanBuildItem ensureProducerIsRetained() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{AutoConfiguredOpenTelemetrySdkBuilderCustomizer.SimpleLogRecordProcessorCustomizer.class, AutoConfiguredOpenTelemetrySdkBuilderCustomizer.ResourceCustomizer.class, AutoConfiguredOpenTelemetrySdkBuilderCustomizer.SamplerCustomizer.class, AutoConfiguredOpenTelemetrySdkBuilderCustomizer.TracerProviderCustomizer.class, AutoConfiguredOpenTelemetrySdkBuilderCustomizer.MetricProviderCustomizer.class, AutoConfiguredOpenTelemetrySdkBuilderCustomizer.TextMapPropagatorCustomizers.class}).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem setupDelayedAttribute(OpenTelemetryRecorder recorder, ApplicationInfoBuildItem appInfo) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DelayedAttributes.class).types(new Class[]{Attributes.class})).supplier(recorder.delayedAttributes(Version.getVersion(), appInfo.getName(), appInfo.getVersion())).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void openTelemetryBean(OpenTelemetryRecorder recorder, OTelBuildConfig oTelBuildConfig, BuildProducer<SyntheticBeanBuildItem> syntheticProducer, BuildProducer<OpenTelemetrySdkBuildItem> openTelemetrySdkBuildItemBuildProducer) {
        syntheticProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OpenTelemetry.class).defaultBean()).setRuntimeInit().unremovable()).scope(Singleton.class)).addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)AutoConfiguredOpenTelemetrySdkBuilderCustomizer.class.getName()))}, null), new AnnotationInstance[0])).createWith(recorder.opentelemetryBean()).destroyer(OpenTelemetryDestroyer.class)).done());
        boolean tracingEnabled = oTelBuildConfig.traces().enabled().map(it -> it != false && oTelBuildConfig.enabled()).orElseGet(() -> ((OTelBuildConfig)oTelBuildConfig).enabled());
        boolean metricsEnabled = oTelBuildConfig.metrics().enabled().map(it -> it != false && oTelBuildConfig.enabled()).orElseGet(() -> ((OTelBuildConfig)oTelBuildConfig).enabled());
        boolean loggingEnabled = oTelBuildConfig.logs().enabled().map(it -> it != false && oTelBuildConfig.enabled()).orElseGet(() -> ((OTelBuildConfig)oTelBuildConfig).enabled());
        openTelemetrySdkBuildItemBuildProducer.produce((BuildItem)new OpenTelemetrySdkBuildItem(tracingEnabled, metricsEnabled, loggingEnabled, recorder.isOtelSdkEnabled()));
    }

    @BuildStep
    void handleServices(OTelBuildConfig config, BuildProducer<ServiceProviderBuildItem> services, BuildProducer<RemovedResourceBuildItem> removedResources, BuildProducer<RuntimeInitializedClassBuildItem> runtimeReinitialized) throws IOException {
        List logRecordExporterProviders;
        List metricExporterProviders;
        List spanExporterProviders = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ConfigurableSpanExporterProvider.class.getName())).stream().filter(p -> !OtlpSpanExporterProvider.class.getName().equals(p)).collect(Collectors.toList());
        if (!spanExporterProviders.isEmpty()) {
            services.produce((BuildItem)new ServiceProviderBuildItem(ConfigurableSpanExporterProvider.class.getName(), spanExporterProviders));
        }
        if (config.traces().exporter().stream().noneMatch("otlp"::equals)) {
            removedResources.produce((BuildItem)new RemovedResourceBuildItem(ArtifactKey.fromString((String)"io.opentelemetry:opentelemetry-exporter-otlp"), Set.of("META-INF/services/io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider")));
        }
        if (!(metricExporterProviders = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ConfigurableMetricExporterProvider.class.getName())).stream().filter(p -> !OtlpMetricExporterProvider.class.getName().equals(p)).collect(Collectors.toList())).isEmpty()) {
            services.produce((BuildItem)new ServiceProviderBuildItem(ConfigurableMetricExporterProvider.class.getName(), metricExporterProviders));
        }
        if (config.metrics().exporter().stream().noneMatch("otlp"::equals)) {
            removedResources.produce((BuildItem)new RemovedResourceBuildItem(ArtifactKey.fromString((String)"io.opentelemetry:opentelemetry-exporter-otlp"), Set.of("META-INF/services/io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider")));
        }
        if (!(logRecordExporterProviders = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + ConfigurableLogRecordExporterProvider.class.getName())).stream().filter(p -> !OtlpLogRecordExporterProvider.class.getName().equals(p)).collect(Collectors.toList())).isEmpty()) {
            services.produce((BuildItem)new ServiceProviderBuildItem(ConfigurableLogRecordExporterProvider.class.getName(), logRecordExporterProviders));
        }
        if (config.logs().exporter().stream().noneMatch("otlp"::equals)) {
            removedResources.produce((BuildItem)new RemovedResourceBuildItem(ArtifactKey.fromString((String)"io.opentelemetry:opentelemetry-exporter-otlp"), Set.of("META-INF/services/io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider")));
        }
        runtimeReinitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration"));
        runtimeReinitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.opentelemetry.sdk.autoconfigure.MeterProviderConfiguration"));
        runtimeReinitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.opentelemetry.sdk.autoconfigure.LoggerProviderConfiguration"));
        runtimeReinitialized.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.quarkus.opentelemetry.runtime.logs.OpenTelemetryLogHandler"));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ConfigurableSamplerProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)AutoConfigurationCustomizerProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ResourceProvider.class.getName()));
        services.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ConfigurablePropagatorProvider.class.getName()));
    }

    @BuildStep
    void registerOpenTelemetryContextStorage(BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/io.opentelemetry.context.ContextStorageProvider"}));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{QuarkusContextStorage.class}).reason(this.getClass().getName()).methods().fields().build());
    }

    @BuildStep
    void registerWithSpan(BuildProducer<InterceptorBindingRegistrarBuildItem> interceptorBindingRegistrar, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        interceptorBindingRegistrar.produce((BuildItem)new InterceptorBindingRegistrarBuildItem(new InterceptorBindingRegistrar(){

            public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                return List.of(InterceptorBindingRegistrar.InterceptorBinding.of(WithSpan.class, Set.of("value", "kind")), InterceptorBindingRegistrar.InterceptorBinding.of(AddingSpanAttributes.class, Set.of("value")));
            }
        }));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WithSpanInterceptor.class, AddingSpanAttributesInterceptor.class}));
    }

    @BuildStep
    void transformWithSpan(BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(transformationContext -> {
            MethodInfo methodInfo;
            AnnotationTarget target = transformationContext.getTarget();
            Transformation transform = transformationContext.transform();
            if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                if (target.asClass().name().equals((Object)WITH_SPAN_INTERCEPTOR)) {
                    transform.add(WITH_SPAN, new AnnotationValue[0]);
                } else if (target.asClass().name().equals((Object)ADD_SPAN_ATTRIBUTES_INTERCEPTOR)) {
                    transform.add(ADD_SPAN_ATTRIBUTES, new AnnotationValue[0]);
                }
            } else if (target.kind() == AnnotationTarget.Kind.METHOD && (methodInfo = target.asMethod()).hasAnnotation(WITH_SPAN) && methodInfo.hasAnnotation(ADD_SPAN_ATTRIBUTES)) {
                transform.remove(isAddSpanAttribute);
            }
            transform.done();
        }));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createOpenTelemetry(OpenTelemetryRecorder recorder, CoreVertxBuildItem vertx, LaunchModeBuildItem launchMode) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT || launchMode.getLaunchMode() == LaunchMode.TEST) {
            recorder.resetGlobalOpenTelemetryForDevMode();
        }
        recorder.eagerlyCreateContextStorage();
        recorder.storeVertxOnContextStorage(vertx.getVertx());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupVertx(InstrumentationRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, Capabilities capabilities) {
        boolean sqlClientAvailable = capabilities.isPresent("io.quarkus.reactive-db2-client") || capabilities.isPresent("io.quarkus.reactive-mssql-client") || capabilities.isPresent("io.quarkus.reactive-mysql-client") || capabilities.isPresent("io.quarkus.reactive-oracle-client") || capabilities.isPresent("io.quarkus.reactive-pg-client");
        boolean redisClientAvailable = capabilities.isPresent("io.quarkus.redis");
        recorder.setupVertxTracer(beanContainerBuildItem.getValue(), sqlClientAvailable, redisClientAvailable);
    }

    @BuildStep
    void validateDataSourcesWithEnabledTelemetry(List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (JdbcDataSourceBuildItem dataSource : jdbcDataSources) {
            String dataSourceName = dataSource.getName();
            if (!OpenTelemetryProcessor.dataSourceUsesOTelJdbcDriver(dataSourceName)) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException(String.format("Data source '%s' is using unsupported JDBC driver '%s', please activate JDBC instrumentation by setting the 'quarkus.datasource.jdbc.telemetry' configuration property to 'true' instead", dataSourceName, "io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver"))}));
        }
    }

    private static boolean dataSourceUsesOTelJdbcDriver(String dataSourceName) {
        List driverPropertyKeys = DataSourceUtil.dataSourcePropertyKeys((String)dataSourceName, (String)"jdbc.driver");
        for (String driverPropertyKey : driverPropertyKeys) {
            ConfigValue explicitlyConfiguredDriverValue = ConfigProvider.getConfig().getConfigValue(driverPropertyKey);
            if (explicitlyConfiguredDriverValue.getValue() == null) continue;
            return explicitlyConfiguredDriverValue.getValue().equals("io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver");
        }
        return false;
    }
}

