/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.metric;

import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.metrics.cdi.MetricsProducer;
import java.util.HashSet;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

@BuildSteps(onlyIf={MetricEnabled.class})
public class MetricProcessor {
    private static final DotName METRIC_EXPORTER = DotName.createSimple((String)MetricExporter.class.getName());
    private static final DotName METRIC_READER = DotName.createSimple((String)MetricReader.class.getName());
    private static final DotName METRIC_PROCESSOR = DotName.createSimple((String)MetricProcessor.class.getName());

    @BuildStep
    UnremovableBeanBuildItem ensureProducersAreRetained(CombinedIndexBuildItem indexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(MetricsProducer.class).build());
        IndexView index = indexBuildItem.getIndex();
        HashSet<String> knownClasses = new HashSet<String>();
        knownClasses.add(METRIC_EXPORTER.toString());
        index.getAllKnownImplementors(METRIC_EXPORTER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(METRIC_READER.toString());
        index.getAllKnownImplementors(METRIC_READER).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        knownClasses.add(METRIC_PROCESSOR.toString());
        index.getAllKnownImplementors(METRIC_PROCESSOR).forEach(classInfo -> knownClasses.add(classInfo.name().toString()));
        HashSet<String> retainProducers = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    String returnType = method.returnType().name().toString();
                    if (!knownClasses.contains(returnType)) break;
                    retainProducers.add(method.declaringClass().name().toString());
                    break;
                }
                case FIELD: {
                    FieldInfo field = target.asField();
                    String fieldType = field.type().name().toString();
                    if (!knownClasses.contains(fieldType)) break;
                    retainProducers.add(field.declaringClass().name().toString());
                    break;
                }
            }
        }
        return new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(retainProducers));
    }

    public static class MetricEnabled
    implements BooleanSupplier {
        OTelBuildConfig otelBuildConfig;

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.metrics().enabled().map(new Function<Boolean, Boolean>(){

                @Override
                public Boolean apply(Boolean enabled) {
                    return otelBuildConfig.enabled() && enabled != false;
                }
            }).orElseGet(() -> this.otelBuildConfig.enabled());
        }
    }
}

