/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.oidc.SecurityEvent;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.DefaultTokenIntrospectionUserInfoCache;
import io.quarkus.oidc.runtime.DefaultTokenStateManager;
import io.quarkus.oidc.runtime.OidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.OidcConfigurationMetadataProducer;
import io.quarkus.oidc.runtime.OidcIdentityProvider;
import io.quarkus.oidc.runtime.OidcJsonWebTokenProducer;
import io.quarkus.oidc.runtime.OidcRecorder;
import io.quarkus.oidc.runtime.OidcSessionImpl;
import io.quarkus.oidc.runtime.OidcTokenCredentialProducer;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import javax.inject.Singleton;
import org.eclipse.microprofile.jwt.Claim;
import org.jboss.jandex.DotName;

public class OidcBuildStep {
    public static final DotName DOTNAME_SECURITY_EVENT = DotName.createSimple((String)SecurityEvent.class.getName());

    @BuildStep(onlyIf={IsEnabled.class})
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.OIDC);
    }

    @BuildStep(onlyIf={IsEnabled.class})
    public void provideSecurityInformation(BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.OPENIDCONNECT((String)"quarkus.oidc.auth-server-url"));
    }

    @BuildStep(onlyIf={IsEnabled.class})
    AdditionalBeanBuildItem jwtClaimIntegration(Capabilities capabilities) {
        if (!capabilities.isPresent("io.quarkus.jwt")) {
            AdditionalBeanBuildItem.Builder removable = AdditionalBeanBuildItem.builder();
            removable.addBeanClass(CommonJwtProducer.class);
            removable.addBeanClass(RawClaimTypeProducer.class);
            removable.addBeanClass(JsonValueProducer.class);
            removable.addBeanClass(ClaimValueProducer.class);
            removable.addBeanClass(Claim.class);
            return removable.build();
        }
        return null;
    }

    @BuildStep(onlyIf={IsEnabled.class})
    public void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        builder.addBeanClass(OidcAuthenticationMechanism.class).addBeanClass(OidcJsonWebTokenProducer.class).addBeanClass(OidcTokenCredentialProducer.class).addBeanClass(OidcConfigurationMetadataProducer.class).addBeanClass(OidcIdentityProvider.class).addBeanClass(DefaultTenantConfigResolver.class).addBeanClass(DefaultTokenStateManager.class).addBeanClass(OidcSessionImpl.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @BuildStep(onlyIf={IsCacheEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public SyntheticBeanBuildItem addDefaultCacheBean(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DefaultTokenIntrospectionUserInfoCache.class).unremovable()).types(new Class[]{DefaultTokenIntrospectionUserInfoCache.class, TokenIntrospectionCache.class, UserInfoCache.class})).supplier(recorder.setupTokenCache(config, vertxBuildItem.getVertx())).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep(onlyIf={IsEnabled.class})
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.OIDC);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsEnabled.class})
    public SyntheticBeanBuildItem setup(OidcConfig config, OidcRecorder recorder, CoreVertxBuildItem vertxBuildItem, TlsConfig tlsConfig) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(TenantConfigBean.class).unremovable()).types(new Class[]{TenantConfigBean.class})).supplier(recorder.setup(config, vertxBuildItem.getVertx(), tlsConfig)).destroyer(TenantConfigBean.Destroyer.class)).scope(Singleton.class)).setRuntimeInit().done();
    }

    @BuildStep(onlyIf={IsEnabled.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ValidationPhaseBuildItem.ValidationErrorBuildItem findSecurityEventObservers(OidcRecorder recorder, ValidationPhaseBuildItem validationPhase) {
        Collection observers = (Collection)validationPhase.getContext().get(BuildExtension.Key.OBSERVERS);
        boolean isSecurityEventObserved = observers.stream().anyMatch(observer -> observer.asObserver().getObservedType().name().equals((Object)DOTNAME_SECURITY_EVENT));
        recorder.setSecurityEventObserved(isSecurityEventObserved);
        return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[0]);
    }

    public static class IsCacheEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled && this.config.defaultTokenCacheEnabled;
        }
    }

    public static class IsEnabled
    implements BooleanSupplier {
        OidcBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

