/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDockerWorking;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesNativeConfigResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.oidc.deployment.OidcBuildStep;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesBuildItem;
import io.quarkus.oidc.deployment.devservices.keycloak.DevServicesConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.DevServicesConfigBuildItem;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.keycloak.KeycloakDevServicesUtils;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.RolesRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.util.JsonSerialization;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class KeycloakDevServicesProcessor {
    static volatile DevServicesConfig capturedDevServicesConfiguration;
    static volatile Vertx vertxInstance;
    private static final Logger LOG;
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String APPLICATION_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";
    private static final String KEYCLOAK_URL_KEY = "keycloak.url";
    private static final int KEYCLOAK_EXPOSED_PORT = 8080;
    private static final String KEYCLOAK_DOCKER_REALM_PATH = "/tmp/realm.json";
    private static final String KEYCLOAK_USER_PROP = "KEYCLOAK_USER";
    private static final String KEYCLOAK_PASSWORD_PROP = "KEYCLOAK_PASSWORD";
    private static final String KEYCLOAK_VENDOR_PROP = "DB_VENDOR";
    private static final String KEYCLOAK_IMPORT_PROP = "KEYCLOAK_IMPORT";
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_DB_VENDOR = "H2";
    private static final String OIDC_USERS = "oidc.users";
    private static volatile List<Closeable> closeables;
    private static volatile boolean first;
    private static volatile String capturedKeycloakUrl;
    private static volatile FileTime capturedRealmFileLastModifiedDate;
    private final IsDockerWorking isDockerWorking = new IsDockerWorking(true);

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={OidcBuildStep.IsEnabled.class})
    public DevServicesConfigBuildItem startKeycloakContainer(LaunchModeBuildItem launchMode, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<DevServicesNativeConfigResultBuildItem> devServices, Optional<OidcDevServicesBuildItem> oidcProviderBuildItem, KeycloakBuildTimeConfig config) {
        if (oidcProviderBuildItem.isPresent()) {
            return null;
        }
        DevServicesConfig currentDevServicesConfiguration = config.devservices;
        if (closeables != null) {
            Object currentRealmFileLastModifiedDate;
            boolean restartRequired;
            boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
            if (!restartRequired && (currentRealmFileLastModifiedDate = this.getRealmFileLastModifiedDate(currentDevServicesConfiguration.realmPath)) != null && !((FileTime)currentRealmFileLastModifiedDate).equals(capturedRealmFileLastModifiedDate)) {
                restartRequired = true;
                capturedRealmFileLastModifiedDate = currentRealmFileLastModifiedDate;
            }
            if (!restartRequired) {
                return this.prepareConfiguration(false, runTimeConfiguration, devServices);
            }
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Failed to stop Keycloak container", e);
                }
            }
            closeables = null;
            capturedDevServicesConfiguration = null;
            capturedKeycloakUrl = null;
        }
        capturedDevServicesConfiguration = currentDevServicesConfiguration;
        StartResult startResult = this.startContainer();
        if (startResult == null) {
            return null;
        }
        closeables = Collections.singletonList(startResult.closeable);
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (closeables != null) {
                        for (Closeable closeable : closeables) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to stop Keycloak container", t);
                            }
                        }
                    }
                    if (vertxInstance != null) {
                        try {
                            vertxInstance.close();
                        }
                        catch (Throwable t) {
                            LOG.error((Object)"Failed to close Vertx instance", t);
                        }
                    }
                    first = true;
                    closeables = null;
                    capturedDevServicesConfiguration = null;
                    vertxInstance = null;
                    capturedRealmFileLastModifiedDate = null;
                }
            };
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            ((QuarkusClassLoader)cl.parent()).addCloseTask(closeTask);
            final Thread closeHookThread = new Thread(closeTask, "Keycloak container shutdown thread");
            Runtime.getRuntime().addShutdownHook(closeHookThread);
            ((QuarkusClassLoader)cl.parent()).addCloseTask(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().removeShutdownHook(closeHookThread);
                }
            });
        }
        capturedKeycloakUrl = startResult.url + "/auth";
        if (vertxInstance == null) {
            vertxInstance = Vertx.vertx();
        }
        capturedRealmFileLastModifiedDate = this.getRealmFileLastModifiedDate(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmPath);
        return this.prepareConfiguration(!startResult.realmFileExists, runTimeConfiguration, devServices);
    }

    private DevServicesConfigBuildItem prepareConfiguration(boolean createRealm, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfiguration, BuildProducer<DevServicesNativeConfigResultBuildItem> devServices) {
        String authServerUrl = capturedKeycloakUrl + "/realms/" + KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmName;
        String oidcClientId = KeycloakDevServicesProcessor.getOidcClientId();
        String oidcClientSecret = KeycloakDevServicesProcessor.getOidcClientSecret();
        String oidcApplicationType = KeycloakDevServicesProcessor.getOidcApplicationType();
        Map<String, String> users = this.getUsers(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.users);
        if (createRealm) {
            this.createRealm(capturedKeycloakUrl, users, oidcClientId, oidcClientSecret);
        }
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(KEYCLOAK_URL_KEY, capturedKeycloakUrl));
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(AUTH_SERVER_URL_CONFIG_KEY, authServerUrl));
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(APPLICATION_TYPE_CONFIG_KEY, oidcApplicationType));
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(CLIENT_ID_CONFIG_KEY, oidcClientId));
        runTimeConfiguration.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(CLIENT_SECRET_CONFIG_KEY, oidcClientSecret));
        devServices.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(KEYCLOAK_URL_KEY, capturedKeycloakUrl));
        devServices.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(AUTH_SERVER_URL_CONFIG_KEY, capturedKeycloakUrl));
        devServices.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(APPLICATION_TYPE_CONFIG_KEY, oidcApplicationType));
        devServices.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(CLIENT_ID_CONFIG_KEY, oidcClientId));
        devServices.produce((BuildItem)new DevServicesNativeConfigResultBuildItem(CLIENT_SECRET_CONFIG_KEY, oidcClientSecret));
        HashMap<String, Object> configProperties = new HashMap<String, Object>();
        configProperties.put(KEYCLOAK_URL_KEY, capturedKeycloakUrl);
        configProperties.put(AUTH_SERVER_URL_CONFIG_KEY, authServerUrl);
        configProperties.put(APPLICATION_TYPE_CONFIG_KEY, oidcApplicationType);
        configProperties.put(CLIENT_ID_CONFIG_KEY, oidcClientId);
        configProperties.put(CLIENT_SECRET_CONFIG_KEY, oidcClientSecret);
        configProperties.put(OIDC_USERS, users);
        return new DevServicesConfigBuildItem(configProperties);
    }

    private StartResult startContainer() {
        if (!KeycloakDevServicesProcessor.capturedDevServicesConfiguration.enabled) {
            LOG.debug((Object)"Not starting devservices for Keycloak as it has been disabled in the config");
            return null;
        }
        if (!KeycloakDevServicesProcessor.isOidcTenantEnabled()) {
            LOG.debug((Object)"Not starting devservices for Keycloak as 'quarkus.oidc.tenant.enabled' is false");
            return null;
        }
        if (ConfigUtils.isPropertyPresent((String)AUTH_SERVER_URL_CONFIG_KEY)) {
            LOG.debug((Object)"Not starting devservices for Keycloak as 'quarkus.oidc.auth-server-url' has been provided");
            return null;
        }
        if (!this.isDockerWorking.getAsBoolean()) {
            LOG.warn((Object)"Please configure 'quarkus.oidc.auth-server-url' or get a working docker instance");
            return null;
        }
        String imageName = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.imageName.get();
        DockerImageName dockerImageName = DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(imageName);
        final FixedPortOidcContainer oidcContainer = new FixedPortOidcContainer(dockerImageName, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.port, KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmPath);
        oidcContainer.start();
        String url = "http://" + oidcContainer.getHost() + ":" + oidcContainer.getPort();
        return new StartResult(url, oidcContainer.realmFileExists, new Closeable(){

            @Override
            public void close() {
                oidcContainer.close();
            }
        });
    }

    private FileTime getRealmFileLastModifiedDate(Optional<String> realm) {
        if (realm.isPresent()) {
            Path realmPath = Paths.get(realm.get(), new String[0]);
            try {
                return Files.getLastModifiedTime(realmPath, new LinkOption[0]);
            }
            catch (IOException ex) {
                LOG.tracef("Unable to get the last modified date of the realm file %s", (Object)realmPath);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRealm(String keycloakUrl, Map<String, String> users, String oidcClientId, String oidcClientSecret) {
        RealmRepresentation realm = this.createRealmRep();
        realm.getClients().add(this.createClient(oidcClientId, oidcClientSecret));
        for (Map.Entry<String, String> entry : users.entrySet()) {
            realm.getUsers().add(this.createUser(entry.getKey(), entry.getValue(), this.getUserRoles(entry.getKey())));
        }
        try (WebClient client = KeycloakDevServicesUtils.createWebClient();){
            String token = KeycloakDevServicesUtils.getPasswordAccessToken(client, keycloakUrl + "/realms/master/protocol/openid-connect/token", "admin-cli", null, "admin", "admin", KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
            client.postAbs(keycloakUrl + "/admin/realms").putHeader(HttpHeaders.CONTENT_TYPE.toString(), "application/json").putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).sendBuffer(Buffer.buffer().appendString(JsonSerialization.writeValueAsString((Object)realm))).await().atMost(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.webClienTimeout);
        }
    }

    private Map<String, String> getUsers(Map<String, String> configuredUsers) {
        if (configuredUsers.isEmpty()) {
            LinkedHashMap<String, String> users = new LinkedHashMap<String, String>();
            users.put("alice", "alice");
            users.put("bob", "bob");
            return users;
        }
        return configuredUsers;
    }

    private String[] getUserRoles(String user) {
        String[] stringArray;
        String roles = KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.get(user);
        if (roles == null) {
            if ("alice".equals(user)) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "admin";
                stringArray = stringArray2;
                stringArray2[1] = "user";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "user";
            }
        } else {
            stringArray = roles.split(",");
        }
        return stringArray;
    }

    private RealmRepresentation createRealmRep() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(KeycloakDevServicesProcessor.capturedDevServicesConfiguration.realmName);
        realm.setEnabled(Boolean.valueOf(true));
        realm.setUsers(new ArrayList());
        realm.setClients(new ArrayList());
        RolesRepresentation roles = new RolesRepresentation();
        ArrayList realmRoles = new ArrayList();
        roles.setRealm(realmRoles);
        realm.setRoles(roles);
        if (KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.isEmpty()) {
            realm.getRoles().getRealm().add(new RoleRepresentation("user", null, false));
            realm.getRoles().getRealm().add(new RoleRepresentation("admin", null, false));
        } else {
            for (String role : KeycloakDevServicesProcessor.capturedDevServicesConfiguration.roles.values()) {
                realm.getRoles().getRealm().add(new RoleRepresentation(role, null, false));
            }
        }
        return realm;
    }

    private ClientRepresentation createClient(String clientId, String oidcClientSecret) {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientId);
        client.setRedirectUris(Arrays.asList("*"));
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret(oidcClientSecret);
        client.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setImplicitFlowEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Arrays.asList("*"));
        client.setDefaultClientScopes(Arrays.asList("microprofile-jwt"));
        return client;
    }

    private UserRepresentation createUser(String username, String password, String ... realmRoles) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEnabled(Boolean.valueOf(true));
        user.setCredentials(new ArrayList());
        user.setRealmRoles(Arrays.asList(realmRoles));
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        credential.setTemporary(Boolean.valueOf(false));
        user.getCredentials().add(credential);
        return user;
    }

    private static boolean isOidcTenantEnabled() {
        return ConfigProvider.getConfig().getOptionalValue(TENANT_ENABLED_CONFIG_KEY, Boolean.class).orElse(true);
    }

    private static String getOidcApplicationType() {
        return ConfigProvider.getConfig().getOptionalValue(APPLICATION_TYPE_CONFIG_KEY, String.class).orElse("service");
    }

    private static String getOidcClientId() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_ID_CONFIG_KEY, String.class).orElse("quarkus-app");
    }

    private static String getOidcClientSecret() {
        return ConfigProvider.getConfig().getOptionalValue(CLIENT_SECRET_CONFIG_KEY, String.class).orElse("secret");
    }

    static {
        LOG = Logger.getLogger(KeycloakDevServicesProcessor.class);
        first = true;
    }

    private static class FixedPortOidcContainer
    extends GenericContainer {
        OptionalInt fixedExposedPort;
        Optional<String> realm;
        boolean realmFileExists;

        public FixedPortOidcContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, Optional<String> realm) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.realm = realm;
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8080);
            } else {
                this.addExposedPort(8080);
            }
            this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_USER_PROP, "admin");
            this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_PASSWORD_PROP, "admin");
            this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_VENDOR_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DB_VENDOR);
            if (this.realm.isPresent()) {
                if (Thread.currentThread().getContextClassLoader().getResource(this.realm.get()) != null) {
                    this.realmFileExists = true;
                    this.withClasspathResourceMapping(this.realm.get(), KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH, BindMode.READ_ONLY);
                    this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_IMPORT_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH);
                } else {
                    Path filePath = Paths.get(this.realm.get(), new String[0]);
                    if (Files.exists(filePath, new LinkOption[0])) {
                        this.realmFileExists = true;
                        this.withFileSystemBind(this.realm.get(), KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH, BindMode.READ_ONLY);
                        this.addEnv(KeycloakDevServicesProcessor.KEYCLOAK_IMPORT_PROP, KeycloakDevServicesProcessor.KEYCLOAK_DOCKER_REALM_PATH);
                    } else {
                        LOG.debugf("Realm %s resource is not available", (Object)this.realm.get());
                    }
                }
            }
            super.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/auth").forPort(8080));
        }

        public int getPort() {
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return this.getFirstMappedPort();
        }
    }

    private static class StartResult {
        private final String url;
        private final boolean realmFileExists;
        private final Closeable closeable;

        public StartResult(String url, boolean realmFileExists, Closeable closeable) {
            this.url = url;
            this.realmFileExists = realmFileExists;
            this.closeable = closeable;
        }
    }
}

