/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.json.Json;
import io.quarkus.bootstrap.json.JsonArray;
import io.quarkus.bootstrap.json.JsonMember;
import io.quarkus.bootstrap.json.JsonMultiValue;
import io.quarkus.bootstrap.json.JsonObject;
import io.quarkus.bootstrap.json.JsonReader;
import io.quarkus.bootstrap.json.JsonString;
import io.quarkus.bootstrap.json.JsonTransform;
import io.quarkus.bootstrap.json.JsonValue;
import io.quarkus.maven.QuarkusBootstrapMojo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="native-image-agent", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class NativeImageAgentMojo
extends QuarkusBootstrapMojo {
    private final Pattern resourceSkipPattern = NativeImageAgentMojo.discardPattern("application.properties", "jakarta", "jboss", "logging.properties", "microprofile", "quarkus", "slf4j", "smallrye", "vertx");

    @Override
    protected boolean beforeExecute() throws MojoExecutionException, MojoFailureException {
        return !QuarkusBootstrapMojo.isNativeProfileEnabled(this.mavenProject());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        String dirName = "native-image-agent-base-config";
        Path basePath = this.buildDir().toPath().resolve(Path.of("native-image-agent-base-config", new String[0]));
        this.getLog().debug((CharSequence)("Checking if native image agent config folder exits at " + String.valueOf(basePath)));
        if (basePath.toFile().exists()) {
            try {
                Path targetPath = this.buildDir().toPath().resolve(Path.of("native-image-agent-final-config", new String[0]));
                if (!targetPath.toFile().exists()) {
                    targetPath.toFile().mkdirs();
                }
                this.getLog().debug((CharSequence)("Native image agent config folder exits, copy and transform to " + String.valueOf(targetPath)));
                Path reflectConfigJsonPath = basePath.resolve("reflect-config.json");
                Path reachabilityMetadataJsonPath = basePath.resolve("reachability-metadata.json");
                if (Files.exists(reachabilityMetadataJsonPath, new LinkOption[0])) {
                    this.transformReachabilityMetadataJson(basePath, "reachability-metadata.json", targetPath);
                    if (!this.getLog().isInfoEnabled()) return;
                    this.getLog().info((CharSequence)("Discovered native image agent generated files in " + String.valueOf(targetPath)));
                    return;
                }
                if (Files.exists(reflectConfigJsonPath, new LinkOption[0])) {
                    Files.copy(reflectConfigJsonPath, targetPath.resolve("reflect-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(basePath.resolve("serialization-config.json"), targetPath.resolve("serialization-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(basePath.resolve("jni-config.json"), targetPath.resolve("jni-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(basePath.resolve("proxy-config.json"), targetPath.resolve("proxy-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    this.transformJsonObject(basePath, "resource-config.json", targetPath, JsonTransform.dropping(v -> this.discardResource("pattern", (JsonValue)v)));
                    if (!this.getLog().isInfoEnabled()) return;
                    this.getLog().info((CharSequence)("Discovered native image agent generated files in " + String.valueOf(targetPath)));
                    return;
                }
                Path reflectOriginsTxtPath = basePath.resolve("reflect-origins.txt");
                if (!reflectOriginsTxtPath.toFile().exists()) return;
                this.getLog().info((CharSequence)("Native image agent configuration origin files exist, inspect them manually inside " + String.valueOf(basePath)));
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to transform native image agent configuration", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)"Missing native-image-agent-base-config directory with native image agent configuration to transform");
        }
    }

    private void transformReachabilityMetadataJson(Path base, String name, Path target) throws IOException {
        this.getLog().debug((CharSequence)("Discarding resources from native image configuration that match the following regular expression: " + String.valueOf(this.resourceSkipPattern)));
        String original = Files.readString(base.resolve(name));
        JsonObject jsonRead = (JsonObject)JsonReader.of((String)original).read();
        JsonArray resources = (JsonArray)jsonRead.get("resources");
        if (resources != null) {
            Json.JsonObjectBuilder jsonBuilder = Json.object();
            jsonBuilder.transform((JsonMultiValue)jsonRead, JsonTransform.dropping(v -> this.discardResource("glob", (JsonValue)v)));
            try (BufferedWriter writer = Files.newBufferedWriter(target.resolve(name), new OpenOption[0]);){
                jsonBuilder.appendTo((Appendable)writer);
            }
        } else {
            Files.copy(base.resolve(name), target.resolve(name), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void transformJsonObject(Path base, String name, Path target, JsonTransform transform) throws IOException {
        this.getLog().debug((CharSequence)("Discarding resources from native image configuration that match the following regular expression: " + String.valueOf(this.resourceSkipPattern)));
        String original = Files.readString(base.resolve(name));
        JsonObject jsonRead = (JsonObject)JsonReader.of((String)original).read();
        Json.JsonObjectBuilder jsonBuilder = Json.object();
        jsonBuilder.transform((JsonMultiValue)jsonRead, transform);
        try (BufferedWriter writer = Files.newBufferedWriter(target.resolve(name), new OpenOption[0]);){
            jsonBuilder.appendTo((Appendable)writer);
        }
    }

    private boolean discardResource(String attribute, JsonValue value) {
        JsonMember member;
        if (value instanceof JsonMember && attribute.equals((member = (JsonMember)value).attribute().value())) {
            JsonString memberValue = (JsonString)member.value();
            boolean discarded = this.resourceSkipPattern.matcher(memberValue.value()).find();
            if (discarded) {
                this.getLog().debug((CharSequence)("Discarded included resource with pattern: " + memberValue.value()));
            }
            return discarded;
        }
        return false;
    }

    private static Pattern discardPattern(String ... ignoredElements) {
        String pattern = Arrays.stream(ignoredElements).collect(Collectors.joining("|", ".*(", ").*"));
        return Pattern.compile(pattern);
    }
}

