/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.commands.UpdateProject;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.update.rewrite.QuarkusUpdateExitErrorException;
import io.quarkus.maven.QuarkusProjectStateMojoBase;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.PlatformStreamCoords;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update", requiresProject=true)
public class UpdateMojo
extends QuarkusProjectStateMojoBase {
    @Parameter(property="perModule")
    boolean perModule;
    @Parameter(property="platformVersion", required=false)
    private String platformVersion;
    @Parameter(property="rewritePluginVersion", required=false)
    private String rewritePluginVersion;
    @Parameter(property="noRewrite", required=false, defaultValue="false")
    private Boolean noRewrite;
    @Parameter(property="rewriteDryRun", required=false, defaultValue="false")
    private Boolean rewriteDryRun;
    @Parameter(property="quarkusUpdateRecipes", required=false)
    private String rewriteQuarkusUpdateRecipes;
    @Parameter(property="additionalUpdateRecipes", required=false)
    private String rewriteAdditionalUpdateRecipes;
    @Parameter(property="stream", required=false)
    private String stream;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;

    @Override
    protected void validateParameters() throws MojoExecutionException {
        this.getLog().warn((CharSequence)"quarkus:update goal is experimental, its options and output might change in future versions");
        super.validateParameters();
    }

    @Override
    protected void processProjectState(QuarkusProject quarkusProject) throws MojoExecutionException {
        ExtensionCatalog targetCatalog;
        QuarkusProjectHelper.setArtifactResolver((MavenArtifactResolver)this.artifactResolver());
        try {
            if (this.platformVersion != null) {
                ArtifactCoords targetPrimaryBom = UpdateMojo.getPrimaryBom(quarkusProject.getExtensionsCatalog());
                targetPrimaryBom = ArtifactCoords.pom((String)targetPrimaryBom.getGroupId(), (String)targetPrimaryBom.getArtifactId(), (String)this.platformVersion);
                targetCatalog = this.getExtensionCatalogResolver().resolveExtensionCatalog(List.of(targetPrimaryBom));
            } else if (this.stream != null) {
                PlatformStreamCoords platformStream = PlatformStreamCoords.fromString((String)this.stream);
                targetCatalog = this.getExtensionCatalogResolver().resolveExtensionCatalog(platformStream);
                this.platformVersion = UpdateMojo.getPrimaryBom(targetCatalog).getVersion();
            } else {
                targetCatalog = this.getExtensionCatalogResolver().resolveExtensionCatalog();
                this.platformVersion = UpdateMojo.getPrimaryBom(targetCatalog).getVersion();
            }
        }
        catch (RegistryResolutionException e) {
            throw new MojoExecutionException("Failed to resolve the recommended Quarkus extension catalog from the configured extension registries", (Exception)((Object)e));
        }
        UpdateProject invoker = new UpdateProject(quarkusProject);
        invoker.targetCatalog(targetCatalog);
        invoker.targetPlatformVersion(this.platformVersion);
        invoker.perModule(this.perModule);
        invoker.appModel(this.resolveApplicationModel());
        if (this.rewritePluginVersion != null) {
            invoker.rewritePluginVersion(this.rewritePluginVersion);
        }
        if (this.rewriteQuarkusUpdateRecipes != null) {
            invoker.rewriteQuarkusUpdateRecipes(this.rewriteQuarkusUpdateRecipes);
        }
        if (this.rewriteAdditionalUpdateRecipes != null) {
            invoker.rewriteAdditionalUpdateRecipes(this.rewriteAdditionalUpdateRecipes);
        }
        invoker.rewriteDryRun(this.rewriteDryRun.booleanValue());
        invoker.noRewrite(this.noRewrite.booleanValue());
        try {
            QuarkusCommandOutcome result = invoker.execute();
            if (!result.isSuccess()) {
                throw new MojoExecutionException("Failed to apply the updates: " + result.getMessage());
            }
        }
        catch (QuarkusUpdateExitErrorException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (QuarkusCommandException e) {
            throw new MojoExecutionException("Failed to apply the updates", (Exception)((Object)e));
        }
    }

    private static ArtifactCoords getPrimaryBom(ExtensionCatalog c) {
        return c.getDerivedFrom().isEmpty() ? c.getBom() : ((ExtensionOrigin)c.getDerivedFrom().get(0)).getBom();
    }
}

