/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class JpaModelBuildItem
extends SimpleBuildItem {
    private final Set<String> allModelPackageNames = new TreeSet<String>();
    private final Set<String> entityClassNames = new TreeSet<String>();
    private final Set<String> allModelClassNames = new TreeSet<String>();
    private final Map<String, List<RecordableXmlMapping>> xmlMappingsByPU = new HashMap<String, List<RecordableXmlMapping>>();

    public JpaModelBuildItem(Set<String> allModelPackageNames, Set<String> entityClassNames, Set<String> allModelClassNames, Map<String, List<RecordableXmlMapping>> xmlMappingsByPU) {
        this.allModelPackageNames.addAll(allModelPackageNames);
        this.entityClassNames.addAll(entityClassNames);
        this.allModelClassNames.addAll(allModelClassNames);
        this.xmlMappingsByPU.putAll(xmlMappingsByPU);
    }

    public Set<String> getAllModelPackageNames() {
        return this.allModelPackageNames;
    }

    public Set<String> getEntityClassNames() {
        return this.entityClassNames;
    }

    public Set<String> getAllModelClassNames() {
        return this.allModelClassNames;
    }

    public List<RecordableXmlMapping> getXmlMappings(String puName) {
        return this.xmlMappingsByPU.getOrDefault(puName, Collections.emptyList());
    }
}

