/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.EnumAcceptedValues;
import java.time.Duration;
import java.util.List;

public final class ConfigProperty
extends AbstractConfigItem {
    private final ConfigPhase phase;
    private final List<String> additionalPaths;
    private final String environmentVariable;
    private final String typeDescription;
    private final boolean map;
    private final boolean list;
    private final boolean optional;
    private final String mapKey;
    private final boolean unnamedMapKey;
    private final boolean withinMap;
    private final boolean converted;
    private final boolean isEnum;
    private final EnumAcceptedValues enumAcceptedValues;
    private final String defaultValue;
    private final String javadocSiteLink;

    public ConfigProperty(ConfigPhase phase, String sourceClass, String sourceName, String path, List<String> additionalPaths, String environmentVariable, String type, String typeDescription, boolean map, boolean list, boolean optional, String mapKey, boolean unnamedMapKey, boolean withinMap, boolean converted, @JsonProperty(value="enum") boolean isEnum, EnumAcceptedValues enumAcceptedValues, String defaultValue, String javadocSiteLink, boolean deprecated) {
        super(sourceClass, sourceName, path, type, deprecated);
        this.phase = phase;
        this.additionalPaths = additionalPaths;
        this.environmentVariable = environmentVariable;
        this.typeDescription = typeDescription;
        this.map = map;
        this.list = list;
        this.optional = optional;
        this.mapKey = mapKey;
        this.unnamedMapKey = unnamedMapKey;
        this.withinMap = withinMap;
        this.converted = converted;
        this.isEnum = isEnum;
        this.enumAcceptedValues = enumAcceptedValues;
        this.defaultValue = defaultValue;
        this.javadocSiteLink = javadocSiteLink;
    }

    public ConfigPhase getPhase() {
        return this.phase;
    }

    public List<String> getAdditionalPaths() {
        return this.additionalPaths;
    }

    public String getEnvironmentVariable() {
        return this.environmentVariable;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public boolean isMap() {
        return this.map;
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public boolean isUnnamedMapKey() {
        return this.unnamedMapKey;
    }

    public boolean isWithinMap() {
        return this.withinMap;
    }

    public boolean isConverted() {
        return this.converted;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public EnumAcceptedValues getEnumAcceptedValues() {
        return this.enumAcceptedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getJavadocSiteLink() {
        return this.javadocSiteLink;
    }

    @Override
    public boolean isSection() {
        return false;
    }

    @Override
    public int compareTo(AbstractConfigItem o) {
        if (o instanceof ConfigSection) {
            return -1;
        }
        ConfigProperty other = (ConfigProperty)o;
        if (this.isWithinMap()) {
            if (other.isWithinMap()) {
                return ConfigPhase.COMPARATOR.compare(this.phase, other.getPhase());
            }
            return 1;
        }
        if (other.isWithinMap()) {
            return -1;
        }
        return ConfigPhase.COMPARATOR.compare(this.phase, other.getPhase());
    }

    @Override
    public boolean hasDurationType() {
        return Duration.class.getName().equals(this.type);
    }

    @Override
    public boolean hasMemorySizeType() {
        return "io.quarkus.runtime.configuration.MemorySize".equals(this.type);
    }
}

