/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformReleaseVersion;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.json.JsonEntityWithAnySupport;
import io.quarkus.registry.catalog.json.JsonPlatformRelease;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class JsonPlatformStream
extends JsonEntityWithAnySupport
implements PlatformStream {
    private String id;
    private String name;
    private Map<PlatformReleaseVersion, PlatformRelease> releases;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonDeserialize(contentAs=JsonPlatformRelease.class)
    public Collection<PlatformRelease> getReleases() {
        return this.releases == null ? Collections.emptyList() : this.releases.values();
    }

    @Override
    @JsonIgnore
    public PlatformRelease getRelease(PlatformReleaseVersion version) {
        return this.releases == null ? null : this.releases.get(version);
    }

    public void setReleases(List<PlatformRelease> releases) {
        for (PlatformRelease r : releases) {
            this.addRelease(r);
        }
    }

    public void addRelease(PlatformRelease platformRelease) {
        if (this.releases == null) {
            this.releases = new LinkedHashMap<PlatformReleaseVersion, PlatformRelease>();
        }
        this.releases.put(platformRelease.getVersion(), platformRelease);
    }

    public String toString() {
        return this.id + this.releases;
    }
}

