/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.json.JsonEntityWithAnySupport;
import io.quarkus.registry.catalog.json.JsonPlatform;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class JsonPlatformCatalog
extends JsonEntityWithAnySupport
implements PlatformCatalog {
    private Map<String, Platform> platforms;

    @Override
    @JsonDeserialize(contentAs=JsonPlatform.class)
    public Collection<Platform> getPlatforms() {
        return this.platforms == null ? Collections.emptyList() : this.platforms.values();
    }

    @Override
    @JsonIgnore
    public Platform getPlatform(String platformId) {
        return this.platforms == null ? null : this.platforms.get(platformId);
    }

    public void setPlatforms(List<Platform> platforms) {
        for (Platform p : platforms) {
            this.addPlatform(p);
        }
    }

    public void addPlatform(Platform platform) {
        if (this.platforms == null) {
            this.platforms = new LinkedHashMap<String, Platform>();
        }
        this.platforms.put(platform.getPlatformKey(), platform);
    }
}

