/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCommandHandler;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ToolsUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public class CreateProject {
    public static final String NAME = "create-project";
    public static final String CODESTARTS_ENABLED = ToolsUtils.dotJoin("quarkus", "create-project", "codestarts-enabled");
    public static final String NO_DOCKERFILES = ToolsUtils.dotJoin("quarkus", "create-project", "no-dockerfiles");
    public static final String NO_BUILDTOOL_WRAPPER = ToolsUtils.dotJoin("quarkus", "create-project", "no-buildtool-wrapper");
    public static final String NO_EXAMPLES = ToolsUtils.dotJoin("quarkus", "create-project", "no-examples");
    public static final String CODESTARTS = ToolsUtils.dotJoin("quarkus", "create-project", "codestarts");
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(?:1\\.)?(\\d+)(?:\\..*)?");
    private final Path projectDirPath;
    private final QuarkusPlatformDescriptor platformDescr;
    private String javaTarget;
    private BuildTool buildTool = BuildTool.MAVEN;
    private Map<String, Object> values = new HashMap<String, Object>();

    public CreateProject(Path projectDirPath, QuarkusPlatformDescriptor platformDescr) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectDirPath is required");
        this.platformDescr = Objects.requireNonNull(platformDescr, "platformDescr is required");
    }

    public CreateProject groupId(String groupId) {
        this.setValue("project_groupId", groupId);
        return this;
    }

    public CreateProject artifactId(String artifactId) {
        this.setValue("project_artifactId", artifactId);
        return this;
    }

    public CreateProject version(String version) {
        this.setValue("project_version", version);
        return this;
    }

    public CreateProject quarkusMavenPluginVersion(String version) {
        this.setValue("maven_plugin_version", version);
        return this;
    }

    public CreateProject quarkusGradlePluginVersion(String version) {
        this.setValue("gradle_plugin_version", version);
        return this;
    }

    public CreateProject sourceType(SourceType sourceType) {
        this.setValue("source_type", (Object)sourceType);
        return this;
    }

    public CreateProject javaTarget(String javaTarget) {
        this.javaTarget = javaTarget;
        return this;
    }

    public CreateProject className(String className) {
        if (className == null) {
            return this;
        }
        if (!SourceVersion.isName(className) || SourceVersion.isKeyword(className)) {
            throw new IllegalArgumentException(className + " is not a valid class name");
        }
        this.setValue("class_name", className);
        return this;
    }

    public CreateProject extensions(Set<String> extensions) {
        if (CreateProject.isSpringStyle(extensions)) {
            this.setValue("is_spring", true);
        }
        this.setValue("extensions", extensions);
        return this;
    }

    public CreateProject codestarts(Set<String> codestarts) {
        this.setValue(CODESTARTS, codestarts);
        return this;
    }

    public CreateProject codestartsEnabled(boolean value) {
        this.setValue(CODESTARTS_ENABLED, value);
        return this;
    }

    public CreateProject codestartsEnabled() {
        return this.codestartsEnabled(true);
    }

    public CreateProject noExamples(boolean value) {
        this.setValue(NO_EXAMPLES, value);
        return this;
    }

    public CreateProject noExamples() {
        return this.noExamples(true);
    }

    public CreateProject noBuildToolWrapper(boolean value) {
        this.setValue(NO_BUILDTOOL_WRAPPER, value);
        return this;
    }

    public CreateProject noBuildToolWrapper() {
        return this.noBuildToolWrapper(true);
    }

    public CreateProject noDockerfiles(boolean value) {
        this.setValue(NO_DOCKERFILES, value);
        return this;
    }

    public CreateProject noDockerfiles() {
        return this.noDockerfiles(true);
    }

    public CreateProject setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
        return this;
    }

    public CreateProject buildTool(BuildTool buildTool) {
        this.buildTool = Objects.requireNonNull(buildTool, "buildTool is required");
        return this;
    }

    public boolean doCreateProject(Map<String, Object> context) throws QuarkusCommandException {
        if (context != null && !context.isEmpty()) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (entry.getValue() == null) continue;
                this.setValue(entry.getKey(), entry.getValue());
            }
        }
        return this.execute().isSuccess();
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        Matcher matcher = JAVA_VERSION_PATTERN.matcher(this.javaTarget != null ? this.javaTarget : System.getProperty("java.version", ""));
        if (matcher.matches() && Integer.parseInt(matcher.group(1)) < 11) {
            this.setValue("java_target", "8");
        } else {
            this.setValue("java_target", "11");
        }
        QuarkusProject quarkusProject = QuarkusProject.of(this.projectDirPath, this.platformDescr, this.buildTool);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(quarkusProject, this.values);
        return new CreateProjectCommandHandler().execute(invocation);
    }

    public static SourceType determineSourceType(Set<String> extensions) {
        Optional<SourceType> sourceType = extensions.stream().map(SourceType::parse).filter(Optional::isPresent).map(e -> e.orElse(SourceType.JAVA)).findAny();
        return sourceType.orElse(SourceType.JAVA);
    }

    private static boolean isSpringStyle(Collection<String> extensions) {
        return extensions != null && extensions.stream().anyMatch(e -> e.toLowerCase().contains("spring-web"));
    }
}

