/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.reader;

import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.core.reader.CodestartFileReader;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;

final class QuteCodestartFileReader
implements CodestartFileReader {
    private static final String TPL_QUTE_FLAG = ".tpl.qute";
    private static final String ENTRY_QUTE_FLAG = ".entry.qute";
    public static final String INCLUDE_QUTE_FLAG = ".include.qute";

    QuteCodestartFileReader() {
    }

    @Override
    public boolean matches(String fileName) {
        return fileName.contains(TPL_QUTE_FLAG) || fileName.contains(ENTRY_QUTE_FLAG) || fileName.contains(INCLUDE_QUTE_FLAG);
    }

    @Override
    public String cleanFileName(String fileName) {
        return fileName.replaceAll(TPL_QUTE_FLAG, "").replace(ENTRY_QUTE_FLAG, "");
    }

    @Override
    public Optional<String> read(CodestartResource projectResource, CodestartResource.Source source, String languageName, Map<String, Object> data) throws IOException {
        if (FilenameUtils.getName((String)source.path()).contains(INCLUDE_QUTE_FLAG)) {
            return Optional.empty();
        }
        return Optional.of(QuteCodestartFileReader.readQuteFile(projectResource, source, languageName, data));
    }

    public static String readQuteFile(CodestartResource projectResource, CodestartResource.Source source, String languageName, Map<String, Object> data) {
        String content = source.read();
        Engine engine = Engine.builder().addDefaults().addResultMapper((ResultMapper)new MissingValueMapper()).removeStandaloneLines(true).addLocator(id -> QuteCodestartFileReader.findIncludeTemplate(source.getCodestartResource(), languageName, id).map(IncludeTemplateLocation::new)).addLocator(id -> QuteCodestartFileReader.findIncludeTemplate(projectResource, languageName, id).map(IncludeTemplateLocation::new)).addLocator(id -> Optional.of(new FallbackTemplateLocation())).build();
        try {
            return engine.parse(content).render(data);
        }
        catch (Exception e) {
            throw new CodestartException("Error while rendering template: " + source.absolutePath(), e);
        }
    }

    private static Optional<CodestartResource.Source> findIncludeTemplate(CodestartResource projectResource, String languageName, String name) {
        String includeFileName = name + INCLUDE_QUTE_FLAG;
        Optional<CodestartResource.Source> languageIncludeSource = projectResource.getSource(languageName, includeFileName);
        if (languageIncludeSource.isPresent()) {
            return languageIncludeSource;
        }
        Optional<CodestartResource.Source> baseIncludeSource = projectResource.getSource("base", includeFileName);
        if (baseIncludeSource.isPresent()) {
            return baseIncludeSource;
        }
        return Optional.empty();
    }

    static class MissingValueMapper
    implements ResultMapper {
        MissingValueMapper() {
        }

        public boolean appliesTo(TemplateNode.Origin origin, Object result) {
            return Results.Result.NOT_FOUND.equals(result);
        }

        public String map(Object result, Expression expression) {
            if (expression.toOriginalString().equals("merged-content")) {
                return "{merged-content}";
            }
            throw new TemplateException("Missing required data: {" + expression.toOriginalString() + "}");
        }
    }

    private static class IncludeTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private final CodestartResource.Source source;

        public IncludeTemplateLocation(CodestartResource.Source source) {
            this.source = source;
        }

        public Reader read() {
            return new StringReader(this.source.read());
        }

        public Optional<Variant> getVariant() {
            return Optional.empty();
        }
    }

    private static class FallbackTemplateLocation
    implements TemplateLocator.TemplateLocation {
        private FallbackTemplateLocation() {
        }

        public Reader read() {
            return new StringReader("");
        }

        public Optional<Variant> getVariant() {
            return Optional.empty();
        }
    }
}

