/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.deployment.dev.testing.HtmlAnsiProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.AnsiMode;
import org.fusesource.jansi.AnsiType;
import org.fusesource.jansi.io.AnsiOutputStream;
import org.fusesource.jansi.io.AnsiProcessor;

public class HtmlAnsiOutputStream
extends AnsiOutputStream {
    private static final byte[] BYTES_QUOT = "&quot;".getBytes();
    private static final byte[] BYTES_AMP = "&amp;".getBytes();
    private static final byte[] BYTES_LT = "&lt;".getBytes();
    private static final byte[] BYTES_GT = "&gt;".getBytes();

    public HtmlAnsiOutputStream(OutputStream os) {
        super(os, (AnsiOutputStream.WidthSupplier)new AnsiOutputStream.ZeroWidthSupplier(), AnsiMode.Force, (AnsiProcessor)new HtmlAnsiProcessor(os), AnsiType.Redirected, AnsiColors.Colors256, StandardCharsets.UTF_8, null, null, true);
    }

    public void write(int data) throws IOException {
        switch (data) {
            case 34: {
                this.out.write(BYTES_QUOT);
                break;
            }
            case 38: {
                this.out.write(BYTES_AMP);
                break;
            }
            case 60: {
                this.out.write(BYTES_LT);
                break;
            }
            case 62: {
                this.out.write(BYTES_GT);
                break;
            }
            default: {
                super.write(data);
            }
        }
    }
}

