/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.commons.classloading.ClassloadHelper;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalClassLoaderResourcesBuildItem;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AdditionalClassLoaderResourcesBuildStep {
    @BuildStep
    void appendAdditionalClassloaderResources(BuildProducer<AdditionalIndexedClassesBuildItem> producer, List<AdditionalClassLoaderResourcesBuildItem> additionalResources) {
        if (!additionalResources.isEmpty()) {
            QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            LinkedHashMap<String, byte[]> collected = new LinkedHashMap<String, byte[]>();
            ArrayList<String> additionalClassesToIndex = new ArrayList<String>();
            for (AdditionalClassLoaderResourcesBuildItem item : additionalResources) {
                for (Map.Entry<String, byte[]> entry : item.getResources().entrySet()) {
                    additionalClassesToIndex.add(entry.getKey());
                    collected.put(entry.getKey(), entry.getValue());
                    collected.put(ClassloadHelper.fromClassNameToResourceName((String)entry.getKey()), entry.getValue());
                }
            }
            cl.reset(collected, Collections.emptyMap());
            producer.produce(new AdditionalIndexedClassesBuildItem((String[])additionalClassesToIndex.stream().toArray(String[]::new)));
        }
    }
}

