/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.BootstrapGradleException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ProcessedSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class IDEDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger((String)IDEDevModeMain.class.getName());
    private static final String APP_PROJECT = "app-project";
    private IsolatedDevModeMain delegate;

    @Override
    public void accept(CuratedApplication curatedApplication, Map<String, Object> stringObjectMap) {
        Path appClasses = (Path)stringObjectMap.get("app-classes");
        DevModeContext devModeContext = new DevModeContext();
        devModeContext.setArgs((String[])stringObjectMap.get("args"));
        ApplicationModel appModel = null;
        try {
            appModel = BuildToolHelper.isMavenProject((Path)appClasses) ? curatedApplication.getApplicationModel() : BootstrapUtils.deserializeQuarkusModel((Path)((Path)stringObjectMap.get("quarkus-internal.serialized-app-model.path")));
            if (appModel != null) {
                for (WorkspaceModule project : DependenciesFilter.getReloadableModules((ApplicationModel)appModel)) {
                    DevModeContext.ModuleInfo module = this.toModule(project);
                    if (project == appModel.getApplicationModule()) {
                        devModeContext.setApplicationRoot(module);
                        continue;
                    }
                    devModeContext.getAdditionalModules().add(module);
                    devModeContext.getLocalArtifacts().add(new AppArtifactKey(project.getId().getGroupId(), project.getId().getArtifactId()));
                }
            }
        }
        catch (AppModelResolverException e) {
            log.error((Object)"Failed to load workspace, hot reload will not be available", (Throwable)e);
        }
        this.terminateIfRunning();
        this.delegate = new IsolatedDevModeMain();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DevModeContext.class.getName(), devModeContext);
        params.put(DevModeType.class.getName(), DevModeType.LOCAL);
        this.delegate.accept(curatedApplication, (Map<String, Object>)params);
    }

    @Override
    public void close() {
        this.terminateIfRunning();
    }

    private void terminateIfRunning() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private DevModeContext.ModuleInfo toModule(WorkspaceModule module) throws BootstrapGradleException {
        String classesDir = null;
        LinkedHashSet<Path> sourceParents = new LinkedHashSet<Path>();
        PathsCollection.Builder srcPaths = PathsCollection.builder();
        for (ProcessedSources src : module.getMainSources()) {
            sourceParents.add(src.getSourceDir().getParentFile().toPath());
            srcPaths.add(src.getSourceDir().toPath());
            if (classesDir != null) continue;
            classesDir = src.getDestinationDir().toString();
        }
        String resourceDirectory = null;
        PathsCollection.Builder resourcesPaths = PathsCollection.builder();
        for (ProcessedSources src : module.getMainResources()) {
            resourcesPaths.add(src.getSourceDir().toPath());
            if (resourceDirectory != null) continue;
            resourceDirectory = src.getDestinationDir().toString();
        }
        GACT key = new GACT(module.getId().getGroupId(), module.getId().getArtifactId());
        return new DevModeContext.ModuleInfo.Builder().setArtifactKey((ArtifactKey)key).setName(module.getId().getArtifactId()).setProjectDirectory(module.getModuleDir().getPath()).setSourcePaths(srcPaths.build()).setClassesPath(classesDir).setResourcePaths(resourcesPaths.build()).setResourcesOutputPath(resourceDirectory).setSourceParents(PathsCollection.from(sourceParents)).setPreBuildOutputDir(module.getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(module.getBuildDir().toString()).build();
    }
}

