/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.ClassChangeInformation;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.CodeGenerator;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.codegen.CodeGenData;
import io.quarkus.deployment.console.ConsoleCommand;
import io.quarkus.deployment.console.ConsoleStateManager;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.steps.ClassTransformingBuildStep;
import io.quarkus.deployment.util.FSWatchUtil;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.DeploymentFailedStartHandler;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class IsolatedDevModeMain
implements BiConsumer<CuratedApplication, Map<String, Object>>,
Closeable {
    private static final Logger log = Logger.getLogger(IsolatedDevModeMain.class);
    public static final String APP_ROOT = "app-root";
    private volatile DevModeContext context;
    private final List<HotReplacementSetup> hotReplacementSetups = new ArrayList<HotReplacementSetup>();
    private static volatile RunningQuarkusApplication runner;
    static volatile Throwable deploymentProblem;
    private static volatile CuratedApplication curatedApplication;
    private static volatile AugmentAction augmentAction;
    private static volatile boolean restarting;
    private static volatile boolean firstStartCompleted;
    private static final CountDownLatch shutdownLatch;
    private Thread shutdownThread;
    private final FSWatchUtil fsWatchUtil = new FSWatchUtil();
    private static volatile ConsoleStateManager.ConsoleContext consoleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void firstStart(QuarkusClassLoader deploymentClassLoader, List<CodeGenData> codeGens) {
        block11: {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    StartupAction start = augmentAction.createInitialRuntimeApplication();
                    curatedApplication.getBaseRuntimeClassLoader().loadClass(ApplicationLifecycleManager.class.getName()).getMethod("setDefaultExitCodeHandler", Consumer.class).invoke(null, new Consumer<Integer>(){

                        @Override
                        public void accept(Integer integer) {
                            if (restarting || ApplicationLifecycleManager.isVmShuttingDown() || IsolatedDevModeMain.this.context.isAbortOnFailedStart() || IsolatedDevModeMain.this.context.isTest()) {
                                return;
                            }
                            if (consoleContext == null) {
                                consoleContext = ConsoleStateManager.INSTANCE.createContext("Completed Application");
                            }
                            InitialConfigurator.DELAYED_HANDLER.addHandler((Handler)new ConsoleHandler(ConsoleHandler.Target.SYSTEM_OUT, (Formatter)new ColorPatternFormatter("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c{3.}] (%t) %s%e%n")));
                            consoleContext.reset(new ConsoleCommand(' ', "Restarts the application", "to restart", 0, null, () -> {
                                consoleContext.reset(new ConsoleCommand[0]);
                                RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
                            }), new ConsoleCommand('e', "Edits the command line parameters and restarts", "to edit command line args (currently '\u001b[32m" + String.join((CharSequence)" ", IsolatedDevModeMain.this.context.getArgs()) + "\u001b[39m')", 100, new ConsoleCommand.HelpState(() -> "\u001b[94m", () -> String.join((CharSequence)" ", IsolatedDevModeMain.this.context.getArgs())), new Consumer<String>(){

                                @Override
                                public void accept(String args) {
                                    try {
                                        IsolatedDevModeMain.this.context.setArgs(CommandLineUtils.translateCommandline((String)args));
                                    }
                                    catch (CommandLineException e) {
                                        log.error((Object)"Failed to parse command line", (Throwable)e);
                                        return;
                                    }
                                    consoleContext.reset(new ConsoleCommand[0]);
                                    RuntimeUpdatesProcessor.INSTANCE.doScan(true, true);
                                }
                            }));
                        }
                    });
                    this.startCodeGenWatcher(deploymentClassLoader, codeGens, this.context.getBuildSystemProperties());
                    runner = start.runMainClass(this.context.getArgs());
                    RuntimeUpdatesProcessor.INSTANCE.setConfiguredInstrumentationEnabled(runner.getConfigValue("quarkus.live-reload.instrumentation", Boolean.class).orElse(false));
                    firstStartCompleted = true;
                }
                catch (Throwable t) {
                    Throwable rootCause = t;
                    while (rootCause.getCause() != null) {
                        rootCause = rootCause.getCause();
                    }
                    if (rootCause instanceof BindException) break block11;
                    deploymentProblem = t;
                    if (!this.context.isAbortOnFailedStart()) {
                        log.info((Object)"Attempting to start live reload endpoint to recover from previous Quarkus startup failure");
                        if (RuntimeUpdatesProcessor.INSTANCE != null) {
                            Thread.currentThread().setContextClassLoader((ClassLoader)curatedApplication.getBaseRuntimeClassLoader());
                            try {
                                if (!InitialConfigurator.DELAYED_HANDLER.isActivated()) {
                                    Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(LoggingSetupRecorder.class.getName());
                                    cl.getMethod("handleFailedStart", new Class[0]).invoke(null, new Object[0]);
                                }
                                RuntimeUpdatesProcessor.INSTANCE.startupFailed();
                                log.error((Object)"Failed to start quarkus", t);
                            }
                            catch (Exception e) {
                                this.close();
                                log.error((Object)"Failed to start quarkus", t);
                                log.error((Object)"Failed to recover after failed start", (Throwable)e);
                                System.exit(1);
                            }
                        }
                        break block11;
                    }
                    log.error((Object)"Failed to start quarkus", t);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    private void startCodeGenWatcher(QuarkusClassLoader classLoader, List<CodeGenData> codeGens, Map<String, String> propertyMap) {
        ArrayList<FSWatchUtil.Watcher> watchers = new ArrayList<FSWatchUtil.Watcher>();
        Properties properties = new Properties();
        properties.putAll(propertyMap);
        for (CodeGenData codeGen : codeGens) {
            watchers.add(new FSWatchUtil.Watcher(codeGen.sourceDir, codeGen.provider.inputExtension(), modifiedPaths -> {
                try {
                    CodeGenerator.trigger((ClassLoader)classLoader, codeGen, curatedApplication.getApplicationModel(), properties, LaunchMode.DEVELOPMENT);
                }
                catch (Exception any) {
                    log.warn((Object)"Code generation failed", (Throwable)any);
                }
            }));
        }
        this.fsWatchUtil.observe(watchers, 500L);
    }

    public void restartCallback(Set<String> changedResources, ClassScanResult result) {
        this.restartApp(changedResources, new ClassChangeInformation(result.changedClassNames, result.deletedClassNames, result.addedClassNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restartApp(Set<String> changedResources, ClassChangeInformation classChangeInformation) {
        restarting = true;
        if (consoleContext != null) {
            consoleContext.reset(new ConsoleCommand[0]);
        }
        this.stop();
        Timing.restart((ClassLoader)curatedApplication.getAugmentClassLoader());
        deploymentProblem = null;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            try {
                StartupAction start = augmentAction.reloadExistingApplication(firstStartCompleted, changedResources, classChangeInformation);
                runner = start.runMainClass(this.context.getArgs());
                firstStartCompleted = true;
            }
            catch (Throwable t) {
                deploymentProblem = t;
                Throwable rootCause = t;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                if (!(rootCause instanceof BindException)) {
                    log.error((Object)"Failed to start quarkus", t);
                    Thread.currentThread().setContextClassLoader((ClassLoader)curatedApplication.getAugmentClassLoader());
                    LoggingSetupRecorder.handleFailedStart();
                }
            }
        }
        finally {
            restarting = false;
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private RuntimeUpdatesProcessor setupRuntimeCompilation(DevModeContext context, Path appRoot, DevModeType devModeType) throws Exception {
        if (!context.getAllModules().isEmpty()) {
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            for (CompilationProvider provider : serviceLoader) {
                compilationProviders.add(provider);
                context.getAllModules().forEach(moduleInfo -> moduleInfo.addSourcePaths(provider.handledSourcePaths()));
            }
            QuarkusCompiler compiler = new QuarkusCompiler(curatedApplication, compilationProviders, context);
            TestSupport testSupport = null;
            if (devModeType == DevModeType.LOCAL) {
                testSupport = new TestSupport(curatedApplication, compilationProviders, context, devModeType);
            }
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(appRoot, context, compiler, devModeType, this::restartCallback, null, new BiFunction<String, byte[], byte[]>(){

                @Override
                public byte[] apply(String s, byte[] bytes) {
                    return ClassTransformingBuildStep.transform(s, bytes);
                }
            }, testSupport);
            for (HotReplacementSetup hotReplacementSetup : ServiceLoader.load(HotReplacementSetup.class, (ClassLoader)curatedApplication.getBaseRuntimeClassLoader())) {
                this.hotReplacementSetups.add(hotReplacementSetup);
                hotReplacementSetup.setupHotDeployment((HotReplacementContext)processor);
                processor.addHotReplacementSetup(hotReplacementSetup);
            }
            for (final DeploymentFailedStartHandler deploymentFailedStartHandler : ServiceLoader.load(DeploymentFailedStartHandler.class, (ClassLoader)curatedApplication.getAugmentClassLoader())) {
                processor.addDeploymentFailedStartHandler(new Runnable(){

                    @Override
                    public void run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        try {
                            Thread.currentThread().setContextClassLoader((ClassLoader)curatedApplication.getAugmentClassLoader());
                            deploymentFailedStartHandler.handleFailedInitialStart();
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(old);
                        }
                    }
                });
            }
            DevConsoleManager.setQuarkusBootstrap((Object)curatedApplication.getQuarkusBootstrap());
            DevConsoleManager.setHotReplacementContext((HotReplacementContext)processor);
            return processor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ClassLoader old;
        if (runner != null) {
            old = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(runner.getClassLoader());
            try {
                runner.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        QuarkusConfigFactory.setConfig(null);
        old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigProviderResolver cpr = ConfigProviderResolver.instance();
            cpr.releaseConfig(cpr.getConfig());
        }
        catch (Throwable throwable) {
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        runner = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        restarting = true;
        this.fsWatchUtil.shutdown();
        try {
            this.stop();
        }
        finally {
            try {
                try {
                    RuntimeUpdatesProcessor.INSTANCE.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close compiler", (Throwable)e);
                }
                for (HotReplacementSetup i : this.hotReplacementSetups) {
                    i.close();
                }
            }
            finally {
                try {
                    DevConsoleManager.close();
                    curatedApplication.close();
                }
                finally {
                    if (this.shutdownThread != null) {
                        try {
                            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                        }
                        catch (IllegalStateException illegalStateException) {}
                        this.shutdownThread = null;
                    }
                    shutdownLatch.countDown();
                }
            }
        }
    }

    @Override
    public void accept(CuratedApplication o, Map<String, Object> params) {
        System.setProperty("java.nio.channels.DefaultThreadPool.threadFactory", "io.quarkus.dev.io.NioThreadPoolThreadFactory");
        Timing.staticInitStarted((ClassLoader)o.getBaseRuntimeClassLoader(), (boolean)false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "Quarkus Devmode keep alive thread").start();
        try {
            curatedApplication = o;
            Object potentialContext = params.get(DevModeContext.class.getName());
            if (potentialContext instanceof DevModeContext) {
                this.context = (DevModeContext)potentialContext;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream oo = new ObjectOutputStream(out);
                oo.writeObject(potentialContext);
                this.context = (DevModeContext)new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())).readObject();
            }
            augmentAction = new AugmentActionImpl(curatedApplication, Collections.singletonList(new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)new ApplicationClassPredicateBuildItem(new Predicate<String>(){

                                @Override
                                public boolean test(String s) {
                                    QuarkusClassLoader cl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
                                    List res = cl.getElementsWithResource(s.replace('.', '/') + ".class", true);
                                    return !res.isEmpty();
                                }
                            }));
                        }
                    }).produces(ApplicationClassPredicateBuildItem.class).build();
                }
            }), Collections.emptyList());
            ArrayList<CodeGenData> codeGens = new ArrayList<CodeGenData>();
            QuarkusClassLoader deploymentClassLoader = curatedApplication.createDeploymentClassLoader();
            for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                if (module.getSourceParents().isEmpty() || module.getPreBuildOutputDir() == null) continue;
                codeGens.addAll(CodeGenerator.init((ClassLoader)deploymentClassLoader, module.getSourceParents(), Paths.get(module.getPreBuildOutputDir(), new String[0]), Paths.get(module.getTargetDir(), new String[0]), sourcePath -> module.addSourcePaths(Collections.singleton(sourcePath.toAbsolutePath().toString()))));
            }
            RuntimeUpdatesProcessor.INSTANCE = this.setupRuntimeCompilation(this.context, (Path)params.get(APP_ROOT), (DevModeType)params.get(DevModeType.class.getName()));
            if (RuntimeUpdatesProcessor.INSTANCE != null) {
                RuntimeUpdatesProcessor.INSTANCE.checkForFileChange();
                RuntimeUpdatesProcessor.INSTANCE.checkForChangedClasses(true);
            }
            this.firstStart(deploymentClassLoader, codeGens);
            if ((deploymentProblem != null || RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() != null) && this.context.isAbortOnFailedStart()) {
                throw new RuntimeException(deploymentProblem == null ? RuntimeUpdatesProcessor.INSTANCE.getCompileProblem() : deploymentProblem);
            }
            this.shutdownThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    shutdownLatch.countDown();
                    Class<DevModeMain> clazz = DevModeMain.class;
                    synchronized (DevModeMain.class) {
                        if (runner != null) {
                            try {
                                IsolatedDevModeMain.this.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, "Quarkus Shutdown Thread");
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        shutdownLatch = new CountDownLatch(1);
    }
}

