/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import java.util.function.Consumer;
import java.util.function.Supplier;

public final class ConsoleCommand {
    private final char key;
    private final String description;
    private final String promptString;
    private final int promptPriority;
    private final Runnable runnable;
    private final Consumer<String> readLineHandler;
    private final HelpState helpState;

    public ConsoleCommand(char key, String description, String promptString, int promptPriority, HelpState helpState, Consumer<String> readLineHandler) {
        this.key = key;
        this.description = description;
        this.promptString = promptString;
        this.promptPriority = promptPriority;
        this.runnable = null;
        this.helpState = helpState;
        this.readLineHandler = readLineHandler;
    }

    public ConsoleCommand(char key, String description, String promptString, int promptPriority, HelpState helpState, Runnable runnable) {
        this.key = key;
        this.description = description;
        this.promptString = promptString;
        this.promptPriority = promptPriority;
        this.runnable = runnable;
        this.helpState = helpState;
        this.readLineHandler = null;
    }

    public ConsoleCommand(char key, String description, HelpState helpState, Runnable runnable) {
        this(key, description, null, -1, helpState, runnable);
    }

    public char getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public String getPromptString() {
        return this.promptString;
    }

    public int getPromptPriority() {
        return this.promptPriority;
    }

    public HelpState getHelpState() {
        return this.helpState;
    }

    public Consumer<String> getReadLineHandler() {
        return this.readLineHandler;
    }

    public static class HelpState {
        final Supplier<Boolean> toggleState;
        final Supplier<String> colorSupplier;
        final Supplier<String> stateSupplier;

        public HelpState(Supplier<Boolean> toggleState) {
            this.toggleState = toggleState;
            this.colorSupplier = null;
            this.stateSupplier = null;
        }

        public HelpState(Supplier<String> colorSupplier, Supplier<String> stateSupplier) {
            this.toggleState = null;
            this.colorSupplier = colorSupplier;
            this.stateSupplier = stateSupplier;
        }

        public Supplier<Boolean> getToggleState() {
            return this.toggleState;
        }

        public Supplier<String> getColorSupplier() {
            return this.colorSupplier;
        }

        public Supplier<String> getStateSupplier() {
            return this.stateSupplier;
        }
    }
}

