/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DeploymentClassLoaderBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.graal.InetRunTime;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

class ConfigBuildSteps {
    static final String PROVIDER_CLASS_NAME = "io.quarkus.runtime.generated.ConfigSourceProviderImpl";
    static final String SERVICES_PREFIX = "META-INF/services/";

    ConfigBuildSteps() {
    }

    @BuildStep
    void generateConfigSources(List<RunTimeConfigurationSourceBuildItem> runTimeSources, BuildProducer<GeneratedClassBuildItem> generatedClass) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        try (ClassCreator cc = ClassCreator.builder().interfaces(new Class[]{ConfigSourceProvider.class}).setFinal(true).className(PROVIDER_CLASS_NAME).classOutput((ClassOutput)classOutput).build();
             MethodCreator mc = cc.getMethodCreator(MethodDescriptor.ofMethod(ConfigSourceProvider.class, (String)"getConfigSources", Iterable.class, (Class[])new Class[]{ClassLoader.class}));){
            ResultHandle array = mc.newArray(ConfigSource.class, mc.load(runTimeSources.size()));
            for (int i = 0; i < runTimeSources.size(); ++i) {
                RunTimeConfigurationSourceBuildItem runTimeSource = runTimeSources.get(i);
                String className = runTimeSource.getClassName();
                OptionalInt priority = runTimeSource.getPriority();
                ResultHandle value = priority.isPresent() ? mc.newInstance(MethodDescriptor.ofConstructor((Object)className, (Object[])new Object[]{Integer.TYPE}), new ResultHandle[]{mc.load(priority.getAsInt())}) : mc.newInstance(MethodDescriptor.ofConstructor((String)className, (String[])new String[0]), new ResultHandle[0]);
                mc.writeArrayValue(array, i, value);
            }
            ResultHandle list = mc.invokeStaticMethod(MethodDescriptor.ofMethod(Arrays.class, (String)"asList", List.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{array});
            mc.returnValue(list);
        }
    }

    @BuildStep
    void nativeServiceProviders(DeploymentClassLoaderBuildItem classLoaderItem, BuildProducer<ServiceProviderBuildItem> providerProducer) throws IOException {
        providerProducer.produce(new ServiceProviderBuildItem(ConfigProviderResolver.class.getName(), SmallRyeConfigProviderResolver.class.getName()));
        ClassLoader classLoader = classLoaderItem.getClassLoader();
        classLoader.getResources(SERVICES_PREFIX + ConfigSourceProvider.class.getName());
        for (Class serviceClass : Arrays.asList(ConfigSource.class, ConfigSourceProvider.class, Converter.class)) {
            String serviceName = serviceClass.getName();
            Set<String> names = ServiceUtil.classNamesNamedIn(classLoader, SERVICES_PREFIX + serviceName);
            List<String> list = names.stream().filter(s -> !s.startsWith("org.jboss.resteasy.microprofile.config.")).collect(Collectors.toList());
            if (list.isEmpty()) continue;
            providerProducer.produce(new ServiceProviderBuildItem(serviceName, list));
        }
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitializedClass() {
        return new RuntimeInitializedClassBuildItem(InetRunTime.class.getName());
    }
}

