/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.graal.ImageInfo;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import java.math.BigDecimal;
import java.util.logging.Handler;
import org.jboss.logging.Logger;

public class Timing {
    private static volatile long bootStartTime = -1L;
    private static volatile long bootStopTime = -1L;
    private static volatile String httpServerInfo = "";
    private static final String UNSET_VALUE = "<<unset>>";

    public static void staticInitStarted() {
        if (bootStartTime < 0L) {
            bootStartTime = System.nanoTime();
        }
    }

    public static void staticInitStarted(ClassLoader cl) {
        try {
            Class<?> realTiming = cl.loadClass(Timing.class.getName());
            realTiming.getMethod("staticInitStarted", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void staticInitStopped() {
        if (bootStopTime < 0L) {
            bootStopTime = System.nanoTime();
        }
    }

    public static void setHttpServer(String info) {
        httpServerInfo = info;
    }

    public static void mainStarted() {
    }

    public static void restart() {
        bootStartTime = System.nanoTime();
    }

    public static void restart(ClassLoader cl) {
        try {
            Class<?> realTiming = cl.loadClass(Timing.class.getName());
            realTiming.getMethod("restart", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void printStartupTime(String name, String version, String quarkusVersion, String features, String profile, boolean liveCoding) {
        String nativeOrJvm;
        long bootTimeNanoSeconds = System.nanoTime() - bootStartTime;
        Logger logger = Logger.getLogger((String)"io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(bootTimeNanoSeconds);
        String safeAppName = name == null || name.trim().isEmpty() ? UNSET_VALUE : name;
        String safeAppVersion = version == null || version.trim().isEmpty() ? UNSET_VALUE : version;
        String string = nativeOrJvm = ImageInfo.inImageRuntimeCode() ? "native" : "on JVM";
        if (UNSET_VALUE.equals(safeAppName) || UNSET_VALUE.equals(safeAppVersion)) {
            logger.infof("Quarkus %s %s started in %ss. %s", new Object[]{quarkusVersion, nativeOrJvm, secondsRepresentation, httpServerInfo});
        } else {
            logger.infof("%s %s %s (powered by Quarkus %s) started in %ss. %s", new Object[]{name, version, nativeOrJvm, quarkusVersion, secondsRepresentation, httpServerInfo});
        }
        logger.infof("Profile %s activated. %s", (Object)profile, (Object)(liveCoding ? "Live Coding activated." : ""));
        logger.infof("Installed features: [%s]", (Object)features);
        bootStartTime = -1L;
    }

    public static void printStopTime(String name) {
        Handler[] handlers;
        long stopTimeNanoSeconds = System.nanoTime() - bootStopTime;
        Logger logger = Logger.getLogger((String)"io.quarkus");
        BigDecimal secondsRepresentation = Timing.convertToBigDecimalSeconds(stopTimeNanoSeconds);
        logger.infof("%s stopped in %ss", (Object)(UNSET_VALUE.equals(name) || name == null || name.trim().isEmpty() ? "Quarkus" : name), (Object)secondsRepresentation);
        bootStopTime = -1L;
        for (Handler handler : handlers = InitialConfigurator.DELAYED_HANDLER.clearHandlers()) {
            try {
                handler.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static BigDecimal convertToBigDecimalSeconds(long timeNanoSeconds) {
        BigDecimal secondsRepresentation = BigDecimal.valueOf(timeNanoSeconds).divide(BigDecimal.valueOf(1000000L), 4).divide(BigDecimal.valueOf(1000L), 3, 4);
        return secondsRepresentation;
    }
}

