/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.javax.inject.Inject;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.scripts.DefaultScriptFileResolver;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Global.class})
public class BuildLayoutFactory {
    private static final String DEFAULT_SETTINGS_FILE_BASENAME = "settings";
    private final ScriptFileResolver scriptFileResolver;

    @Inject
    public BuildLayoutFactory(ScriptFileResolver scriptFileResolver) {
        this.scriptFileResolver = scriptFileResolver;
    }

    public BuildLayoutFactory() {
        this(new DefaultScriptFileResolver());
    }

    public BuildLayout getLayoutFor(File currentDir, boolean shouldSearchUpwards) {
        boolean searchUpwards = shouldSearchUpwards && !BuildLayoutFactory.isBuildSrc(currentDir);
        BuildLayout layout = searchUpwards ? this.findLayoutRecursively(currentDir) : this.findLayout(currentDir);
        return layout != null ? layout : this.getLayoutWithDefaultSettingsFile(currentDir);
    }

    public BuildLayout getLayoutFor(BuildLayoutConfiguration configuration) {
        if (configuration.isUseEmptySettings()) {
            return this.layout(configuration.getCurrentDir(), null);
        }
        return this.getLayoutFor(configuration.getCurrentDir(), configuration.isSearchUpwards());
    }

    public @Nullable File findExistingSettingsFileIn(File directory) {
        return this.scriptFileResolver.resolveScriptFile(directory, DEFAULT_SETTINGS_FILE_BASENAME);
    }

    private @Nullable BuildLayout findLayoutRecursively(File dir) {
        while (dir != null) {
            BuildLayout layout = this.findLayout(dir);
            if (layout != null) {
                return layout;
            }
            dir = dir.getParentFile();
        }
        return null;
    }

    private @Nullable BuildLayout findLayout(File dir) {
        File settingsFile = this.findExistingSettingsFileIn(dir);
        return settingsFile != null ? this.layout(dir, settingsFile) : null;
    }

    private BuildLayout getLayoutWithDefaultSettingsFile(File dir) {
        return this.layout(dir, new File(dir, "settings.gradle"));
    }

    private BuildLayout layout(File rootDir, @Nullable File settingsFile) {
        File canonicalSettingsFile = settingsFile != null ? FileUtils.canonicalize(settingsFile) : null;
        return new BuildLayout(rootDir, canonicalSettingsFile, this.scriptFileResolver);
    }

    private static boolean isBuildSrc(File dir) {
        return dir.getName().equals("buildSrc");
    }
}

