/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.CountdownTimer;
import org.gradle.internal.time.DefaultCountdownTimer;
import org.gradle.internal.time.DefaultTimer;
import org.gradle.internal.time.MonotonicClock;
import org.gradle.internal.time.TimeSource;
import org.gradle.internal.time.Timer;

public abstract class Time {
    private static final Clock CLOCK = new MonotonicClock();

    public static Clock clock() {
        return CLOCK;
    }

    public static long currentTimeMillis() {
        return CLOCK.getCurrentTime();
    }

    public static Timer startTimer() {
        return new DefaultTimer(TimeSource.SYSTEM);
    }

    public static CountdownTimer startCountdownTimer(long timeoutMillis) {
        return new DefaultCountdownTimer(TimeSource.SYSTEM, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public static CountdownTimer startCountdownTimer(long timeout, TimeUnit unit) {
        return new DefaultCountdownTimer(TimeSource.SYSTEM, timeout, unit);
    }

    private Time() {
    }
}

