/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.BootstrapAppModelFactory;
import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.BootstrapProfile;
import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public class QuarkusBootstrap
implements Serializable {
    private static final long serialVersionUID = -3400622859354530408L;
    private final PathCollection applicationRoot;
    private final Path projectRoot;
    private final List<AdditionalDependency> additionalApplicationArchives;
    private final List<Path> additionalDeploymentArchives;
    private final List<Path> excludeFromClassPath;
    private final Properties buildSystemProperties;
    private final String baseName;
    private final Path targetDirectory;
    private final Mode mode;
    private final Boolean offline;
    private final boolean test;
    private final Boolean localProjectDiscovery;
    private final ClassLoader baseClassLoader;
    private final AppModelResolver appModelResolver;
    private final ResolvedDependency appArtifact;
    private final boolean isolateDeployment;
    private final MavenArtifactResolver mavenArtifactResolver;
    private final ArtifactCoords managingProject;
    private final List<Dependency> forcedDependencies;
    private final boolean disableClasspathCache;
    private final ApplicationModel existingModel;
    private final boolean rebuild;
    private final Set<ArtifactKey> localArtifacts;
    private final List<ClassLoaderEventListener> classLoadListeners;
    private final boolean auxiliaryApplication;
    private final boolean hostApplicationIsTestOnly;
    private final boolean flatClassPath;
    private final ConfiguredClassLoading classLoadingConfig;
    private final boolean assertionsEnabled;

    private QuarkusBootstrap(Builder builder, ConfiguredClassLoading classLoadingConfig) {
        this.applicationRoot = builder.applicationRoot;
        this.additionalApplicationArchives = new ArrayList<AdditionalDependency>(builder.additionalApplicationArchives);
        this.excludeFromClassPath = new ArrayList<Path>(builder.excludeFromClassPath);
        this.projectRoot = builder.projectRoot != null ? builder.projectRoot.normalize() : null;
        this.buildSystemProperties = builder.buildSystemProperties;
        this.mode = builder.mode;
        this.offline = builder.offline;
        this.test = builder.test;
        this.localProjectDiscovery = builder.localProjectDiscovery;
        this.baseName = builder.baseName;
        this.baseClassLoader = builder.baseClassLoader;
        this.targetDirectory = builder.targetDirectory;
        this.appModelResolver = builder.appModelResolver;
        this.assertionsEnabled = builder.assertionsEnabled;
        this.appArtifact = builder.appArtifact;
        this.isolateDeployment = builder.isolateDeployment;
        this.additionalDeploymentArchives = builder.additionalDeploymentArchives;
        this.mavenArtifactResolver = builder.mavenArtifactResolver;
        this.managingProject = builder.managingProject;
        this.forcedDependencies = new ArrayList<Dependency>(builder.forcedDependencies);
        this.disableClasspathCache = builder.disableClasspathCache;
        this.existingModel = builder.existingModel;
        this.rebuild = builder.rebuild;
        this.localArtifacts = new HashSet<ArtifactKey>(builder.localArtifacts);
        this.classLoadListeners = builder.classLoadListeners;
        this.auxiliaryApplication = builder.auxiliaryApplication;
        this.flatClassPath = builder.flatClassPath;
        this.classLoadingConfig = classLoadingConfig;
        this.hostApplicationIsTestOnly = builder.hostApplicationIsTestOnly;
    }

    public CuratedApplication bootstrap() throws BootstrapException {
        if (this.existingModel != null) {
            return new CuratedApplication(this, new CurationResult(this.existingModel), this.classLoadingConfig);
        }
        BootstrapAppModelFactory appModelFactory = BootstrapAppModelFactory.newInstance().setOffline(this.offline).setMavenArtifactResolver(this.mavenArtifactResolver).setBootstrapAppModelResolver(this.appModelResolver).setLocalProjectsDiscovery(this.localProjectDiscovery).setAppArtifact(this.appArtifact).setManagingProject(this.managingProject).setForcedDependencies(this.forcedDependencies).setLocalArtifacts(this.localArtifacts).setProjectRoot(this.getProjectRoot());
        if (this.mode == Mode.TEST || this.test) {
            appModelFactory.setTest(true);
            if (!this.disableClasspathCache) {
                appModelFactory.setEnableClasspathCache(true);
            }
        }
        if (this.mode == Mode.DEV) {
            appModelFactory.setDevMode(true);
            if (!this.disableClasspathCache) {
                appModelFactory.setEnableClasspathCache(true);
            }
        }
        return new CuratedApplication(this, appModelFactory.resolveAppModel(), this.classLoadingConfig);
    }

    public static ConfiguredClassLoading createClassLoadingConfig(PathCollection applicationRoot, Mode mode, List<ArtifactKey> parentFirstArtifacts) {
        for (Path path : applicationRoot) {
            ConfiguredClassLoading configuredClassLoading;
            block9: {
                Path props = path.resolve("application.properties");
                if (!Files.exists(props, new LinkOption[0])) continue;
                InputStream in = Files.newInputStream(props, new OpenOption[0]);
                try {
                    Properties p = new Properties();
                    p.load(in);
                    Set<ArtifactKey> parentFirst = QuarkusBootstrap.toArtifactSet(p.getProperty(QuarkusBootstrap.selectKey("quarkus.class-loading.parent-first-artifacts", p, mode)));
                    parentFirst.addAll(parentFirstArtifacts);
                    Set<ArtifactKey> liveReloadable = QuarkusBootstrap.toArtifactSet(p.getProperty(QuarkusBootstrap.selectKey("quarkus.class-loading.reloadable-artifacts", p, mode)));
                    Set<ArtifactKey> removedArtifacts = QuarkusBootstrap.toArtifactSet(p.getProperty(QuarkusBootstrap.selectKey("quarkus.class-loading.removed-artifacts", p, mode)));
                    boolean flatClassPath = Boolean.parseBoolean(p.getProperty(QuarkusBootstrap.selectKey("quarkus.test.flat-class-path", p, mode)));
                    Map<ArtifactKey, List<String>> removedResources = QuarkusBootstrap.toArtifactMapList("quarkus.class-loading.removed-resources.", p, mode);
                    configuredClassLoading = new ConfiguredClassLoading(parentFirst, liveReloadable, removedArtifacts, removedResources, flatClassPath);
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to load bootstrap classloading config from application.properties", e);
                    }
                }
                in.close();
            }
            return configuredClassLoading;
        }
        return new ConfiguredClassLoading(new HashSet<ArtifactKey>(parentFirstArtifacts), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), false);
    }

    private static Map<ArtifactKey, List<String>> toArtifactMapList(String baseConfigKey, Properties properties, Mode mode) {
        Properties profileProps = new Properties();
        String profile = BootstrapProfile.getActiveProfile(mode);
        for (Map.Entry<Object, Object> i : properties.entrySet()) {
            String key = i.getKey().toString();
            if (key.startsWith("%")) continue;
            String profileKey = "%" + profile + "." + key;
            if (properties.containsKey(profileKey)) {
                profileProps.put(key, properties.getProperty(profileKey));
                continue;
            }
            profileProps.put(key, i.getValue());
        }
        HashMap<ArtifactKey, List<String>> ret = new HashMap<ArtifactKey, List<String>>();
        for (Map.Entry<Object, Object> entry : profileProps.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!key.startsWith(baseConfigKey)) continue;
            String artifactId = key.substring(baseConfigKey.length());
            artifactId = artifactId.replace("\"", "");
            List<String> resources = Arrays.asList(value.split(","));
            ret.put((ArtifactKey)new GACT(artifactId.split(":")), resources);
        }
        return ret;
    }

    private static String selectKey(String base, Properties p, Mode mode) {
        String profile = BootstrapProfile.getActiveProfile(mode);
        String profileKey = "%" + profile + "." + base;
        if (p.containsKey(profileKey)) {
            return profileKey;
        }
        return base;
    }

    private static Set<ArtifactKey> toArtifactSet(String config) {
        if (config == null) {
            return new HashSet<ArtifactKey>();
        }
        HashSet<ArtifactKey> ret = new HashSet<ArtifactKey>();
        for (String i : config.split(",")) {
            ret.add((ArtifactKey)new GACT(i.split(":")));
        }
        return ret;
    }

    public AppModelResolver getAppModelResolver() {
        return this.appModelResolver;
    }

    public PathCollection getApplicationRoot() {
        return this.applicationRoot;
    }

    public List<AdditionalDependency> getAdditionalApplicationArchives() {
        return Collections.unmodifiableList(this.additionalApplicationArchives);
    }

    public List<Path> getAdditionalDeploymentArchives() {
        return Collections.unmodifiableList(this.additionalDeploymentArchives);
    }

    public List<Path> getExcludeFromClassPath() {
        return Collections.unmodifiableList(this.excludeFromClassPath);
    }

    public Properties getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isAuxiliaryApplication() {
        return this.auxiliaryApplication;
    }

    public boolean isHostApplicationIsTestOnly() {
        return this.hostApplicationIsTestOnly;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder builder(Path applicationRoot) {
        return new Builder().setApplicationRoot((PathCollection)PathList.of((Path[])new Path[]{applicationRoot}));
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ClassLoader getBaseClassLoader() {
        return this.baseClassLoader;
    }

    public Path getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isIsolateDeployment() {
        return this.isolateDeployment;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    public List<ClassLoaderEventListener> getClassLoaderEventListeners() {
        return this.classLoadListeners;
    }

    public Builder clonedBuilder() {
        Builder builder = new Builder().setBaseName(this.baseName).setProjectRoot(this.projectRoot).setBaseClassLoader(this.baseClassLoader).setBuildSystemProperties(this.buildSystemProperties).setMode(this.mode).setTest(this.test).setLocalProjectDiscovery(this.localProjectDiscovery).setTargetDirectory(this.targetDirectory).setAppModelResolver(this.appModelResolver).setAssertionsEnabled(this.assertionsEnabled).setIsolateDeployment(this.isolateDeployment).setMavenArtifactResolver(this.mavenArtifactResolver).setManagingProject(this.managingProject).setForcedDependencies(this.forcedDependencies).setDisableClasspathCache(this.disableClasspathCache).addClassLoaderEventListeners(this.classLoadListeners).setExistingModel(this.existingModel);
        if (this.appArtifact != null) {
            builder.setAppArtifact(this.appArtifact);
        } else {
            builder.setApplicationRoot(this.applicationRoot);
        }
        if (this.offline != null) {
            builder.setOffline(this.offline);
        }
        builder.additionalApplicationArchives.addAll(this.additionalApplicationArchives);
        builder.additionalDeploymentArchives.addAll(this.additionalDeploymentArchives);
        builder.excludeFromClassPath.addAll(this.excludeFromClassPath);
        builder.localArtifacts.addAll(this.localArtifacts);
        return builder;
    }

    public boolean isFlatClassPath() {
        return this.flatClassPath;
    }

    public boolean isTest() {
        return this.test;
    }

    public static enum Mode {
        DEV,
        TEST,
        PROD,
        REMOTE_DEV_SERVER,
        REMOTE_DEV_CLIENT,
        CONTINUOUS_TEST;

    }

    public static class Builder {
        public List<ClassLoaderEventListener> classLoadListeners = new ArrayList<ClassLoaderEventListener>();
        public boolean hostApplicationIsTestOnly;
        boolean flatClassPath;
        boolean rebuild;
        PathCollection applicationRoot;
        String baseName;
        Path projectRoot;
        ClassLoader baseClassLoader = ClassLoader.getSystemClassLoader();
        final List<AdditionalDependency> additionalApplicationArchives = new ArrayList<AdditionalDependency>();
        final List<Path> additionalDeploymentArchives = new ArrayList<Path>();
        final List<Path> excludeFromClassPath = new ArrayList<Path>();
        Properties buildSystemProperties;
        Mode mode = Mode.PROD;
        Boolean offline;
        boolean test;
        Boolean localProjectDiscovery;
        Path targetDirectory;
        AppModelResolver appModelResolver;
        boolean assertionsEnabled = this.inheritedAssertionsEnabled();
        ResolvedDependency appArtifact;
        boolean isolateDeployment;
        MavenArtifactResolver mavenArtifactResolver;
        ArtifactCoords managingProject;
        List<Dependency> forcedDependencies = Collections.emptyList();
        boolean disableClasspathCache;
        ApplicationModel existingModel;
        final Set<ArtifactKey> localArtifacts = new HashSet<ArtifactKey>();
        boolean auxiliaryApplication;
        List<ArtifactKey> parentFirstArtifacts = new ArrayList<ArtifactKey>();

        public Builder setApplicationRoot(Path applicationRoot) {
            this.applicationRoot = PathList.of((Path[])new Path[]{applicationRoot});
            return this;
        }

        public Builder setApplicationRoot(PathCollection applicationRoot) {
            if (this.appArtifact != null) {
                throw new IllegalStateException("Cannot set both app artifact and application root");
            }
            this.applicationRoot = applicationRoot;
            return this;
        }

        public Builder addAdditionalApplicationArchive(AdditionalDependency path) {
            this.additionalApplicationArchives.add(path);
            return this;
        }

        public Builder addAdditionalApplicationArchives(Collection<AdditionalDependency> path) {
            this.additionalApplicationArchives.addAll(path);
            return this;
        }

        public Builder addAdditionalDeploymentArchive(Path path) {
            this.additionalDeploymentArchives.add(path);
            return this;
        }

        public Builder setFlatClassPath(boolean flatClassPath) {
            this.flatClassPath = flatClassPath;
            return this;
        }

        public Builder addExcludedPath(Path path) {
            this.excludeFromClassPath.add(path);
            return this;
        }

        public Builder setProjectRoot(Path projectRoot) {
            this.projectRoot = projectRoot;
            return this;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public Builder setOffline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder setTest(boolean test) {
            this.test = test;
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setHostApplicationIsTestOnly(boolean hostApplicationIsTestOnly) {
            this.hostApplicationIsTestOnly = hostApplicationIsTestOnly;
            return this;
        }

        public Builder setAuxiliaryApplication(boolean auxiliaryApplication) {
            this.auxiliaryApplication = auxiliaryApplication;
            return this;
        }

        public Builder setLocalProjectDiscovery(Boolean localProjectDiscovery) {
            this.localProjectDiscovery = localProjectDiscovery;
            return this;
        }

        public Builder setBaseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public Builder setBaseClassLoader(ClassLoader baseClassLoader) {
            this.baseClassLoader = baseClassLoader;
            return this;
        }

        public Builder setTargetDirectory(Path targetDirectory) {
            this.targetDirectory = targetDirectory;
            return this;
        }

        public Builder setAppModelResolver(AppModelResolver appModelResolver) {
            this.appModelResolver = appModelResolver;
            return this;
        }

        public Builder setDisableClasspathCache(boolean disableClasspathCache) {
            this.disableClasspathCache = disableClasspathCache;
            return this;
        }

        public Builder addParentFirstArtifact(ArtifactKey appArtifactKey) {
            this.parentFirstArtifacts.add(appArtifactKey);
            return this;
        }

        public Builder setAppArtifact(ResolvedDependency appArtifact) {
            if (this.applicationRoot != null) {
                throw new IllegalStateException("Cannot set both application root and app artifact");
            }
            this.appArtifact = appArtifact;
            this.applicationRoot = PathList.from((Iterable)appArtifact.getResolvedPaths());
            if (appArtifact.getResolvedPaths().isSinglePath()) {
                this.projectRoot = appArtifact.getResolvedPaths().getSinglePath();
            }
            return this;
        }

        public Builder setManagingProject(ArtifactCoords managingProject) {
            this.managingProject = managingProject;
            return this;
        }

        public Builder setIsolateDeployment(boolean isolateDeployment) {
            this.isolateDeployment = isolateDeployment;
            return this;
        }

        public Builder setMavenArtifactResolver(MavenArtifactResolver mavenArtifactResolver) {
            this.mavenArtifactResolver = mavenArtifactResolver;
            return this;
        }

        public Builder setForcedDependencies(List<Dependency> forcedDependencies) {
            this.forcedDependencies = forcedDependencies;
            return this;
        }

        public ApplicationModel getExistingModel() {
            return this.existingModel;
        }

        public Builder setExistingModel(ApplicationModel existingModel) {
            this.existingModel = existingModel;
            return this;
        }

        public Builder addLocalArtifact(ArtifactKey key) {
            this.localArtifacts.add(key);
            return this;
        }

        public Builder clearLocalArtifacts() {
            this.localArtifacts.clear();
            return this;
        }

        public Builder setRebuild(boolean value) {
            this.rebuild = value;
            return this;
        }

        public Builder addClassLoaderEventListeners(List<ClassLoaderEventListener> classLoadListeners) {
            this.classLoadListeners.addAll(classLoadListeners);
            return this;
        }

        public Builder setAssertionsEnabled(boolean assertionsEnabled) {
            this.assertionsEnabled = assertionsEnabled;
            return this;
        }

        private boolean inheritedAssertionsEnabled() {
            boolean result = false;
            if (!$assertionsDisabled) {
                result = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return result;
        }

        public QuarkusBootstrap build() {
            Objects.requireNonNull(this.applicationRoot, "Application root must not be null");
            if (this.appArtifact != null) {
                this.localArtifacts.add(this.appArtifact.getKey());
            }
            ConfiguredClassLoading classLoadingConfig = QuarkusBootstrap.createClassLoadingConfig(this.applicationRoot, this.mode, this.parentFirstArtifacts);
            if (classLoadingConfig.flatTestClassPath && this.mode == Mode.TEST) {
                this.flatClassPath = true;
            }
            return new QuarkusBootstrap(this, classLoadingConfig);
        }
    }
}

