/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.app;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.CurationResult;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.FilteredClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class CuratedApplication
implements Serializable,
AutoCloseable {
    private static final String AUGMENTOR = "io.quarkus.runner.bootstrap.AugmentActionImpl";
    private final Map<AppArtifact, List<ClassPathElement>> augmentationElements = new HashMap<AppArtifact, List<ClassPathElement>>();
    private volatile QuarkusClassLoader augmentClassLoader;
    private volatile QuarkusClassLoader baseRuntimeClassLoader;
    private final QuarkusBootstrap quarkusBootstrap;
    private final CurationResult curationResult;
    private final ConfiguredClassLoading configuredClassLoading;
    final AppModel appModel;

    CuratedApplication(QuarkusBootstrap quarkusBootstrap, CurationResult curationResult, ConfiguredClassLoading configuredClassLoading) {
        this.quarkusBootstrap = quarkusBootstrap;
        this.curationResult = curationResult;
        this.appModel = curationResult.getAppModel();
        this.configuredClassLoading = configuredClassLoading;
    }

    public AppModel getAppModel() {
        return this.appModel;
    }

    public QuarkusBootstrap getQuarkusBootstrap() {
        return this.quarkusBootstrap;
    }

    public boolean hasUpdatedDeps() {
        return this.curationResult.hasUpdatedDeps();
    }

    public List<AppDependency> getUpdatedDeps() {
        return this.curationResult.getUpdatedDependencies();
    }

    public Object runInAugmentClassLoader(String consumerName, Map<String, Object> params) {
        return this.runInCl(consumerName, params, this.getAugmentClassLoader());
    }

    public CurationResult getCurationResult() {
        return this.curationResult;
    }

    public AugmentAction createAugmentor() {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class).newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AugmentAction createAugmentor(String functionName, Map<String, Object> props) {
        try {
            Class<?> augmentor = this.getAugmentClassLoader().loadClass(AUGMENTOR);
            Function function = (Function)this.getAugmentClassLoader().loadClass(functionName).newInstance();
            List res = (List)function.apply(props);
            return (AugmentAction)augmentor.getConstructor(CuratedApplication.class, List.class).newInstance(this, res);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object runInCl(String consumerName, Map<String, Object> params, QuarkusClassLoader cl) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> clazz = cl.loadClass(consumerName);
            BiConsumer biConsumer = (BiConsumer)clazz.newInstance();
            biConsumer.accept(this, params);
            BiConsumer biConsumer2 = biConsumer;
            return biConsumer2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private synchronized void processCpElement(AppArtifact artifact, Consumer<ClassPathElement> consumer) {
        List<ClassPathElement> cpeList;
        if (!artifact.getType().equals("jar")) {
            consumer.accept(ClassPathElement.EMPTY);
            return;
        }
        final List<String> filteredResources = this.configuredClassLoading.removedResources.get(artifact.getKey());
        if (filteredResources != null) {
            final Consumer<ClassPathElement> old = consumer;
            consumer = new Consumer<ClassPathElement>(){

                @Override
                public void accept(ClassPathElement classPathElement) {
                    old.accept(new FilteredClassPathElement(classPathElement, filteredResources));
                }
            };
        }
        if ((cpeList = this.augmentationElements.get(artifact)) != null) {
            for (ClassPathElement cpe : cpeList) {
                consumer.accept(cpe);
            }
            return;
        }
        cpeList = new ArrayList<ClassPathElement>(2);
        for (Path path : artifact.getPaths()) {
            ClassPathElement element = ClassPathElement.fromPath(path);
            consumer.accept(element);
            cpeList.add(element);
        }
        this.augmentationElements.put(artifact, cpeList);
    }

    private void addCpElement(QuarkusClassLoader.Builder builder, AppArtifact dep, ClassPathElement element) {
        AppArtifactKey key = dep.getKey();
        if (this.appModel.getParentFirstArtifacts().contains(key) || this.configuredClassLoading.parentFirstArtifacts.contains(dep.getKey())) {
            builder.addParentFirstElement(element);
        } else if (this.appModel.getLesserPriorityArtifacts().contains(key)) {
            builder.addLesserPriorityElement(element);
        }
        builder.addElement(element);
    }

    public synchronized QuarkusClassLoader getAugmentClassLoader() {
        if (this.augmentClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Augmentation Class Loader: " + this.quarkusBootstrap.getMode(), this.quarkusBootstrap.getBaseClassLoader(), !this.quarkusBootstrap.isIsolateDeployment()).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled());
            builder.addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners());
            for (AppDependency appDependency : this.appModel.getFullDeploymentDeps()) {
                if (this.configuredClassLoading.reloadableArtifacts.contains(appDependency.getArtifact().getKey())) continue;
                this.processCpElement(appDependency.getArtifact(), element -> this.addCpElement(builder, appDependency.getArtifact(), (ClassPathElement)element));
            }
            for (Path path : this.quarkusBootstrap.getAdditionalDeploymentArchives()) {
                builder.addElement(ClassPathElement.fromPath(path));
            }
            HashMap<String, byte[]> banned = new HashMap<String, byte[]>();
            for (List<String> i : this.configuredClassLoading.removedResources.values()) {
                for (String j : i) {
                    banned.put(j, new byte[0]);
                }
            }
            builder.addBannedElement(new MemoryClassPathElement(banned));
            this.augmentClassLoader = builder.build();
        }
        return this.augmentClassLoader;
    }

    public synchronized QuarkusClassLoader getBaseRuntimeClassLoader() {
        if (this.baseRuntimeClassLoader == null) {
            QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Base Runtime ClassLoader: " + this.quarkusBootstrap.getMode(), this.quarkusBootstrap.getBaseClassLoader(), false).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled());
            builder.addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners());
            if (this.quarkusBootstrap.getMode() == QuarkusBootstrap.Mode.TEST && this.quarkusBootstrap.isFlatClassPath()) {
                for (Object root : this.quarkusBootstrap.getApplicationRoot()) {
                    builder.addElement(ClassPathElement.fromPath((Path)root));
                }
            } else {
                for (Object root : this.quarkusBootstrap.getApplicationRoot()) {
                    builder.addBannedElement(new ClassFilteredBannedElement(ClassPathElement.fromPath((Path)root)));
                }
            }
            HashSet<Path> hotReloadPaths = new HashSet<Path>();
            for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
                if (!i.isHotReloadable()) {
                    for (Path root : i.getArchivePath()) {
                        builder.addElement(ClassPathElement.fromPath(root));
                    }
                    continue;
                }
                for (Path root : i.getArchivePath()) {
                    hotReloadPaths.add(root);
                    builder.addBannedElement(new ClassFilteredBannedElement(ClassPathElement.fromPath(root)));
                }
            }
            builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap()));
            HashMap<String, byte[]> banned = new HashMap<String, byte[]>();
            for (List<String> i : this.configuredClassLoading.removedResources.values()) {
                for (String j : i) {
                    banned.put(j, new byte[0]);
                }
            }
            builder.addBannedElement(new MemoryClassPathElement(banned));
            for (AppDependency dependency : this.appModel.getUserDependencies()) {
                if (CuratedApplication.isHotReloadable(dependency.getArtifact(), hotReloadPaths) || this.configuredClassLoading.reloadableArtifacts.contains(dependency.getArtifact().getKey())) continue;
                this.processCpElement(dependency.getArtifact(), element -> this.addCpElement(builder, dependency.getArtifact(), (ClassPathElement)element));
            }
            this.baseRuntimeClassLoader = builder.build();
        }
        return this.baseRuntimeClassLoader;
    }

    private static boolean isHotReloadable(AppArtifact a, Set<Path> hotReloadPaths) {
        for (Path p : a.getPaths()) {
            if (!hotReloadPaths.contains(p)) continue;
            return true;
        }
        return false;
    }

    public QuarkusClassLoader createDeploymentClassLoader() {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Deployment Class Loader: " + this.quarkusBootstrap.getMode(), this.getAugmentClassLoader(), false).addClassLoaderEventListeners(this.quarkusBootstrap.getClassLoaderEventListeners()).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled()).setAggregateParentResources(true);
        for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
            builder.addElement(ClassPathElement.fromPath(root));
        }
        builder.setResettableElement(new MemoryClassPathElement(Collections.emptyMap()));
        for (AdditionalDependency i : this.quarkusBootstrap.getAdditionalApplicationArchives()) {
            for (Path root : i.getArchivePath()) {
                builder.addElement(ClassPathElement.fromPath(root));
            }
        }
        for (AppDependency dependency : this.appModel.getUserDependencies()) {
            if (!this.configuredClassLoading.reloadableArtifacts.contains(dependency.getArtifact().getKey())) continue;
            this.processCpElement(dependency.getArtifact(), element -> this.addCpElement(builder, dependency.getArtifact(), (ClassPathElement)element));
        }
        return builder.build();
    }

    public QuarkusClassLoader createRuntimeClassLoader(Map<String, byte[]> resources, Map<String, byte[]> transformedClasses) {
        return this.createRuntimeClassLoader(this.getBaseRuntimeClassLoader(), resources, transformedClasses);
    }

    public QuarkusClassLoader createRuntimeClassLoader(ClassLoader base, Map<String, byte[]> resources, Map<String, byte[]> transformedClasses) {
        QuarkusClassLoader.Builder builder = QuarkusClassLoader.builder("Quarkus Runtime ClassLoader: " + this.quarkusBootstrap.getMode(), this.getBaseRuntimeClassLoader(), false).setAssertionsEnabled(this.quarkusBootstrap.isAssertionsEnabled()).setAggregateParentResources(true);
        builder.setTransformedClasses(transformedClasses);
        builder.addElement(new MemoryClassPathElement(resources));
        for (Path root : this.quarkusBootstrap.getApplicationRoot()) {
            builder.addElement(ClassPathElement.fromPath(root));
        }
        for (AdditionalDependency i : this.getQuarkusBootstrap().getAdditionalApplicationArchives()) {
            if (!i.isHotReloadable()) continue;
            for (Path root : i.getArchivePath()) {
                builder.addElement(ClassPathElement.fromPath(root));
            }
        }
        for (AppDependency dependency : this.appModel.getUserDependencies()) {
            if (!this.configuredClassLoading.reloadableArtifacts.contains(dependency.getArtifact().getKey())) continue;
            this.processCpElement(dependency.getArtifact(), element -> this.addCpElement(builder, dependency.getArtifact(), (ClassPathElement)element));
        }
        return builder.build();
    }

    @Override
    public void close() {
        if (this.augmentClassLoader != null) {
            this.augmentClassLoader.close();
        }
        if (this.baseRuntimeClassLoader != null) {
            this.baseRuntimeClassLoader.close();
        }
    }

    static class ClassFilteredBannedElement
    implements ClassPathElement {
        private final ClassPathElement delegate;

        ClassFilteredBannedElement(ClassPathElement delegate) {
            this.delegate = delegate;
        }

        @Override
        public Path getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public ClassPathResource getResource(String name) {
            if (!name.endsWith(".class")) {
                return null;
            }
            return this.delegate.getResource(name);
        }

        @Override
        public Set<String> getProvidedResources() {
            return this.delegate.getProvidedResources().stream().filter(s -> s.endsWith(".class")).collect(Collectors.toSet());
        }

        @Override
        public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
            return this.delegate.getProtectionDomain(classLoader);
        }

        @Override
        public Manifest getManifest() {
            return this.delegate.getManifest();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

