/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassLoaderEventListener;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ClassLoaderLimiter
implements ClassLoaderEventListener {
    private final ConcurrentMap<String, String> atMostOnceResourcesLoaded = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> allResourcesLoaded = new ConcurrentHashMap<String, String>();
    private final Set<String> vetoedResources;
    private final Set<String> vetoedClasses;
    private final Set<String> atMostOnceResources;
    private final Set<String> onHitPrintStacktrace;
    private final boolean traceAllResourceLoad;

    private ClassLoaderLimiter(Builder builder) {
        this.vetoedClasses = builder.vetoedClasses;
        this.vetoedResources = builder.vetoedResources;
        this.atMostOnceResources = builder.atMostOnceResources;
        this.onHitPrintStacktrace = builder.onHitPrintStacktrace;
        this.traceAllResourceLoad = builder.traceAllResourceLoad;
    }

    @Override
    public void openResourceStream(String resourceName, String classLoaderName) {
        String previousLoadEvent;
        Objects.requireNonNull(resourceName);
        Objects.requireNonNull(classLoaderName);
        if (this.traceAllResourceLoad) {
            System.out.println("Opening resource: " + resourceName);
        }
        if (this.onHitPrintStacktrace.contains(resourceName)) {
            RuntimeException e = new RuntimeException("Tracing load of resource: " + resourceName);
            e.printStackTrace();
        }
        if (this.vetoedResources.contains(resourceName)) {
            throw new IllegalStateException("Attempted to load vetoed resource '" + resourceName + "' from classloader " + classLoaderName);
        }
        if (this.atMostOnceResources.contains(resourceName) && (previousLoadEvent = this.atMostOnceResourcesLoaded.put(resourceName, classLoaderName)) != null) {
            throw new IllegalStateException("Resource being loaded more than once: " + resourceName + ".\nAttempted load by " + classLoaderName + ", recorded previous load by " + previousLoadEvent);
        }
        if (resourceName.endsWith(".class")) {
            return;
        }
        String previousLoad = this.allResourcesLoaded.put(resourceName, classLoaderName);
        if (previousLoad != null) {
            System.out.println("Resource loaded multiple times: " + resourceName + ". Currently being loaded by " + classLoaderName + ", previous loaded by " + previousLoad);
        }
    }

    @Override
    public void loadClass(String className, String classLoaderName) {
        if (this.vetoedClasses.contains(className)) {
            throw new IllegalStateException("Attempted to load vetoed class '" + className + "' from classloader " + classLoaderName);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ClassLoaderLimiterConsistencyException
    extends IllegalArgumentException {
        public ClassLoaderLimiterConsistencyException(String detail) {
            super("ClassLoaderLimiter definition inconsistency: " + detail);
        }
    }

    public static class Builder {
        private final Set<String> vetoedResources = new TreeSet<String>();
        private final Set<String> vetoedClasses = new TreeSet<String>();
        private final Set<String> atMostOnceResources = new TreeSet<String>();
        private final Set<String> onHitPrintStacktrace = new TreeSet<String>();
        private boolean traceAllResourceLoad = false;

        private Builder() {
        }

        public Builder neverLoadedResource(String resourceFullName) {
            Objects.requireNonNull(resourceFullName);
            boolean add = this.vetoedResources.add(resourceFullName);
            if (!add) {
                throw new ClassLoaderLimiterConsistencyException("resource listed multiple times as never loaded: " + resourceFullName);
            }
            if (this.atMostOnceResources.contains(resourceFullName)) {
                throw new ClassLoaderLimiterConsistencyException(resourceFullName + " is being listed both as never loaded and as at most once");
            }
            return this;
        }

        public Builder neverLoadedClassName(String vetoedClassName) {
            Objects.requireNonNull(vetoedClassName);
            boolean add = this.vetoedClasses.add(vetoedClassName);
            if (!add) {
                throw new ClassLoaderLimiterConsistencyException("never loaded class listed multiple times: " + vetoedClassName);
            }
            return this;
        }

        public Builder loadedAtMostOnceResource(String resourceFullName) {
            Objects.requireNonNull(resourceFullName);
            boolean add = this.atMostOnceResources.add(resourceFullName);
            if (!add) {
                throw new ClassLoaderLimiterConsistencyException("resource listed multiple times as loaded at most once: " + resourceFullName);
            }
            if (this.vetoedResources.contains(resourceFullName)) {
                throw new ClassLoaderLimiterConsistencyException(resourceFullName + " is being listed both as never loaded and as at most once");
            }
            return this;
        }

        public Builder produceStackTraceOnLoad(String resourceFullName) {
            Objects.requireNonNull(resourceFullName);
            boolean add = this.onHitPrintStacktrace.add(resourceFullName);
            if (!add) {
                throw new ClassLoaderLimiterConsistencyException("resource listed multiple times to produce a stacktrace: " + resourceFullName);
            }
            return this;
        }

        public Builder traceAllResourceLoad(boolean enable) {
            this.traceAllResourceLoad = enable;
            return this;
        }

        public ClassLoaderLimiter build() {
            return new ClassLoaderLimiter(this);
        }
    }
}

