/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.spi.NonBlockingProvider;
import io.smallrye.mutiny.Uni;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public class NonBlockingSupport {
    private static final NonBlockingProvider PROVIDER;
    public static final String ERROR_MSG = "Failed to find any non-blocking provider for startup actions. Either import the quarkus-vertx module, or do not declare non-blocking startup actions.";

    public static <T> T subscribeAndAwait(Supplier<Uni<T>> uniSupplier) throws Throwable {
        if (PROVIDER == null) {
            throw new RuntimeException(ERROR_MSG);
        }
        return PROVIDER.subscribeAndAwait(uniSupplier);
    }

    static {
        ServiceLoader<NonBlockingProvider> loader = ServiceLoader.load(NonBlockingProvider.class);
        Optional<NonBlockingProvider> first = loader.findFirst();
        PROVIDER = first.isEmpty() ? null : first.get();
    }
}

