/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.undertow.UndertowLogger;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.IoCallback;
import io.undertow.httpcore.OutputChannel;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.IoUtils;
import io.undertow.util.MimeMappings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class URLResource
implements Resource,
RangeAwareResource {
    private final URL url;
    private final String path;
    private boolean connectionOpened = false;
    private Date lastModified;
    private Long contentLength;

    @Deprecated
    public URLResource(URL url, URLConnection connection, String path) {
        this(url, path);
    }

    public URLResource(URL url, String path) {
        this.url = url;
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Date getLastModified() {
        this.openConnection();
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConnection() {
        if (!this.connectionOpened) {
            this.connectionOpened = true;
            URLConnection connection = null;
            try {
                try {
                    connection = this.url.openConnection();
                }
                catch (IOException e) {
                    this.lastModified = null;
                    this.contentLength = null;
                    if (connection != null) {
                        try {
                            IoUtils.safeClose((Closeable)connection.getInputStream());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return;
                }
                if (this.url.getProtocol().equals("jar")) {
                    connection.setUseCaches(false);
                    URL jar = ((JarURLConnection)connection).getJarFileURL();
                    this.lastModified = new Date(new File(jar.getFile()).lastModified());
                } else {
                    this.lastModified = new Date(connection.getLastModified());
                }
                this.contentLength = connection.getContentLengthLong();
            }
            finally {
                if (connection != null) {
                    try {
                        IoUtils.safeClose((Closeable)connection.getInputStream());
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public String getLastModifiedString() {
        return DateUtils.toDateString(this.getLastModified());
    }

    @Override
    public ETag getETag() {
        return null;
    }

    @Override
    public String getName() {
        int sepIndex;
        String path = this.url.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sepIndex = path.lastIndexOf("/")) != -1) {
            path = path.substring(sepIndex + 1);
        }
        return path;
    }

    @Override
    public boolean isDirectory() {
        Path file = this.getFilePath();
        if (file != null) {
            return Files.isDirectory(file, new LinkOption[0]);
        }
        return this.url.getPath().endsWith("/");
    }

    @Override
    public List<Resource> list() {
        LinkedList<Resource> result;
        block15: {
            result = new LinkedList<Resource>();
            Path file = this.getFilePath();
            try {
                if (file == null) break block15;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(file);){
                    for (Path child : stream) {
                        result.add(new URLResource(child.toUri().toURL(), child.toString()));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public String getContentType(MimeMappings mimeMappings) {
        String fileName = this.getName();
        int index = fileName.lastIndexOf(46);
        if (index != -1 && index != fileName.length() - 1) {
            return mimeMappings.getMimeType(fileName.substring(index + 1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveBlocking(OutputStream sender, HttpServerExchange exchange) throws IOException {
        ByteBuf buffer = exchange.allocateBuffer(false);
        try (InputStream in = this.url.openStream();){
            int r;
            while ((r = in.read(buffer.array(), buffer.arrayOffset(), buffer.writableBytes())) > 0) {
                sender.write(buffer.array(), buffer.arrayOffset(), r);
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void serveAsync(OutputChannel stream, HttpServerExchange exchange) {
        this.serveImpl(stream, exchange, -1L, -1L, false);
    }

    public void serveImpl(final OutputChannel stream, final HttpServerExchange exchange, final long start, final long end, final boolean range) {
        class ServerTask
        implements Runnable,
        IoCallback<Void> {
            private InputStream inputStream;
            private byte[] buffer;
            long toSkip;
            long remaining;

            ServerTask() {
                this.toSkip = start;
                this.remaining = end - start + 1L;
            }

            @Override
            public void run() {
                if (range && this.remaining == 0L) {
                    IoUtils.safeClose((Closeable)this.inputStream);
                    exchange.endExchange();
                    return;
                }
                if (this.inputStream == null) {
                    try {
                        this.inputStream = URLResource.this.url.openStream();
                    }
                    catch (IOException e) {
                        exchange.setStatusCode(500);
                        return;
                    }
                    this.buffer = new byte[1024];
                    exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                        @Override
                        public void exchangeEvent(HttpServerExchange exchange) {
                            IoUtils.safeClose((Closeable)inputStream);
                        }
                    });
                }
                try {
                    int res = this.inputStream.read(this.buffer);
                    if (res == -1) {
                        IoUtils.safeClose((Closeable)this.inputStream);
                        exchange.endExchange();
                        return;
                    }
                    int bufferStart = 0;
                    int length = res;
                    if (range && this.toSkip > 0L) {
                        while (this.toSkip > (long)res) {
                            this.toSkip -= (long)res;
                            res = this.inputStream.read(this.buffer);
                            if (res != -1) continue;
                            IoUtils.safeClose((Closeable)this.inputStream);
                            exchange.endExchange();
                            return;
                        }
                        bufferStart = (int)this.toSkip;
                        length = (int)((long)length - this.toSkip);
                        this.toSkip = 0L;
                    }
                    if (range && (long)length > this.remaining) {
                        length = (int)this.remaining;
                    }
                    this.remaining -= (long)length;
                    stream.writeAsync(Unpooled.wrappedBuffer((byte[])this.buffer, (int)bufferStart, (int)length), this.remaining == 0L, (IoCallback)this, null);
                }
                catch (IOException e) {
                    exchange.endExchange();
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                }
            }

            public void onComplete(HttpExchange ex, Void context) {
                if (exchange.isInIoThread()) {
                    exchange.dispatch(this);
                } else {
                    this.run();
                }
            }

            public void onException(HttpExchange exchange2, Void context, IOException exception) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                exchange2.close();
            }
        }
        ServerTask serveTask = new ServerTask();
        if (exchange.isInIoThread()) {
            exchange.dispatch(serveTask);
        } else {
            serveTask.run();
        }
    }

    @Override
    public Long getContentLength() {
        this.openConnection();
        return this.contentLength;
    }

    @Override
    public String getCacheKey() {
        return this.url.toString();
    }

    @Override
    public File getFile() {
        Path path = this.getFilePath();
        return path != null ? path.toFile() : null;
    }

    @Override
    public Path getFilePath() {
        if (this.url.getProtocol().equals("file")) {
            try {
                return Paths.get(this.url.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public File getResourceManagerRoot() {
        return null;
    }

    @Override
    public Path getResourceManagerRootPath() {
        return null;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serveRangeBlocking(OutputStream sender, HttpServerExchange exchange, long start, long end) throws IOException {
        ByteBuf buffer = exchange.allocateBuffer(false);
        int pos = 0;
        try (InputStream in = this.url.openStream();){
            int r;
            while ((r = in.read(buffer.array(), buffer.arrayOffset(), buffer.writableBytes())) > 0) {
                int toEat;
                int sw = (long)pos < start ? ((toEat = (int)(start - (long)pos)) > r ? -1 : toEat) : 0;
                int rem = (int)(end - Math.max((long)pos, start)) + 1;
                if (rem <= 0) {
                    sender.close();
                    return;
                }
                int ew = r > rem ? rem : r;
                if (sw != -1) {
                    sender.write(buffer.array(), buffer.arrayOffset() + sw, ew);
                }
                pos += r;
            }
            sender.close();
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void serveRangeAsync(OutputChannel outputStream, HttpServerExchange exchange, long start, long end) {
        this.serveImpl(outputStream, exchange, start, end, true);
    }

    @Override
    public boolean isRangeSupported() {
        return true;
    }
}

