/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.ResourceUtils;
import java.io.IOException;
import java.lang.constant.ClassDesc;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

@FunctionalInterface
public interface ClassOutput {
    default public void write(ClassDesc desc, byte[] bytes) {
        if (!desc.isClassOrInterface()) {
            throw new IllegalArgumentException("Can only write classes/interfaces");
        }
        this.write(Util.internalName(desc) + ".class", bytes);
    }

    public void write(String var1, byte[] var2);

    default public ClassOutput andThen(final ClassOutput next) {
        Assert.checkNotNullParam((String)"next", (Object)next);
        return new ClassOutput(){

            @Override
            public void write(ClassDesc desc, byte[] bytes) {
                ClassOutput.this.write(desc, bytes);
                next.write(desc, bytes);
            }

            @Override
            public void write(String path, byte[] bytes) {
                ClassOutput.this.write(path, bytes);
                next.write(path, bytes);
            }
        };
    }

    public static ClassOutput fileWriter(Path basePath) {
        Assert.checkNotNullParam((String)"basePath", (Object)basePath);
        return (name, bytes) -> {
            try {
                Path path = basePath.resolve(ResourceUtils.canonicalizeRelativePath((String)name));
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to write class %s".formatted(name), e);
            }
        };
    }
}

